<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2005 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: install.mambelfish.php,v 1.4 2005/03/16 13:45:34 akede Exp $
//
// Don't allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

global $mosConfig_absolute_path;

function com_install()
{
	global $_VERSION, $database, $mosConfig_absolute_path;
	
	// Patching the core
	$patchPath = dirname(__FILE__) ."/patch";
	$patchPath .= '/'. $_VERSION->RELEASE .'.'. substr( $_VERSION->DEV_LEVEL, 0, 1);
	if( file_exists( $patchPath ) ) {
		$success = patchFiles( $patchPath );
	} else {
		$success = false;
	}

	// Modify the admin icons
	$database->setQuery( "SELECT id FROM #__components WHERE name= 'Mambel Fish'" );
	$id = $database->loadResult();
	
	//add new admin menu images
	@copy($mosConfig_absolute_path .'/components/com_mambelfish/images/mambelfish_icon.png', $mosConfig_absolute_path .'/includes/js/ThemeOffice/mambelfish.png');
	$database->setQuery( "UPDATE #__components SET admin_menu_img = 'js/ThemeOffice/mambelfish.png' WHERE id='$id'");
	$database->query();
	$database->setQuery( "UPDATE #__components SET admin_menu_img = 'js/ThemeOffice/content.png', name = '<b>Translation</b>' WHERE parent='$id' AND name = 'Translation'");
	$database->query();
	$database->setQuery( "UPDATE #__components SET admin_menu_img = 'js/ThemeOffice/config.png', name = '<b>Language configuration</b>' WHERE parent='$id' AND name = 'Language configuration'");
	$database->query();
	$database->setQuery( "UPDATE #__components SET admin_menu_img = 'js/ThemeOffice/controlpanel.png' WHERE parent='$id' AND name = 'Content element configuration'");
	$database->query();
	$database->setQuery( "UPDATE #__components SET admin_menu_img = 'js/ThemeOffice/credits.png' WHERE parent='$id' AND name = 'About'");
	$database->query();

	// Information text
	require( dirname(__FILE__) . "/mambelfish.class.php");
	require( dirname(__FILE__) . "/admin.mambelfish.html.php");
	HTML_mambelfish_help::showPostInstall( $success );
	
	return;
}

/** This function is patching the original files
 * The path will be scaned for .php which will be backuped & replaced
 * - If the original file couldn't be found for backup this is no problem
 * - If the new file couldn't replace the old one an error occurs and the function
 *   returns false
 * - subdirectories will be patched recursivly
 *
 * @param	string	path to the directory of the files
 * @return	boolean	success for all files & directories
 */
function patchFiles( $patchPath, $subPath="" ) {
	global $mosConfig_absolute_path;
	$success = true;
	
	$filesindir = mosReadDirectory( "$patchPath/$subPath" ,"");
	foreach ($filesindir as $filename) {
		$filePath = ($subPath!="" ? "$subPath/" : "") .$filename;
		if( is_dir( "$patchPath/$filePath" ) ) {
			$success = patchFiles( $patchPath, $filePath );
		} else {
			@copy( "$mosConfig_absolute_path/$filePath", "$patchPath/$filePath.bak");					//Backup
			$success = @copy( "$patchPath/$filePath", "$mosConfig_absolute_path/$filePath");			//Replace
		}

		if( !$success ) break;
	}
	return $success;
}
?>