<?php
/**
 * toolbar.mamml.php
 * 
 * <p>Creates an administrative toolbar for the MaMML backend.</p>
 * 
 * @package MaMML
 * @subpackage backend
 * @copyright  2004-2005 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.4.5
 * @since 0.4.3
 * @link http://www.schmalls.com
 */

 /**
  * Makes sure this is included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

 /**
  * Include required files
  */
 require_once( $mainframe->getPath( 'toolbar_html' ) );
 require_once( $mainframe->getPath( 'toolbar_default' ) );
 
 // get parameters
 $action = mosGetParam($_REQUEST, 'act', '');
 $task = mosGetParam($_REQUEST, 'task', '');
 $listid = mosGetParam($_REQUEST, 'listid', 0);
 
 // switch by action
 switch ($action) {
	 case ('unregistered') :
	 	// switch by task
	 	switch ($task) {
			case ('import') :
				menunewsletter :: IMPORT();
				break;
			case ('doExport') :
				break;
			case ('export') :
				menunewsletter :: EXPORT();
				break;
			case ('new') :
				menunewsletter :: NEWSUBSCRIBER();
				break;
			default :
				menunewsletter :: UNREGISTERED();
				break;
	 	} // end switch
	 	break;
	 case ('registered') :
	 	// switch by task
	 	switch ($task) {
			case ('new') :
				menunewsletter :: NEWSUBSCRIBER();
				break;
			default :
	 			menunewsletter :: REGISTERED();
				break;
	 	} // end switch
	 	break;
	 case ('newsletter') :
	 	// switch by task
	 	switch ($task) {
			case ('new') :
				menunewsletter :: NEWNEWSLETTER('');
				break;
			case ('edit') :
				menunewsletter :: EDITNEWSLETTER('');
				break;
			default:
				menunewsletter :: NEWSLETTER();
				break;
	 	} // end switch
	 	break;
	 case ('mailing') :
	 	// switch by task
	 	switch ($task) {
			case ('edit') :
				menunewsletter :: NEWMAILING('');
				break;
			case ('preview') :
				menunewsletter :: PREVIEWMAILING('edit');
				break;
			case ('viewarchive') :
				// check if senddate was provided
				$senddate = mosGetParam($_REQUEST, 'senddate', 0);
				if ($senddate != 0) {
					// if so, show mailing options
					menunewsletter :: CANCEL_ONLY('viewarchive');
				} else {
					// if not, show mailings options
					menunewsletter :: ARCHIVE_MAILINGS();
				} // end if
				break;
			case ('publish') :
				menunewsletter :: CANCEL_ONLY('');
				break;
			default :
				menunewsletter :: MAILING();
				break;
	 	} // end switch
	 	break;
	 case ('configuration') :
	 	// switch by task
	 	switch ($task) {
			case ('save') :
				break;
			default :
				menunewsletter :: CONFIGURATION();
				break;
	 	} // end switch
	 	break;
	 case ('statistics') :
	 	// switch by task
	 	switch ($task) {
			case ('show') :
				menunewsletter :: CANCEL_ONLY('cancel');
				break;
			default :
				// check if list id was supplied
				if ($listid != 0) {
					// if so, show statistics menu
					menunewsletter :: STATISTICS();
				} else {
					// if not, show mailing menu
					menunewsletter :: MAILING();
				} // end if
				break;
	 	} // end switch
	 	break;
	 case ('update') :
	 	// switch by task
	 	switch ($task) {
			case ('doUpdate'):
				menunewsletter :: CANCEL_ONLY('');
				break;
			default :
				menunewsletter :: UPDATE();
				break;
	 	} // end switch
	 	break;
	 default :
	 
	 	break; 
 } // end switch
 
?>