<?php
/**
 * toolbar.mamml.html.php
 * 
 * <p>Includes {@link menunewsletter} class.</p>
 * 
 * @package MaMML
 * @subpackage backend
 * @copyright  2004-2005 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.4.11
 * @since 0.4.3
 * @link http://www.schmalls.com
 */
 
 /**
  *  Ensures this file is being included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');
 
 /**
  * Class to display html toolbars for backend
  * 
  * <p>Creates the html toolbars using the mosMenuBar class.</p>
  * 
  * @package MaMML
  * @subpackage backend
  * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
  * @version 0.4.11
  * @since 0.4.3
  */
 class menunewsletter {
	 
	 /**
	  * Displays unregistered subscribers toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function UNREGISTERED() {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('export', 'archive.png', 'archive_f2.png', 'Export', false);
		 mosMenuBar::custom('import', 'upload.png', 'upload_f2.png', 'Import', false);
		 mosMenuBar::divider();
		 mosMenuBar::addNew();
		 mosMenuBar::custom('update', 'save.png', 'save_f2.png', 'Update', true);
		 mosMenuBar::custom('delete', 'delete.png', 'delete_f2.png', 'Delete', true);
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays registered subscribers toolbar
	  * 
	  * @version 0.4.11
	  * @since 0.4.3
	  */
	 function REGISTERED() {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('update', 'save.png', 'save_f2.png', 'Update', true);
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays import toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function IMPORT() {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('doImport', 'upload.png', 'upload_f2.png', 'Import', false);
		 mosMenuBar::back();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays export toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function EXPORT() {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('doExport', 'archive.png', 'archive_f2.png', 'Export', false);
		 mosMenuBar::back();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays new subscriber toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function NEWSUBSCRIBER() {
		 mosMenuBar::startTable();
		 mosMenuBar::save('doNew', 'Save');
		 mosMenuBar::back();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays newsletter toolbar
	  * 
	  * @version 0.4.11
	  * @since 0.4.3
	  */
	 function NEWSLETTER() {
		 mosMenuBar::startTable();
		 mosMenuBar::addNew();
		 mosMenuBar::editList();
		 mosMenuBar::custom('delete', 'delete.png', 'delete_f2.png', 'Delete', true);
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays newsletter editing toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function EDITNEWSLETTER($task) {
		 mosMenuBar::startTable();
		 mosMenuBar::save('update', 'Save');
		 mosMenuBar::cancel($task);
		 mosMenuBar::endTable();
	 } // end fucntion
	 
	 /**
	  * Displays new newsletter toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function NEWNEWSLETTER($task) {
		 mosMenuBar::startTable();
		 mosMenuBar::save('doNew', 'Save');
		 mosMenuBar::cancel($task);
		 mosMenuBar::endTable();
	 } // end fucntion
	 
	 /**
	  * Displays mailing toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function MAILING() {
		 mosMenuBar::startTable();
		 mosMenuBar::editList();
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 }
	 
	 /**
	  * Displays the new mailing toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function NEWMAILING($task) {
		mosMenuBar::startTable();
		mosMenuBar::media_manager('newsletter'); // this isn't working :S files will always be put in root, no mather what directory i specify
		mosMenuBar::divider();
		mosMenuBar::publish();
		mosMenuBar::custom('preview', 'preview.png', 'preview_f2.png', 'Preview', false);
		mosMenuBar::divider();
		mosMenuBar::save();
		mosMenuBar::cancel($task);
		mosMenuBar::divider();
		mosMenuBar::custom('viewarchive', 'move.png', 'move_f2.png', 'View archive', false);
		mosMenuBar::endTable(); 
	 }
	 
	 /**
	  * Displays the preview mailing toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function PREVIEWMAILING($task) {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('preview', 'preview.png', 'preview_f2.png', 'Preview', false);
		 mosMenuBar::cancel($task);
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays the preview mailing toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function CONFIGURATION() {
		 mosMenuBar::startTable();
		 mosMenuBar::save();
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays the show mailing statistics toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function CANCEL_ONLY($task) {
		 mosMenuBar::startTable();
		 mosMenuBar::cancel($task);
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays the statistics toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function STATISTICS() {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('show', 'move.png', 'move_f2.png', 'View stats', true);
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays the view archive mailings toolbar
	  * 
	  * @version 0.4.8
	  * @since 0.4.3
	  */
	 function ARCHIVE_MAILINGS() {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('viewarchive', 'move.png', 'move_f2.png', 'View', true);
		 mosMenuBar::custom('archivedelete', 'delete.png', 'delete_f2.png', 'Delete', true);
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 } // end function
	 
	 /**
	  * Displays the update toolbar
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  */
	 function UPDATE() {
		 mosMenuBar::startTable();
		 mosMenuBar::custom('doUpdate', 'upload.png', 'upload_f2.png', 'Update', false);
		 mosMenuBar::cancel();
		 mosMenuBar::endTable();
	 } // end function
 } // end class
 
?>