<?php
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: ps_module.php,v 1.3 2005/01/27 19:33:40 soeren_nb Exp $
* @package mambo-phpShop
* Contains code from PHPShop(tm):
* 	@copyright (C) 2000 - 2004 Edikon Corporation (www.edikon.com)
*	Community: www.phpshop.org, forums.phpshop.org
* Conversion to Mambo and the rest:
* 	@copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*/

class ps_module {
  var $classname = "ps_module";
  var $error;
  

/**************************************************************************
   * name: validate_add()
   * created by: pablo
   * description: validate the given data before adding a function record
   * parameters:
   * returns:
**************************************************************************/

  function validate_add(&$d) {
    global $db;
    
    if (!$d[ 'module_name' ]) {
      $this->error = "ERROR:  You must enter a name for the module.";
      return False;	
    }
    if ($d[ 'module_name' ]) {
      $q = "SELECT count(*) as rowcnt from #__pshop_module where module_name='" .  $d[ 'module_name' ] . "'";
      $db->setQuery($q);
      $db->next_record();
      if ($db->f("rowcnt") > 0) {
	$this->error = "The given module name already exists.";
	return False;
      }      
    }
    
    if (!$d[ 'module_perms' ]) {
      $this->error = "ERROR:  You must enter permissions for the module.";
      return false;	
    }
    if (!$d[ 'list_order' ]) {
      $d[ 'list_order' ] = "99";
    }
    return True;    
  }

/**************************************************************************
   * name: validate_delete()
   * created by: pablo
   * description: validate the given data before deleting a function record
   * parameters:
   * returns:
**************************************************************************/

  function validate_delete($d) {
    
    if (!$d[ 'module_id' ]) {
      $this->error = "ERROR:  Please select a module to delete.";
      return False;
    }
    else {
      return True;
    }
  }
  
  
/**************************************************************************
   * name: validate_update()
   * created by: pablo
   * description: validate the given data before updating a function record
   * parameters:
   * returns:
**************************************************************************/

  function validate_update(&$d) {
    
    if (!$d[ 'module_name' ]) {
      $this->error = "ERROR:  You must enter a name for the module.";
      return False;	
    }
    if (!$d[ 'module_perms' ]) {
      $this->error = "ERROR:  You must enter permissions for the module.";
      return False;	
    }
    if (!$d[ 'list_order' ]) {
      $d[ 'list_order' ] = "99";
    }
    return True;
  }
  
  
  /**************************************************************************
   * name: add()
   * created by: pablo
   * description: creates a new function record
   * parameters:
   * returns:
   **************************************************************************/
  function add(&$d) {
	global $db;
  
    $hash_secret="PHPShopIsCool";
    
    $timestamp = time();
    
    if (!$this->validate_add($d)) {
      $d[ 'error' ] = $this->error;
      return False;
    }
    
    foreach ($d as $key => $value)
        $d[$key] = addslashes($value);
        
    $q = "INSERT INTO #__pshop_module (module_name, module_description, ";
    $q .= "module_perms, module_header, ";
    $q .= "module_publish, list_order, module_footer, ";
    $q .= "module_label_1) ";
    $q .= " VALUES ('";
    $q .= $d[ 'module_name' ] . "','";
    $q .= $d[ 'module_description' ] . "','";
    $q .= $d[ 'module_perms' ] . "','";
    $q .= $d[ 'module_header' ] . "','";
    $q .= $d[ 'module_publish' ] . "','";
    $q .= $d[ 'list_order' ] . "','";
    $q .= $d[ 'module_footer' ] . "','";
    $q .= $d[ 'module_label_1' ] . "')";
    
    $db->setQuery($q);
    $db->query();
    return True;

  }
  
  /**************************************************************************
   * name: update()
   * created by: pablo
   * description: updates function information
   * parameters:
   * returns:
   **************************************************************************/
  function update(&$d) {
    global $db;
    
    $timestamp = time();

    if (!$this->validate_update($d)) {
      $d[ 'error' ] = $this->error;
      return False;	
    }
    
    foreach ($d as $key => $value) {
        if (!is_array($value))
          $d[$key] = addslashes($value);
    }
        
    $q = "UPDATE #__pshop_module SET ";
    $q .= "module_name='" . $d[ 'module_name' ];
    $q .= "',module_perms='" . $d[ 'module_perms' ];
    $q .= "',module_description='" . $d[ 'module_description' ];
    $q .= "',module_header='" . $d[ 'module_header' ];
    $q .= "',module_footer='" . $d[ 'module_footer' ];
    $q .= "',module_publish='" . $d[ 'module_publish' ];
    $q .= "',list_order='" . $d[ 'list_order' ];
    $q .= "',module_label_1='" . $d[ 'module_label_1' ];
    $q .= "' WHERE module_id='" . $d[ 'module_id' ] . "'";
    
    $db->setQuery($q);
    
    $db->query();
    
    return true;
  }

  /**************************************************************************
   * name: delete()
   * created by: pablo
   * description: Should delete a category and and categories under it.
   * parameters: 
   * returns:
   **************************************************************************/
  function delete(&$d) {
    global $db;
    
    if (!$this->validate_delete($d)) {
      $d[ 'error' ]=$this->error;
      return False;
    }
    $q = "DELETE from #__pshop_function WHERE module_id='" . $d[ 'module_id' ] . "'";
    $db->setQuery($q);
    $db->query();

    $q = "DELETE FROM #__pshop_module where module_id='" . $d[ 'module_id' ] . "'";
    $db->setQuery($q);
    $db->query();
    return true;
  }

  /**************************************************************************
   * name: get_dir()
   * created by: pablo
   * description: 
   * parameters: 
   * returns:
   **************************************************************************/
  function get_dir($basename) {
    $datab = new ps_DB;
    
    $results = array();
    
    $q = "SELECT * FROM #__pshop_module where module_name='".$basename."'";
   
    $datab->setQuery($q);
    $datab->query();
    
    
    if ($datab->next_record()) {
      $results[ 'perms' ] = $datab->f("module_perms");
      return $results;
    }
    else {
      return false;
    }
  }

}

?>
