<?php
/**
* mambo-phphop Main Module
* NOTE: THIS MODULE REQUIRES AN INSTALLED MAMBO-PHPSHOP COMPONENT!
*
* @version $Id: mod_phpshop.php,v 1.10 2004/12/22 17:38:05 soeren_nb Exp $
* @package Mambo_4.5.1
* @subpackage mambo-phpShop
* 
* @copyright (C) 2004 Soeren Eberhardt
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
*
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*/

defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/* Get module parameters */
if( defined ("_RELEASE") ) {
  /* Mambo 4.5 1.0.9 Workaround */
  if( _RELEASE == '4.5' ) {
    $show_listall = isset($params->show_listall) ? $params->show_listall : "yes";
    $show_minicart = isset($params->show_minicart) ? $params->show_minicart : "yes";
    $show_productsearch = isset($params->show_productsearch) ? $params->show_productsearch : "yes";
    $menutype = isset($params->menutype) ? $params->menutype : "links";
    $class_sfx = isset($params->class_sfx) ? $params->class_sfx : "";
    $pretext = isset($params->pretext) ? $params->pretext : "";
    $_REQUEST['root_label'] = isset($params->root_label) ? $params->root_label : 'Shop';
  }
}
else {
  $show_listall = $params->get( 'show_listall' );
  $show_minicart = $params->get( 'show_minicart' );
  $show_productsearch = $params->get( 'show_productsearch' );
  $menutype = $params->get( 'menutype' );
  $class_sfx = $params->get( 'class_sfx', '' );
  $pretext = $params->get( 'pretext', '' );
  $_REQUEST['root_label'] = $params->get( 'root_label', 'Shop' );
}
$class_mainlevel = "mainlevel".$class_sfx;



/* Load the phpshop main parse code */
require_once( $mosConfig_absolute_path.'/components/com_phpshop/phpshop_parser.php' );

global $PHPSHOP_LANG, $sess;

  // update the cart because something could have 
  // changed while running a function
  $cart = $_SESSION["cart"];
  $auth = $_SESSION["auth"];
  $sess = new ps_session;

/* MENUTPYE LINK LIST,     ELSE dTREE ! */
if ( $menutype == 'links' ) {

  // Show only top level categories and categories that are
  // being published
  $query  = "SELECT * FROM #__pshop_category, #__pshop_category_xref ";
  $query .= "WHERE #__pshop_category.category_publish='Y' AND ";
  $query .= "(#__pshop_category_xref.category_parent_id='' OR #__pshop_category_xref.category_parent_id='0') AND ";
  $query .= "#__pshop_category.category_id=#__pshop_category_xref.category_child_id ";
  $query .= "ORDER BY #__pshop_category.list_order, #__pshop_category.category_name ASC";
  
  // initialise the query in the $database connector
  // this translates the '#__' prefix into the real database prefix
  $database->setQuery( $query );

  if($database->getErrorNum()) {
    echo "MB ".$database->stderr(true);
    return;
  }
    
  // retrieve the list of returned records as an array of objects
  $rows = $database->loadObjectList();

	// cycle through the returned rows displaying them in a table
	// with links to the product category
	// escaping in and out of php is now permitted
  ?>
  <table cellpadding="1" cellspacing="1" border="0" width="100%">
  <?php
    echo $pretext;

    foreach ($rows as $category) { ?>
    <tr>
      <td colspan="2">
        <a class="<?php echo $class_mainlevel ?>" href="<?php echo $sess->url(URL."index.php?option=com_phpshop&amp;page=shop.browse&amp;category_id=$category->category_id"); ?>">
        <?php echo $category->category_name ?></a>
      </td>
    </tr><?php 
      /* Do we have a specific category for displaying subcategories? */
      if (!empty($_REQUEST['category_id'])) {
        require_once(CLASSPATH.'ps_product_category.php');
        $ps_product_category = new ps_product_category;
                    
        if ($_REQUEST['category_id'] == $category->category_id 
          && $ps_product_category->has_childs($_REQUEST['category_id'])) { ?>
        <tr>
          <td>&nbsp;</td>
          <td> 
            <?php   
                    $ps_product_category->print_subcategory($_REQUEST['category_id']); 
        ?> </td></tr> <?php
                }
              }
              if (!empty($_REQUEST['root'])) {
                require_once(CLASSPATH.'ps_product_category.php');
                $ps_product_category = new ps_product_category;              
                
                if ($_REQUEST['root'] == $category->category_id && $ps_product_category->has_childs($_REQUEST['root']))  { 

                ?>
        <tr>
          <td>&nbsp;</td>
          <td><?php 
              require_once(CLASSPATH.'ps_product_category.php');
              $ps_product_category = new ps_product_category;
              $ps_product_category->print_subcategory($_REQUEST['root']); ?>
          </td>
        </tr> <?php
                }
            } 
        }
  }  /** END LINK LIST **/
  else {
      /* dTree script to display structured categories */
      include( $mosConfig_absolute_path . '/modules/phpshop_dtree.php' );
    
  }
  if ( $menutype != 'links' ) { ?>
      <table cellpadding="1" cellspacing="1" border="0" width="100%">
  <?php
  }
  if ( $show_listall == 'yes' ) { ?>
    <tr> 
      <td colspan="2"><br />
          <a href="<?php $sess->purl(URL."index.php?page=shop.browse") ?>">
          <?php echo $PHPSHOP_LANG->_PHPSHOP_LIST_ALL_PRODUCTS ?>
          </a>
      </td>
    </tr>
  <?php
  }
  
  if ( $show_productsearch == 'yes' ) { ?>
  
  <!--BEGIN Search Box --> 
  <tr> 
    <td colspan="2"><hr />
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr> 
          <td><?php echo $PHPSHOP_LANG->_PHPSHOP_PRODUCT_SEARCH_LBL ?></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr> 
    <td colspan="2">
      <form action="<?php echo $_SERVER['PHP_SELF'] ?>" method="get" />
        <input title="<?php echo $PHPSHOP_LANG->_PHPSHOP_SEARCH_TITLE ?>" class="inputbox" type="text" size="12" name="keyword" />
        <input class="button" type="Submit" name="Search" value="<?php echo $PHPSHOP_LANG->_PHPSHOP_SEARCH_TITLE ?>" />
        <br />
        <a href="<?php echo $sess->url(URL."index.php?option=com_phpshop&page=shop.search") ?>">
            <?php echo $PHPSHOP_LANG->_PHPSHOP_ADVANCED_SEARCH ?>
        </a>
        <hr />
    </td>
  </tr>
    <input type="hidden" name="Itemid" value="<?php echo intval(@$_REQUEST['Itemid']) ?>" />
    <input type="hidden" name="option" value="com_phpshop" />
    <input type="hidden" name="page" value="shop.browse" />
  </form>
  <!-- End Search Box --> 
<?php 
  }
  
  $perm = new ps_perm;
  if ($perm->check("admin,storeadmin") 
        && ((!stristr($my->usertype, "admin") ^ PSHOP_ALLOW_FRONTENDADMIN_FOR_NOBACKENDERS == '' ) 
            || stristr($my->usertype, "admin")
        )
      ) { ?>
    <tr> 
      <td colspan="2"><a class="<?php echo $class_mainlevel ?>" href="<?php $sess->purl(SECUREURL . "index.php?page=store.index&pshop_mode=admin");
      echo "\">".$PHPSHOP_LANG->_PHPSHOP_ADMIN_MOD; ?></a></td>
    </tr>
  <?php }
   if ($perm->is_registered_customer($auth["user_id"])) {
  ?> 
    <tr> 
      <td colspan="2"><a class="<?php echo $class_mainlevel ?>" href="<?php $sess->purl(SECUREURL . "index.php?page=account.index");?>">
      <?php echo $PHPSHOP_LANG->_PHPSHOP_ACCOUNT_TITLE ?></a></td>
    </tr><?php 
  }
   
  /*********************
  ** DOWNLOAD MOD
  **/
  if (ENABLE_DOWNLOADS == '1') { ?>
    <tr> 
      <td colspan="2">
          <a class="<?php echo $class_mainlevel ?>" href="<?php $sess->purl(SECUREURL . "index.php?page=shop.downloads");?>">
          <?php echo $PHPSHOP_LANG->_PHPSHOP_DOWNLOADS_TITLE ?>
          </a>
      </td>
    </tr><?php
  }
    /**
    ** END DOWNLOAD MOD
    /*********************/
  
  if (USE_AS_CATALOGUE != '1' && $show_minicart == 'yes') {
?>
    <tr>
        <td colspan="2"><a class="<?php echo $class_mainlevel ?>" href="<?php $sess->purl(URL."index.php?option=com_phpshop&amp;page=shop.cart")?>"><?php echo $PHPSHOP_LANG->_PHPSHOP_CART_SHOW ?></td>
    </tr>
    <tr>
        <td colspan="2"><? include (PAGEPATH.'shop.basket_short.php') ?></td>
    </tr>
        <?php 
  } ?> 
   
</table>
<?php
// Just for SIMPLEBOARD compatibility !
if ($_REQUEST['option'] != "com_phpshop") $db = array();   ?>
