# $Id: mambo.sql,v 1.19 2005/02/16 15:44:24 stingrey Exp $

#
# Table structure for table `#__banner`
#

CREATE TABLE `#__banner` (
  `bid` int(11) NOT NULL auto_increment,
  `cid` int(11) NOT NULL default '0',
  `type` varchar(10) NOT NULL default 'banner',
  `name` varchar(50) NOT NULL default '',
  `imptotal` int(11) NOT NULL default '0',
  `impmade` int(11) NOT NULL default '0',
  `clicks` int(11) NOT NULL default '0',
  `imageurl` varchar(100) NOT NULL default '',
  `clickurl` varchar(200) NOT NULL default '',
  `date` datetime default NULL,
  `showBanner` tinyint(1) NOT NULL default '0',
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `editor` varchar(50) default NULL,
  `custombannercode` text,
  PRIMARY KEY  (`bid`),
  KEY `viewbanner` (`showBanner`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

#
# Table structure for table `#__bannerclient`
#

CREATE TABLE `#__bannerclient` (
  `cid` int(11) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL default '',
  `contact` varchar(60) NOT NULL default '',
  `email` varchar(60) NOT NULL default '',
  `extrainfo` text NOT NULL,
  `checked_out` tinyint(1) NOT NULL default '0',
  `checked_out_time` time default NULL,
  `editor` varchar(50) default NULL,
  PRIMARY KEY  (`cid`)
) TYPE=MyISAM;

#
# Table structure for table `#__bannerfinish`
#

CREATE TABLE `#__bannerfinish` (
  `bid` int(11) NOT NULL auto_increment,
  `cid` int(11) NOT NULL default '0',
  `type` varchar(10) NOT NULL default '',
  `name` varchar(50) NOT NULL default '',
  `impressions` int(11) NOT NULL default '0',
  `clicks` int(11) NOT NULL default '0',
  `imageurl` varchar(50) NOT NULL default '',
  `datestart` datetime default NULL,
  `dateend` datetime default NULL,
  PRIMARY KEY  (`bid`)
) TYPE=MyISAM;

#
# Table structure for table `#__categories`
#

CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL default 0,
  `title` varchar(50) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `image` varchar(100) NOT NULL default '',
  `section` varchar(50) NOT NULL default '',
  `image_position` varchar(10) NOT NULL default '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `editor` varchar(50) default NULL,
  `ordering` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `count` int(11) NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `cat_idx` (`section`,`published`,`access`),
  KEY `idx_section` (`section`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`)
) TYPE=MyISAM;

#
# Table structure for table `#__components`
#

CREATE TABLE `#__components` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `link` varchar(255) NOT NULL default '',
  `menuid` int(11) unsigned NOT NULL default '0',
  `parent` int(11) unsigned NOT NULL default '0',
  `admin_menu_link` varchar(255) NOT NULL default '',
  `admin_menu_alt` varchar(255) NOT NULL default '',
  `option` varchar(50) NOT NULL default '',
  `ordering` int(11) NOT NULL default '0',
  `admin_menu_img` varchar(255) NOT NULL default '',
  `iscore` tinyint(4) NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `#__components`
#

INSERT INTO `#__components` VALUES (1, 'Banners', '', 0, 0, '', 'Banner Management', 'com_banners', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `#__components` VALUES (2, 'Manage Banners', '', 0, 1, 'option=com_banners', 'Active Banners', 'com_banners', 1, 'js/ThemeOffice/edit.png', 0, '');
INSERT INTO `#__components` VALUES (3, 'Manage Clients', '', 0, 1, 'option=com_banners&task=listclients', 'Manage Clients', 'com_banners', 2, 'js/ThemeOffice/categories.png', 0, '');
INSERT INTO `#__components` VALUES (4, 'Web Links', 'option=com_weblinks', 0, 0, '', 'Manage Weblinks', 'com_weblinks', 0, 'js/ThemeOffice/globe2.png', 0, '');
INSERT INTO `#__components` VALUES (5, 'Weblink Items', '', 0, 4, 'option=com_weblinks', 'View existing weblinks', 'com_weblinks', 1, 'js/ThemeOffice/edit.png', 0, '');
INSERT INTO `#__components` VALUES (6, 'Weblink Categories', '', 0, 4, 'option=categories&section=com_weblinks', 'Manage weblink categories', '', 2, 'js/ThemeOffice/categories.png', 0, '');
INSERT INTO `#__components` VALUES (7, 'Contacts', 'option=com_contact', 0, 0, '', 'Edit contact details', 'com_contact', 0, 'js/ThemeOffice/user.png', 1, '');
INSERT INTO `#__components` VALUES (8, 'Manage Contacts', '', 0, 7, 'option=com_contact', 'Edit contact details', 'com_contact', 0, 'js/ThemeOffice/edit.png', 1, '');
INSERT INTO `#__components` VALUES (9, 'Contact Categories', '', 0, 7, 'option=categories&section=com_contact_details', 'Manage contact categories', '', 2, 'js/ThemeOffice/categories.png', 1, '');
INSERT INTO `#__components` VALUES (10, 'FrontPage', 'option=com_frontpage', 0, 0, '', 'Manage Front Page Items', 'com_frontpage', 0, 'js/ThemeOffice/component.png', 1, '');
INSERT INTO `#__components` VALUES (11, 'Polls', 'option=com_poll', 0, 0, 'option=com_poll', 'Manage Polls', 'com_poll', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `#__components` VALUES (12, 'News Feeds', 'option=com_newsfeeds', 0, 0, '', 'News Feeds Management', 'com_newsfeeds', 0, 'js/ThemeOffice/component.png', 0, '');
INSERT INTO `#__components` VALUES (13, 'Manage News Feeds', '', 0, 12, 'option=com_newsfeeds', 'Manage News Feeds', 'com_newsfeeds', 1, 'js/ThemeOffice/edit.png', 0, '');
INSERT INTO `#__components` VALUES (14, 'Manage Categories', '', 0, 12, 'option=com_categories&section=com_newsfeeds', 'Manage Categories', '', 2, 'js/ThemeOffice/categories.png', 0, '');
INSERT INTO `#__components` VALUES (15, 'Login', 'option=com_login', 0, 0, '', '', 'com_login', 0, '', 1, '');
INSERT INTO `#__components` VALUES (16, 'Search', 'option=com_search', 0, 0, '', '', 'com_search', 0, '', 1, '');
INSERT INTO `#__components` VALUES (17, 'Syndicate','',0,0,'option=com_syndicate&hidemainmenu=1','Manage Syndication Settings','com_syndicate',0,'js/ThemeOffice/component.png',0,'');
INSERT INTO `#__components` VALUES (18, 'Mass Mail', '', 0, 0, 'option=com_massmail&hidemainmenu=1', 'Send Mass Mail', 'com_massmail', 0, 'js/ThemeOffice/mass_email.png', 0, '');
INSERT INTO `#__components` VALUES (19, 'mambo-phpShop', 'option=com_phpshop', 0, 0, 'option=com_phpshop', 'mambo-phpShop', 'com_phpshop', 0, 'js/ThemeOffice/component.png', 0, '');

# --------------------------------------------------------

#
# Table structure for table `#__contact_details`
#

CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `con_position` varchar(50) default NULL,
  `address` text,
  `suburb` varchar(50) default NULL,
  `state` varchar(20) default NULL,
  `country` varchar(50) default NULL,
  `postcode` varchar(10) default NULL,
  `telephone` varchar(25) default NULL,
  `fax` varchar(25) default NULL,
  `misc` mediumtext,
  `image` varchar(100) default NULL,
  `imagepos` varchar(20) default NULL,
  `email_to` varchar(100) default NULL,
  `default_con` tinyint(1) unsigned NOT NULL default '0',
  `published` tinyint(1) unsigned NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL default '0',
  `catid` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Table structure for table `#__content`
#

CREATE TABLE `#__content` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `title_alias` varchar(100) NOT NULL default '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL default '0',
  `sectionid` int(11) unsigned NOT NULL default '0',
  `mask` int(11) unsigned NOT NULL default '0',
  `catid` int(11) unsigned NOT NULL default '0',
  `created` datetime NOT NULL default '0000-00-00 00:00:00',
  `created_by` int(11) unsigned NOT NULL default '0',
  `created_by_alias` varchar(100) NOT NULL default '',
  `modified` datetime NOT NULL default '0000-00-00 00:00:00',
  `modified_by` int(11) unsigned NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL default '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL default '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` text NOT NULL,
  `version` int(11) unsigned NOT NULL default '1',
  `parentid` int(11) unsigned NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `idx_section` (`sectionid`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_mask` (`mask`)
) TYPE=MyISAM;

#
# Table structure for table `#__content_frontpage`
#

CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`content_id`)
) TYPE=MyISAM;

#
# Table structure for table `#__content_rating`
#

CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL default '0',
  `rating_sum` int(11) unsigned NOT NULL default '',
  `rating_count` int(11) unsigned NOT NULL default '0',
  `lastip` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`content_id`)
) TYPE=MyISAM;

#
# Table structure for table `#__core_log_items`
#
# To be implemented in Version 4.6

CREATE TABLE `#__core_log_items` (
  `time_stamp` date NOT NULL default '0000-00-00',
  `item_table` varchar(50) NOT NULL default '',
  `item_id` int(11) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '0'
) TYPE=MyISAM;

#
# Table structure for table `#__core_log_searches`
#
# To be implemented in Version 4.6

CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) NOT NULL default '',
  `hits` int(11) unsigned NOT NULL default '0'
) TYPE=MyISAM;

#
# Table structure for table `#__groups`
#

CREATE TABLE `#__groups` (
  `id` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `#__groups`
#

INSERT INTO `#__groups` VALUES (0, 'Public');
INSERT INTO `#__groups` VALUES (1, 'Registered');
INSERT INTO `#__groups` VALUES (2, 'Special');
# --------------------------------------------------------

#
# Table structure for table `#__mambots`
#

CREATE TABLE `#__mambots` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `element` varchar(100) NOT NULL default '',
  `folder` varchar(100) NOT NULL default '',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  `published` tinyint(3) NOT NULL default '0',
  `iscore` tinyint(3) NOT NULL default '0',
  `client_id` tinyint(3) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `idx_folder` (`published`,`client_id`,`access`,`folder`)
) TYPE=MyISAM;

INSERT INTO `#__mambots` VALUES (1,'MOS Image','mosimage','content',0,-10000,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (2,'MOS Pagination','mospaging','content',0,10000,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (3,'Legacy Mambot Includer','legacybots','content',0,1,0,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (4,'SEF','mossef','content',0,3,1,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (5,'MOS Rating','mosvote','content',0,4,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (6,'Search Content','content.searchbot','search',0,1,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (7,'Search Weblinks','weblinks.searchbot','search',0,2,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (8,'Code support','moscode','content',0,2,0,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (9,'No WYSIWYG Editor','none','editors',0,0,0,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (10,'TinyMCE WYSIWYG Editor','tinymce','editors',0,0,0,1,0,0,'0000-00-00 00:00:00','theme=advanced');
INSERT INTO `#__mambots` VALUES (11,'MOS Image Editor Button','mosimage.btn','editors-xtd',0,0,1,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (12,'MOS Pagebreak Editor Button','mospage.btn','editors-xtd',0,0,1,0,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (13,'Search Contacts','contacts.searchbot','search',0,3,1,1,0,0,'0000-00-00 00:00:00','');
INSERT INTO `#__mambots` VALUES (14, 'Search Categories', 'categories.searchbot', 'search', 0, 4, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (15, 'Search Sections', 'sections.searchbot', 'search', 0, 5, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (16, 'Email Cloaking', 'mosemailcloak', 'content', 0, 5, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (17, 'GeSHi', 'geshi', 'content', 0, 5, 0, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (18, 'Search Newsfeeds', 'newsfeeds.searchbot', 'search', 0, 6, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (19, 'Load Module Positions', 'mosloadposition', 'content', 0, 6, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (20, 'mosproductsnap', 'mosproductsnap', 'content', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (21, 'ProductSearchBot', 'phpshop.searchbot', 'search', 0, 0, 1, 0, 0, 0, '0000-00-00 00:00:00', '');
INSERT INTO `#__mambots` VALUES (22, 'HTMLArea3 XTD', 'htmlarea3_xtd', 'editors', 0, 3, 1, 0, 0, 0, '0000-00-00 00:00:00', 'insertsmiley=1\ntableoperations=1\nenterparagraphs=1\ncontextmenu=1\ncss=1\ncsspreview=1\nlanguage=en');

# --------------------------------------------------------

#
# Table structure for table `#__menu`
#

CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL auto_increment,
  `menutype` varchar(25) default NULL,
  `name` varchar(100) default NULL,
  `link` text,
  `type` varchar(50) NOT NULL default '',
  `published` tinyint(1) NOT NULL default '0',
  `parent` int(11) unsigned NOT NULL default '0',
  `componentid` int(11) unsigned NOT NULL default '0',
  `sublevel` int(11) default '0',
  `ordering` int(11) default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `pollid` int(11) NOT NULL default '0',
  `browserNav` tinyint(4) default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `utaccess` tinyint(3) unsigned NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `componentid` (`componentid`,`menutype`,`published`,`access`),
  KEY `menutype` (`menutype`)
) TYPE=MyISAM;

INSERT INTO `#__menu` VALUES (1, 'mainmenu', 'Home', 'index.php?option=com_frontpage', 'components', 1, 0, 10, 0, 1, 0, '0000-00-00 00:00:00', 0, 0, 0, 3, 'leading=1\r\nintro=2\r\nlink=1\r\nimage=1\r\npage_title=0\r\nheader=Welcome to the Frontpage\r\norderby_sec=front\r\nprint=0\r\npdf=0\r\nemail=0');
# --------------------------------------------------------

#
# Table structure for table `#__messages`
#

CREATE TABLE `#__messages` (
  `message_id` int(10) unsigned NOT NULL auto_increment,
  `user_id_from` int(10) unsigned NOT NULL default '0',
  `user_id_to` int(10) unsigned NOT NULL default '0',
  `folder_id` int(10) unsigned NOT NULL default '0',
  `date_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `state` int(11) NOT NULL default '0',
  `priority` int(1) unsigned NOT NULL default '0',
  `subject` varchar(230) NOT NULL default '',
  `message` text NOT NULL,
  PRIMARY KEY  (`message_id`)
) TYPE=MyISAM;

#
# Table structure for table `#__messages_cfg`
#

CREATE TABLE `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL default '0',
  `cfg_name` varchar(100) NOT NULL default '',
  `cfg_value` varchar(255) NOT NULL default '',
  UNIQUE `idx_user_var_name` (`user_id`,`cfg_name`)
) TYPE=MyISAM;

#
# Table structure for table `#__modules`
#

CREATE TABLE `#__modules` (
  `id` int(11) NOT NULL auto_increment,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL default '0',
  `position` varchar(10) default NULL,
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL default '0',
  `module` varchar(50) default NULL,
  `numnews` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `showtitle` tinyint(3) unsigned NOT NULL default '1',
  `params` text NOT NULL,
  `iscore` tinyint(4) NOT NULL default '0',
  `client_id` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`)
) TYPE=MyISAM;

#
# Dumping data for table `#__modules`
#

INSERT INTO `#__modules` VALUES (1, 'Polls', '', 1, 'right', 0, '0000-00-00 00:00:00', 1, 'mod_poll', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (2, 'User Menu', '', 2, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 1, 1, 'menutype=usermenu', 1, 0);
INSERT INTO `#__modules` VALUES (3, 'Main Menu', '', 1, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 0, 1, 'menutype=mainmenu', 1, 0);
INSERT INTO `#__modules` VALUES (4, 'Login Form', '', 3, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_login', 0, 0, 1, '', 1, 0);
INSERT INTO `#__modules` VALUES (5, 'Syndicate', '', 4, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_rssfeed', 0, 0, 1, '', 1, 0);
INSERT INTO `#__modules` VALUES (6, 'Latest News', '', 4, 'user1', 0, '0000-00-00 00:00:00', 1, 'mod_latestnews', 0, 0, 1, '', 1, 0);
INSERT INTO `#__modules` VALUES (7, 'Statistics', '', 4, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_stats', 0, 0, 1, 'serverinfo=1\nsiteinfo=1\ncounter=1\nincrease=0\nmoduleclass_sfx=', 0, 0);
INSERT INTO `#__modules` VALUES (8, 'Who\'s Online', '', 1, 'right', 0, '0000-00-00 00:00:00', 1, 'mod_whosonline', 0, 0, 1, 'online=1\nusers=1\nmoduleclass_sfx=', 0, 0);
INSERT INTO `#__modules` VALUES (9, 'Popular', '', 6, 'user2', 0, '0000-00-00 00:00:00', 1, 'mod_mostread', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (10, 'Template Chooser','',6,'left',0,'0000-00-00 00:00:00',0,'mod_templatechooser', 0, 0, 1, 'show_preview=1', 0, 0);
INSERT INTO `#__modules` VALUES (11, 'Archive', '', 7, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_archive', 0, 0, 1, '', 1, 0);
INSERT INTO `#__modules` VALUES (12, 'Sections', '', 8, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_sections', 0, 0, 1, '', 1, 0);
INSERT INTO `#__modules` VALUES (13, 'Newsflash', '', 1, 'top', 0, '0000-00-00 00:00:00', 0, 'mod_newsflash', 0, 0, 1, 'catid=3\r\nstyle=random\r\nitems=\r\nmoduleclass_sfx=', 0, 0);
INSERT INTO `#__modules` VALUES (14, 'Related Items', '', 9, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_related_items', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (15, 'Search', '', 1, 'user4', 0, '0000-00-00 00:00:00', 1, 'mod_search', 0, 0, 0, '', 0, 0);
INSERT INTO `#__modules` VALUES (16, 'Random Image', '', 9, 'right', 0, '0000-00-00 00:00:00', 1, 'mod_random_image', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (17, 'Top Menu', '', 1, 'user3', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 0, 0, 'menutype=topmenu\nmenu_style=list_flat\nmenu_images=n\nmenu_images_align=left\nexpand_menu=n\nclass_sfx=-nav\nmoduleclass_sfx=\nindent_image1=0\nindent_image2=0\nindent_image3=0\nindent_image4=0\nindent_image5=0\nindent_image6=0', 1, 0);
INSERT INTO `#__modules` VALUES (18, 'Banners', '', 1, 'banner', 0, '0000-00-00 00:00:00', 1, 'mod_banners', 0, 0, 0, 'banner_cids=\nmoduleclass_sfx=\n', 1, 0);
INSERT INTO `#__modules` VALUES (0,'Components','',2,'cpanel',0,'0000-00-00 00:00:00',1,'mod_components',0,99,1,'',1, 1);
INSERT INTO `#__modules` VALUES (0,'Popular','',3,'cpanel',0,'0000-00-00 00:00:00',1,'mod_popular',0,99,1,'',0, 1);
INSERT INTO `#__modules` VALUES (0,'Latest Items','',4,'cpanel',0,'0000-00-00 00:00:00',1,'mod_latest',0,99,1,'',0, 1);
INSERT INTO `#__modules` VALUES (0,'Menu Stats','',5,'cpanel',0,'0000-00-00 00:00:00',1,'mod_stats',0,99,1,'',0, 1);
INSERT INTO `#__modules` VALUES (0,'Unread Messages','',1,'header',0,'0000-00-00 00:00:00',1,'mod_unread',0,99,1,'',1, 1);
INSERT INTO `#__modules` VALUES (0,'Online Users','',2,'header',0,'0000-00-00 00:00:00',1,'mod_online',0,99,1,'',1, 1);
INSERT INTO `#__modules` VALUES (0,'Full Menu','',1,'top',0,'0000-00-00 00:00:00',1,'mod_fullmenu',0,99,1,'',1, 1);
INSERT INTO `#__modules` VALUES (0,'Pathway','',1,'pathway',0,'0000-00-00 00:00:00',1,'mod_pathway',0,99,1,'',1, 1);
INSERT INTO `#__modules` VALUES (0,'Toolbar','',1,'toolbar',0,'0000-00-00 00:00:00',1,'mod_toolbar',0,99,1,'',1, 1);
INSERT INTO `#__modules` VALUES (0,'System Message','',1,'inset',0,'0000-00-00 00:00:00',1,'mod_mosmsg',0,99,1,'',1, 1);
INSERT INTO `#__modules` VALUES (0,'Quick Icons','',1,'icon',0,'0000-00-00 00:00:00',1,'mod_quickicon',0,99,1,'',1,1);
INSERT INTO `#__modules` VALUES (0, 'Mamboforge','',1,'cpanel',0,'0000-00-00 00:00:00',0,'',0,99,1,'rssurl=http://mamboforge.net/export/rss_sfnews.php\nrssitems=5\nrssdesc=1\ncache=0\nmoduleclass_sfx=',0,1);
INSERT INTO `#__modules` VALUES (31, 'Other Menu', '', 2, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_mainmenu', 0, 0, 0, 'menutype=othermenu\nmenu_style=vert_indent\ncache=0\nmenu_images=0\nmenu_images_align=0\nexpand_menu=0\nclass_sfx=\nmoduleclass_sfx=\nindent_image=0\nindent_image1=\nindent_image2=\nindent_image3=\nindent_image4=\nindent_image5=\nindent_image6=', 0, 0);
INSERT INTO `#__modules` VALUES (0,'Wrapper','',10,'left',0,'0000-00-00 00:00:00',1,'mod_wrapper',0,0,1,'',0, 0);
INSERT INTO `#__modules` VALUES (33,'Logged','',0,'cpanel',0,'0000-00-00 00:00:00',1,'mod_logged',0,99,1,'',0,1);
INSERT INTO `#__modules` VALUES (41, 'Online-Shop', '', 3, 'left', 0, '0000-00-00 00:00:00', 1, 'mod_phpshop', 0, 0, 1, 'class_sfx=\npretext=Categories\nshow_listall=yes\nshow_minicart=no\nshow_productsearch=yes\nmenutype=links\nroot_label=Shop', 0, 0);
INSERT INTO `#__modules` VALUES (42, 'Check the Shop', '', 17, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_phpshop_allinone', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (34, 'Your Cart', '', 2, 'top', 0, '0000-00-00 00:00:00', 1, 'mod_phpshop_cart', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (35, 'phpShop featured products Module', '', 16, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_phpshop_featureprod', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (36, 'phpShop latest products', '', 15, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_phpshop_latestprod', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (37, 'phpShop Manufacturers', '', 14, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_phpshop_manufacturers', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (38, 'phpShop random products Module', '', 13, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_phpshop_randomprod', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (39, 'phpShop Search Module', '', 12, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_phpshop_search', 0, 0, 1, '', 0, 0);
INSERT INTO `#__modules` VALUES (40, 'phpShop TopTen products Module', '', 18, 'left', 0, '0000-00-00 00:00:00', 0, 'mod_phpshop_topten', 0, 0, 1, '', 0, 0);

# --------------------------------------------------------

#
# Table structure for table `#__modules_menu`
#

CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL default '0',
  `menuid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`moduleid`,`menuid`)
) TYPE=MyISAM;

#
# Dumping data for table `#__modules_menu`
#

INSERT INTO `#__modules_menu` VALUES (1,1);
INSERT INTO `#__modules_menu` VALUES (2,0);
INSERT INTO `#__modules_menu` VALUES (3,0);
INSERT INTO `#__modules_menu` VALUES (4,1);
INSERT INTO `#__modules_menu` VALUES (5,1);
INSERT INTO `#__modules_menu` VALUES (6,1);
INSERT INTO `#__modules_menu` VALUES (6,2);
INSERT INTO `#__modules_menu` VALUES (6,4);
INSERT INTO `#__modules_menu` VALUES (6,27);
INSERT INTO `#__modules_menu` VALUES (6,36);
INSERT INTO `#__modules_menu` VALUES (8,1);
INSERT INTO `#__modules_menu` VALUES (9,1);
INSERT INTO `#__modules_menu` VALUES (9,2);
INSERT INTO `#__modules_menu` VALUES (9,4);
INSERT INTO `#__modules_menu` VALUES (9,27);
INSERT INTO `#__modules_menu` VALUES (9,36);
INSERT INTO `#__modules_menu` VALUES (10,1);
INSERT INTO `#__modules_menu` VALUES (13,0);
INSERT INTO `#__modules_menu` VALUES (15,0);
INSERT INTO `#__modules_menu` VALUES (17,0);
INSERT INTO `#__modules_menu` VALUES (18,0);
INSERT INTO `#__modules_menu` VALUES (31, 0);
INSERT INTO `#__modules_menu` VALUES (41, 0);
INSERT INTO `#__modules_menu` VALUES (42, 0);
INSERT INTO `#__modules_menu` VALUES (34, 0);
INSERT INTO `#__modules_menu` VALUES (35, 0);
INSERT INTO `#__modules_menu` VALUES (36, 0);
INSERT INTO `#__modules_menu` VALUES (37, 0);
INSERT INTO `#__modules_menu` VALUES (38, 0);
INSERT INTO `#__modules_menu` VALUES (39, 0);
INSERT INTO `#__modules_menu` VALUES (40, 0);
# --------------------------------------------------------

#
# Table structure for table `#__newsfeeds`
#

CREATE TABLE `#__newsfeeds` (
  `catid` int(11) NOT NULL default '0',
  `id` int(11) NOT NULL auto_increment,
  `name` text NOT NULL,
  `link` text NOT NULL,
  `filename` varchar(200) default NULL,
  `published` tinyint(1) NOT NULL default '0',
  `numarticles` int(11) unsigned NOT NULL default '1',
  `cache_time` int(11) unsigned NOT NULL default '3600',
  `checked_out` tinyint(3) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `published` (`published`)
) TYPE=MyISAM;

#
# Table structure for table `#__poll_data`
#

CREATE TABLE `#__poll_data` (
  `id` int(11) NOT NULL auto_increment,
  `pollid` int(4) NOT NULL default '0',
  `text` text NOT NULL default '',
  `hits` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `pollid` (`pollid`,`text`(1))
) TYPE=MyISAM;

#
# Table structure for table `#__poll_date`
#

CREATE TABLE `#__poll_date` (
  `id` bigint(20) NOT NULL auto_increment,
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `vote_id` int(11) NOT NULL default '0',
  `poll_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `poll_id` (`poll_id`)
) TYPE=MyISAM;

#
# Table structure for table `#__polls`
#

CREATE TABLE `#__polls` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `voters` int(9) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL default '0',
  `access` int(11) NOT NULL default '0',
  `lag` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Table structure for table `#__poll_menu`
#

CREATE TABLE `#__poll_menu` (
  `pollid` int(11) NOT NULL default '0',
  `menuid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pollid`,`menuid`)
) TYPE=MyISAM;



CREATE TABLE `#__pshop_auth_user_vendor` (
      `user_id` varchar(32) default NULL,
      `vendor_id` int(11) default NULL,
      KEY `idx_auth_user_vendor_user_id` (`user_id`),
      KEY `idx_auth_user_vendor_vendor_id` (`vendor_id`)
        ) TYPE=MyISAM;


CREATE TABLE `#__pshop_category` (
  `category_id` varchar(32) NOT NULL default '',
  `vendor_id` int(11) NOT NULL default '0',
  `category_name` varchar(128) NOT NULL default '',
  `category_description` text,
  `category_thumb_image` varchar(255) default NULL,
  `category_full_image` varchar(255) default NULL,
  `category_publish` char(1) default NULL,
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `category_browsepage` VARCHAR( 255 ) DEFAULT 'browse_1' NOT NULL,
  `products_per_row` TINYINT( 2 ) DEFAULT '1' NOT NULL,
  `category_flypage` varchar(255) default NULL,
  `list_order`int(11) default NULL,
  PRIMARY KEY  (`category_id`),
  KEY `idx_category_vendor_id` (`vendor_id`),
  KEY `idx_category_name` (`category_name`)
) TYPE=MyISAM;


CREATE TABLE `#__pshop_category_xref` (
  `category_parent_id` varchar(32) default '0' NOT NULL,
  `category_child_id` varchar(32) default '0' NOT NULL,
  `category_list` int(11) default NULL,
  KEY `category_xref_category_parent_id` (`category_parent_id`),
  KEY `category_xref_category_child_id` (`category_child_id`),
  KEY `idx_category_xref_category_list` (`category_list`)
) TYPE=MyISAM;


CREATE TABLE `#__pshop_country` (
  `country_id` int(11) NOT NULL auto_increment,
  `zone_id` int(11) NOT NULL default '1',
  `country_name` varchar(64) default NULL,
  `country_3_code` char(3) default NULL,
  `country_2_code` char(2) default NULL,
  PRIMARY KEY  (`country_id`),
  KEY `idx_country_name` (`country_name`)
) TYPE=MyISAM AUTO_INCREMENT=240 ;
INSERT INTO `#__pshop_country` VALUES (1, 1, 'Afghanistan', 'AFG', 'AF');
INSERT INTO `#__pshop_country` VALUES (2, 1, 'Albania', 'ALB', 'AL');
INSERT INTO `#__pshop_country` VALUES (3, 1, 'Algeria', 'DZA', 'DZ');
INSERT INTO `#__pshop_country` VALUES (4, 1, 'American Samoa', 'ASM', 'AS');
INSERT INTO `#__pshop_country` VALUES (5, 1, 'Andorra', 'AND', 'AD');
INSERT INTO `#__pshop_country` VALUES (6, 1, 'Angola', 'AGO', 'AO');
INSERT INTO `#__pshop_country` VALUES (7, 1, 'Anguilla', 'AIA', 'AI');
INSERT INTO `#__pshop_country` VALUES (8, 1, 'Antarctica', 'ATA', 'AQ');
INSERT INTO `#__pshop_country` VALUES (9, 1, 'Antigua and Barbuda', 'ATG', 'AG');
INSERT INTO `#__pshop_country` VALUES (10, 1, 'Argentina', 'ARG', 'AR');
INSERT INTO `#__pshop_country` VALUES (11, 1, 'Armenia', 'ARM', 'AM');
INSERT INTO `#__pshop_country` VALUES (12, 1, 'Aruba', 'ABW', 'AW');
INSERT INTO `#__pshop_country` VALUES (13, 1, 'Australia', 'AUS', 'AU');
INSERT INTO `#__pshop_country` VALUES (14, 1, 'Austria', 'AUT', 'AT');
INSERT INTO `#__pshop_country` VALUES (15, 1, 'Azerbaijan', 'AZE', 'AZ');
INSERT INTO `#__pshop_country` VALUES (16, 1, 'Bahamas', 'BHS', 'BS');
INSERT INTO `#__pshop_country` VALUES (17, 1, 'Bahrain', 'BHR', 'BH');
INSERT INTO `#__pshop_country` VALUES (18, 1, 'Bangladesh', 'BGD', 'BD');
INSERT INTO `#__pshop_country` VALUES (19, 1, 'Barbados', 'BRB', 'BB');
INSERT INTO `#__pshop_country` VALUES (20, 1, 'Belarus', 'BLR', 'BY');
INSERT INTO `#__pshop_country` VALUES (21, 1, 'Belgium', 'BEL', 'BE');
INSERT INTO `#__pshop_country` VALUES (22, 1, 'Belize', 'BLZ', 'BZ');
INSERT INTO `#__pshop_country` VALUES (23, 1, 'Benin', 'BEN', 'BJ');
INSERT INTO `#__pshop_country` VALUES (24, 1, 'Bermuda', 'BMU', 'BM');
INSERT INTO `#__pshop_country` VALUES (25, 1, 'Bhutan', 'BTN', 'BT');
INSERT INTO `#__pshop_country` VALUES (26, 1, 'Bolivia', 'BOL', 'BO');
INSERT INTO `#__pshop_country` VALUES (27, 1, 'Bosnia and Herzegowina', 'BIH', 'BA');
INSERT INTO `#__pshop_country` VALUES (28, 1, 'Botswana', 'BWA', 'BW');
INSERT INTO `#__pshop_country` VALUES (29, 1, 'Bouvet Island', 'BVT', 'BV');
INSERT INTO `#__pshop_country` VALUES (30, 1, 'Brazil', 'BRA', 'BR');
INSERT INTO `#__pshop_country` VALUES (31, 1, 'British Indian Ocean Territory', 'IOT', 'IO');
INSERT INTO `#__pshop_country` VALUES (32, 1, 'Brunei Darussalam', 'BRN', 'BN');
INSERT INTO `#__pshop_country` VALUES (33, 1, 'Bulgaria', 'BGR', 'BG');
INSERT INTO `#__pshop_country` VALUES (34, 1, 'Burkina Faso', 'BFA', 'BF');
INSERT INTO `#__pshop_country` VALUES (35, 1, 'Burundi', 'BDI', 'BI');
INSERT INTO `#__pshop_country` VALUES (36, 1, 'Cambodia', 'KHM', 'KH');
INSERT INTO `#__pshop_country` VALUES (37, 1, 'Cameroon', 'CMR', 'CM');
INSERT INTO `#__pshop_country` VALUES (38, 1, 'Canada', 'CAN', 'CA');
INSERT INTO `#__pshop_country` VALUES (39, 1, 'Cape Verde', 'CPV', 'CV');
INSERT INTO `#__pshop_country` VALUES (40, 1, 'Cayman Islands', 'CYM', 'KY');
INSERT INTO `#__pshop_country` VALUES (41, 1, 'Central African Republic', 'CAF', 'CF');
INSERT INTO `#__pshop_country` VALUES (42, 1, 'Chad', 'TCD', 'TD');
INSERT INTO `#__pshop_country` VALUES (43, 1, 'Chile', 'CHL', 'CL');
INSERT INTO `#__pshop_country` VALUES (44, 1, 'China', 'CHN', 'CN');
INSERT INTO `#__pshop_country` VALUES (45, 1, 'Christmas Island', 'CXR', 'CX');
INSERT INTO `#__pshop_country` VALUES (46, 1, 'Cocos (Keeling) Islands', 'CCK', 'CC');
INSERT INTO `#__pshop_country` VALUES (47, 1, 'Colombia', 'COL', 'CO');
INSERT INTO `#__pshop_country` VALUES (48, 1, 'Comoros', 'COM', 'KM');
INSERT INTO `#__pshop_country` VALUES (49, 1, 'Congo', 'COG', 'CG');
INSERT INTO `#__pshop_country` VALUES (50, 1, 'Cook Islands', 'COK', 'CK');
INSERT INTO `#__pshop_country` VALUES (51, 1, 'Costa Rica', 'CRI', 'CR');
INSERT INTO `#__pshop_country` VALUES (52, 1, 'Cote D\'Ivoire', 'CIV', 'CI');
INSERT INTO `#__pshop_country` VALUES (53, 1, 'Croatia', 'HRV', 'HR');
INSERT INTO `#__pshop_country` VALUES (54, 1, 'Cuba', 'CUB', 'CU');
INSERT INTO `#__pshop_country` VALUES (55, 1, 'Cyprus', 'CYP', 'CY');
INSERT INTO `#__pshop_country` VALUES (56, 1, 'Czech Republic', 'CZE', 'CZ');
INSERT INTO `#__pshop_country` VALUES (57, 1, 'Denmark', 'DNK', 'DK');
INSERT INTO `#__pshop_country` VALUES (58, 1, 'Djibouti', 'DJI', 'DJ');
INSERT INTO `#__pshop_country` VALUES (59, 1, 'Dominica', 'DMA', 'DM');
INSERT INTO `#__pshop_country` VALUES (60, 1, 'Dominican Republic', 'DOM', 'DO');
INSERT INTO `#__pshop_country` VALUES (61, 1, 'East Timor', 'TMP', 'TP');
INSERT INTO `#__pshop_country` VALUES (62, 1, 'Ecuador', 'ECU', 'EC');
INSERT INTO `#__pshop_country` VALUES (63, 1, 'Egypt', 'EGY', 'EG');
INSERT INTO `#__pshop_country` VALUES (64, 1, 'El Salvador', 'SLV', 'SV');
INSERT INTO `#__pshop_country` VALUES (65, 1, 'Equatorial Guinea', 'GNQ', 'GQ');
INSERT INTO `#__pshop_country` VALUES (66, 1, 'Eritrea', 'ERI', 'ER');
INSERT INTO `#__pshop_country` VALUES (67, 1, 'Estonia', 'EST', 'EE');
INSERT INTO `#__pshop_country` VALUES (68, 1, 'Ethiopia', 'ETH', 'ET');
INSERT INTO `#__pshop_country` VALUES (69, 1, 'Falkland Islands (Malvinas)', 'FLK', 'FK');
INSERT INTO `#__pshop_country` VALUES (70, 1, 'Faroe Islands', 'FRO', 'FO');
INSERT INTO `#__pshop_country` VALUES (71, 1, 'Fiji', 'FJI', 'FJ');
INSERT INTO `#__pshop_country` VALUES (72, 1, 'Finland', 'FIN', 'FI');
INSERT INTO `#__pshop_country` VALUES (73, 1, 'France', 'FRA', 'FR');
INSERT INTO `#__pshop_country` VALUES (74, 1, 'France, Metropolitan', 'FXX', 'FX');
INSERT INTO `#__pshop_country` VALUES (75, 1, 'French Guiana', 'GUF', 'GF');
INSERT INTO `#__pshop_country` VALUES (76, 1, 'French Polynesia', 'PYF', 'PF');
INSERT INTO `#__pshop_country` VALUES (77, 1, 'French Southern Territories', 'ATF', 'TF');
INSERT INTO `#__pshop_country` VALUES (78, 1, 'Gabon', 'GAB', 'GA');
INSERT INTO `#__pshop_country` VALUES (79, 1, 'Gambia', 'GMB', 'GM');
INSERT INTO `#__pshop_country` VALUES (80, 1, 'Georgia', 'GEO', 'GE');
INSERT INTO `#__pshop_country` VALUES (81, 1, 'Germany', 'DEU', 'DE');
INSERT INTO `#__pshop_country` VALUES (82, 1, 'Ghana', 'GHA', 'GH');
INSERT INTO `#__pshop_country` VALUES (83, 1, 'Gibraltar', 'GIB', 'GI');
INSERT INTO `#__pshop_country` VALUES (84, 1, 'Greece', 'GRC', 'GR');
INSERT INTO `#__pshop_country` VALUES (85, 1, 'Greenland', 'GRL', 'GL');
INSERT INTO `#__pshop_country` VALUES (86, 1, 'Grenada', 'GRD', 'GD');
INSERT INTO `#__pshop_country` VALUES (87, 1, 'Guadeloupe', 'GLP', 'GP');
INSERT INTO `#__pshop_country` VALUES (88, 1, 'Guam', 'GUM', 'GU');
INSERT INTO `#__pshop_country` VALUES (89, 1, 'Guatemala', 'GTM', 'GT');
INSERT INTO `#__pshop_country` VALUES (90, 1, 'Guinea', 'GIN', 'GN');
INSERT INTO `#__pshop_country` VALUES (91, 1, 'Guinea-bissau', 'GNB', 'GW');
INSERT INTO `#__pshop_country` VALUES (92, 1, 'Guyana', 'GUY', 'GY');
INSERT INTO `#__pshop_country` VALUES (93, 1, 'Haiti', 'HTI', 'HT');
INSERT INTO `#__pshop_country` VALUES (94, 1, 'Heard and Mc Donald Islands', 'HMD', 'HM');
INSERT INTO `#__pshop_country` VALUES (95, 1, 'Honduras', 'HND', 'HN');
INSERT INTO `#__pshop_country` VALUES (96, 1, 'Hong Kong', 'HKG', 'HK');
INSERT INTO `#__pshop_country` VALUES (97, 1, 'Hungary', 'HUN', 'HU');
INSERT INTO `#__pshop_country` VALUES (98, 1, 'Iceland', 'ISL', 'IS');
INSERT INTO `#__pshop_country` VALUES (99, 1, 'India', 'IND', 'IN');
INSERT INTO `#__pshop_country` VALUES (100, 1, 'Indonesia', 'IDN', 'ID');
INSERT INTO `#__pshop_country` VALUES (101, 1, 'Iran (Islamic Republic of)', 'IRN', 'IR');
INSERT INTO `#__pshop_country` VALUES (102, 1, 'Iraq', 'IRQ', 'IQ');
INSERT INTO `#__pshop_country` VALUES (103, 1, 'Ireland', 'IRL', 'IE');
INSERT INTO `#__pshop_country` VALUES (104, 1, 'Israel', 'ISR', 'IL');
INSERT INTO `#__pshop_country` VALUES (105, 1, 'Italy', 'ITA', 'IT');
INSERT INTO `#__pshop_country` VALUES (106, 1, 'Jamaica', 'JAM', 'JM');
INSERT INTO `#__pshop_country` VALUES (107, 1, 'Japan', 'JPN', 'JP');
INSERT INTO `#__pshop_country` VALUES (108, 1, 'Jordan', 'JOR', 'JO');
INSERT INTO `#__pshop_country` VALUES (109, 1, 'Kazakhstan', 'KAZ', 'KZ');
INSERT INTO `#__pshop_country` VALUES (110, 1, 'Kenya', 'KEN', 'KE');
INSERT INTO `#__pshop_country` VALUES (111, 1, 'Kiribati', 'KIR', 'KI');
INSERT INTO `#__pshop_country` VALUES (112, 1, 'Korea, Democratic People\'s Republic of', 'PRK', 'KP');
INSERT INTO `#__pshop_country` VALUES (113, 1, 'Korea, Republic of', 'KOR', 'KR');
INSERT INTO `#__pshop_country` VALUES (114, 1, 'Kuwait', 'KWT', 'KW');
INSERT INTO `#__pshop_country` VALUES (115, 1, 'Kyrgyzstan', 'KGZ', 'KG');
INSERT INTO `#__pshop_country` VALUES (116, 1, 'Lao People\'s Democratic Republic', 'LAO', 'LA');
INSERT INTO `#__pshop_country` VALUES (117, 1, 'Latvia', 'LVA', 'LV');
INSERT INTO `#__pshop_country` VALUES (118, 1, 'Lebanon', 'LBN', 'LB');
INSERT INTO `#__pshop_country` VALUES (119, 1, 'Lesotho', 'LSO', 'LS');
INSERT INTO `#__pshop_country` VALUES (120, 1, 'Liberia', 'LBR', 'LR');
INSERT INTO `#__pshop_country` VALUES (121, 1, 'Libyan Arab Jamahiriya', 'LBY', 'LY');
INSERT INTO `#__pshop_country` VALUES (122, 1, 'Liechtenstein', 'LIE', 'LI');
INSERT INTO `#__pshop_country` VALUES (123, 1, 'Lithuania', 'LTU', 'LT');
INSERT INTO `#__pshop_country` VALUES (124, 1, 'Luxembourg', 'LUX', 'LU');
INSERT INTO `#__pshop_country` VALUES (125, 1, 'Macau', 'MAC', 'MO');
INSERT INTO `#__pshop_country` VALUES (126, 1, 'Macedonia, The Former Yugoslav Republic of', 'MKD', 'MK');
INSERT INTO `#__pshop_country` VALUES (127, 1, 'Madagascar', 'MDG', 'MG');
INSERT INTO `#__pshop_country` VALUES (128, 1, 'Malawi', 'MWI', 'MW');
INSERT INTO `#__pshop_country` VALUES (129, 1, 'Malaysia', 'MYS', 'MY');
INSERT INTO `#__pshop_country` VALUES (130, 1, 'Maldives', 'MDV', 'MV');
INSERT INTO `#__pshop_country` VALUES (131, 1, 'Mali', 'MLI', 'ML');
INSERT INTO `#__pshop_country` VALUES (132, 1, 'Malta', 'MLT', 'MT');
INSERT INTO `#__pshop_country` VALUES (133, 1, 'Marshall Islands', 'MHL', 'MH');
INSERT INTO `#__pshop_country` VALUES (134, 1, 'Martinique', 'MTQ', 'MQ');
INSERT INTO `#__pshop_country` VALUES (135, 1, 'Mauritania', 'MRT', 'MR');
INSERT INTO `#__pshop_country` VALUES (136, 1, 'Mauritius', 'MUS', 'MU');
INSERT INTO `#__pshop_country` VALUES (137, 1, 'Mayotte', 'MYT', 'YT');
INSERT INTO `#__pshop_country` VALUES (138, 1, 'Mexico', 'MEX', 'MX');
INSERT INTO `#__pshop_country` VALUES (139, 1, 'Micronesia, Federated States of', 'FSM', 'FM');
INSERT INTO `#__pshop_country` VALUES (140, 1, 'Moldova, Republic of', 'MDA', 'MD');
INSERT INTO `#__pshop_country` VALUES (141, 1, 'Monaco', 'MCO', 'MC');
INSERT INTO `#__pshop_country` VALUES (142, 1, 'Mongolia', 'MNG', 'MN');
INSERT INTO `#__pshop_country` VALUES (143, 1, 'Montserrat', 'MSR', 'MS');
INSERT INTO `#__pshop_country` VALUES (144, 1, 'Morocco', 'MAR', 'MA');
INSERT INTO `#__pshop_country` VALUES (145, 1, 'Mozambique', 'MOZ', 'MZ');
INSERT INTO `#__pshop_country` VALUES (146, 1, 'Myanmar', 'MMR', 'MM');
INSERT INTO `#__pshop_country` VALUES (147, 1, 'Namibia', 'NAM', 'NA');
INSERT INTO `#__pshop_country` VALUES (148, 1, 'Nauru', 'NRU', 'NR');
INSERT INTO `#__pshop_country` VALUES (149, 1, 'Nepal', 'NPL', 'NP');
INSERT INTO `#__pshop_country` VALUES (150, 1, 'Netherlands', 'NLD', 'NL');
INSERT INTO `#__pshop_country` VALUES (151, 1, 'Netherlands Antilles', 'ANT', 'AN');
INSERT INTO `#__pshop_country` VALUES (152, 1, 'New Caledonia', 'NCL', 'NC');
INSERT INTO `#__pshop_country` VALUES (153, 1, 'New Zealand', 'NZL', 'NZ');
INSERT INTO `#__pshop_country` VALUES (154, 1, 'Nicaragua', 'NIC', 'NI');
INSERT INTO `#__pshop_country` VALUES (155, 1, 'Niger', 'NER', 'NE');
INSERT INTO `#__pshop_country` VALUES (156, 1, 'Nigeria', 'NGA', 'NG');
INSERT INTO `#__pshop_country` VALUES (157, 1, 'Niue', 'NIU', 'NU');
INSERT INTO `#__pshop_country` VALUES (158, 1, 'Norfolk Island', 'NFK', 'NF');
INSERT INTO `#__pshop_country` VALUES (159, 1, 'Northern Mariana Islands', 'MNP', 'MP');
INSERT INTO `#__pshop_country` VALUES (160, 1, 'Norway', 'NOR', 'NO');
INSERT INTO `#__pshop_country` VALUES (161, 1, 'Oman', 'OMN', 'OM');
INSERT INTO `#__pshop_country` VALUES (162, 1, 'Pakistan', 'PAK', 'PK');
INSERT INTO `#__pshop_country` VALUES (163, 1, 'Palau', 'PLW', 'PW');
INSERT INTO `#__pshop_country` VALUES (164, 1, 'Panama', 'PAN', 'PA');
INSERT INTO `#__pshop_country` VALUES (165, 1, 'Papua New Guinea', 'PNG', 'PG');
INSERT INTO `#__pshop_country` VALUES (166, 1, 'Paraguay', 'PRY', 'PY');
INSERT INTO `#__pshop_country` VALUES (167, 1, 'Peru', 'PER', 'PE');
INSERT INTO `#__pshop_country` VALUES (168, 1, 'Philippines', 'PHL', 'PH');
INSERT INTO `#__pshop_country` VALUES (169, 1, 'Pitcairn', 'PCN', 'PN');
INSERT INTO `#__pshop_country` VALUES (170, 1, 'Poland', 'POL', 'PL');
INSERT INTO `#__pshop_country` VALUES (171, 1, 'Portugal', 'PRT', 'PT');
INSERT INTO `#__pshop_country` VALUES (172, 1, 'Puerto Rico', 'PRI', 'PR');
INSERT INTO `#__pshop_country` VALUES (173, 1, 'Qatar', 'QAT', 'QA');
INSERT INTO `#__pshop_country` VALUES (174, 1, 'Reunion', 'REU', 'RE');
INSERT INTO `#__pshop_country` VALUES (175, 1, 'Romania', 'ROM', 'RO');
INSERT INTO `#__pshop_country` VALUES (176, 1, 'Russian Federation', 'RUS', 'RU');
INSERT INTO `#__pshop_country` VALUES (177, 1, 'Rwanda', 'RWA', 'RW');
INSERT INTO `#__pshop_country` VALUES (178, 1, 'Saint Kitts and Nevis', 'KNA', 'KN');
INSERT INTO `#__pshop_country` VALUES (179, 1, 'Saint Lucia', 'LCA', 'LC');
INSERT INTO `#__pshop_country` VALUES (180, 1, 'Saint Vincent and the Grenadines', 'VCT', 'VC');
INSERT INTO `#__pshop_country` VALUES (181, 1, 'Samoa', 'WSM', 'WS');
INSERT INTO `#__pshop_country` VALUES (182, 1, 'San Marino', 'SMR', 'SM');
INSERT INTO `#__pshop_country` VALUES (183, 1, 'Sao Tome and Principe', 'STP', 'ST');
INSERT INTO `#__pshop_country` VALUES (184, 1, 'Saudi Arabia', 'SAU', 'SA');
INSERT INTO `#__pshop_country` VALUES (185, 1, 'Senegal', 'SEN', 'SN');
INSERT INTO `#__pshop_country` VALUES (186, 1, 'Seychelles', 'SYC', 'SC');
INSERT INTO `#__pshop_country` VALUES (187, 1, 'Sierra Leone', 'SLE', 'SL');
INSERT INTO `#__pshop_country` VALUES (188, 1, 'Singapore', 'SGP', 'SG');
INSERT INTO `#__pshop_country` VALUES (189, 1, 'Slovakia (Slovak Republic)', 'SVK', 'SK');
INSERT INTO `#__pshop_country` VALUES (190, 1, 'Slovenia', 'SVN', 'SI');
INSERT INTO `#__pshop_country` VALUES (191, 1, 'Solomon Islands', 'SLB', 'SB');
INSERT INTO `#__pshop_country` VALUES (192, 1, 'Somalia', 'SOM', 'SO');
INSERT INTO `#__pshop_country` VALUES (193, 1, 'South Africa', 'ZAF', 'ZA');
INSERT INTO `#__pshop_country` VALUES (194, 1, 'South Georgia and the South Sandwich Islands', 'SGS', 'GS');
INSERT INTO `#__pshop_country` VALUES (195, 1, 'Spain', 'ESP', 'ES');
INSERT INTO `#__pshop_country` VALUES (196, 1, 'Sri Lanka', 'LKA', 'LK');
INSERT INTO `#__pshop_country` VALUES (197, 1, 'St. Helena', 'SHN', 'SH');
INSERT INTO `#__pshop_country` VALUES (198, 1, 'St. Pierre and Miquelon', 'SPM', 'PM');
INSERT INTO `#__pshop_country` VALUES (199, 1, 'Sudan', 'SDN', 'SD');
INSERT INTO `#__pshop_country` VALUES (200, 1, 'Suriname', 'SUR', 'SR');
INSERT INTO `#__pshop_country` VALUES (201, 1, 'Svalbard and Jan Mayen Islands', 'SJM', 'SJ');
INSERT INTO `#__pshop_country` VALUES (202, 1, 'Swaziland', 'SWZ', 'SZ');
INSERT INTO `#__pshop_country` VALUES (203, 1, 'Sweden', 'SWE', 'SE');
INSERT INTO `#__pshop_country` VALUES (204, 1, 'Switzerland', 'CHE', 'CH');
INSERT INTO `#__pshop_country` VALUES (205, 1, 'Syrian Arab Republic', 'SYR', 'SY');
INSERT INTO `#__pshop_country` VALUES (206, 1, 'Taiwan', 'TWN', 'TW');
INSERT INTO `#__pshop_country` VALUES (207, 1, 'Tajikistan', 'TJK', 'TJ');
INSERT INTO `#__pshop_country` VALUES (208, 1, 'Tanzania, United Republic of', 'TZA', 'TZ');
INSERT INTO `#__pshop_country` VALUES (209, 1, 'Thailand', 'THA', 'TH');
INSERT INTO `#__pshop_country` VALUES (210, 1, 'Togo', 'TGO', 'TG');
INSERT INTO `#__pshop_country` VALUES (211, 1, 'Tokelau', 'TKL', 'TK');
INSERT INTO `#__pshop_country` VALUES (212, 1, 'Tonga', 'TON', 'TO');
INSERT INTO `#__pshop_country` VALUES (213, 1, 'Trinidad and Tobago', 'TTO', 'TT');
INSERT INTO `#__pshop_country` VALUES (214, 1, 'Tunisia', 'TUN', 'TN');
INSERT INTO `#__pshop_country` VALUES (215, 1, 'Turkey', 'TUR', 'TR');
INSERT INTO `#__pshop_country` VALUES (216, 1, 'Turkmenistan', 'TKM', 'TM');
INSERT INTO `#__pshop_country` VALUES (217, 1, 'Turks and Caicos Islands', 'TCA', 'TC');
INSERT INTO `#__pshop_country` VALUES (218, 1, 'Tuvalu', 'TUV', 'TV');
INSERT INTO `#__pshop_country` VALUES (219, 1, 'Uganda', 'UGA', 'UG');
INSERT INTO `#__pshop_country` VALUES (220, 1, 'Ukraine', 'UKR', 'UA');
INSERT INTO `#__pshop_country` VALUES (221, 1, 'United Arab Emirates', 'ARE', 'AE');
INSERT INTO `#__pshop_country` VALUES (222, 1, 'United Kingdom', 'GBR', 'GB');
INSERT INTO `#__pshop_country` VALUES (223, 1, 'United States', 'USA', 'US');
INSERT INTO `#__pshop_country` VALUES (224, 1, 'United States Minor Outlying Islands', 'UMI', 'UM');
INSERT INTO `#__pshop_country` VALUES (225, 1, 'Uruguay', 'URY', 'UY');
INSERT INTO `#__pshop_country` VALUES (226, 1, 'Uzbekistan', 'UZB', 'UZ');
INSERT INTO `#__pshop_country` VALUES (227, 1, 'Vanuatu', 'VUT', 'VU');
INSERT INTO `#__pshop_country` VALUES (228, 1, 'Vatican City State (Holy See)', 'VAT', 'VA');
INSERT INTO `#__pshop_country` VALUES (229, 1, 'Venezuela', 'VEN', 'VE');
INSERT INTO `#__pshop_country` VALUES (230, 1, 'Viet Nam', 'VNM', 'VN');
INSERT INTO `#__pshop_country` VALUES (231, 1, 'Virgin Islands (British)', 'VGB', 'VG');
INSERT INTO `#__pshop_country` VALUES (232, 1, 'Virgin Islands (U.S.)', 'VIR', 'VI');
INSERT INTO `#__pshop_country` VALUES (233, 1, 'Wallis and Futuna Islands', 'WLF', 'WF');
INSERT INTO `#__pshop_country` VALUES (234, 1, 'Western Sahara', 'ESH', 'EH');
INSERT INTO `#__pshop_country` VALUES (235, 1, 'Yemen', 'YEM', 'YE');
INSERT INTO `#__pshop_country` VALUES (236, 1, 'Yugoslavia', 'YUG', 'YU');
INSERT INTO `#__pshop_country` VALUES (237, 1, 'Zaire', 'ZAR', 'ZR');
INSERT INTO `#__pshop_country` VALUES (238, 1, 'Zambia', 'ZMB', 'ZM');
INSERT INTO `#__pshop_country` VALUES (239, 1, 'Zimbabwe', 'ZWE', 'ZW');


CREATE TABLE IF NOT EXISTS `#__pshop_coupons` (
  `coupon_id` int(16) NOT NULL auto_increment,
  `coupon_code` varchar(32) NOT NULL default '',
  `percent_or_total` enum('percent','total') NOT NULL default 'percent',
  `coupon_type` ENUM( 'gift', 'permanent' ) DEFAULT 'gift' NOT NULL,
  `coupon_value` decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (`coupon_id`)
) TYPE=MyISAM AUTO_INCREMENT=6 ;

CREATE TABLE `#__pshop_csv` (
  csv_product_sku int(2) default NULL,
  csv_product_s_desc int(2) default NULL,
  csv_product_desc int(2) default NULL,
  csv_product_thumb_image int(2) default NULL,
  csv_product_full_image int(2) default NULL,
  csv_product_weight int(2) default NULL,
  csv_product_weight_uom int(2) default NULL,
  csv_product_length int(2) default NULL,
  csv_product_width int(2) default NULL,
  csv_product_height int(2) default NULL,
  csv_product_lwh_uom int(2) default NULL,
  csv_product_in_stock int(2) default NULL,
  csv_product_available_date int(2) default NULL,
  csv_product_special int(2) default NULL,
  csv_product_discount_id int(2) default NULL,
  csv_product_name int(2) default NULL,
  csv_product_price int(2) default NULL,
  csv_category_path int(2) default NULL,
  csv_manufacturer_id int(2) default NULL
) TYPE=MyISAM;
INSERT INTO `#__pshop_csv` VALUES (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19);


CREATE TABLE `#__pshop_currency` (
  `currency_id` int(11) NOT NULL auto_increment,
  `currency_name` varchar(64) default NULL,
  `currency_code` char(3) default NULL,
  PRIMARY KEY  (`currency_id`),
  KEY `idx_currency_name` (`currency_name`)
) TYPE=MyISAM AUTO_INCREMENT=157 ;
INSERT INTO `#__pshop_currency` VALUES (1,'Andorran Peseta','ADP');
INSERT INTO `#__pshop_currency` VALUES (2,'United Arab Emirates Dirham','AED');
INSERT INTO `#__pshop_currency` VALUES (3,'Afghanistan Afghani','AFA');
INSERT INTO `#__pshop_currency` VALUES (4,'Albanian Lek','ALL');
INSERT INTO `#__pshop_currency` VALUES (5,'Netherlands Antillian Guilder','ANG');
INSERT INTO `#__pshop_currency` VALUES (6,'Angolan Kwanza','AOK');
INSERT INTO `#__pshop_currency` VALUES (7,'Argentinian Austral','ARA');
INSERT INTO `#__pshop_currency` VALUES (9,'Australian Dollar','AUD');
INSERT INTO `#__pshop_currency` VALUES (10,'Aruban Florin','AWG');
INSERT INTO `#__pshop_currency` VALUES (11,'Barbados Dollar','BBD');
INSERT INTO `#__pshop_currency` VALUES (12,'Bangladeshi Taka','BDT');
INSERT INTO `#__pshop_currency` VALUES (14,'Bulgarian Lev','BGL');
INSERT INTO `#__pshop_currency` VALUES (15,'Bahraini Dinar','BHD');
INSERT INTO `#__pshop_currency` VALUES (16,'Burundi Franc','BIF');
INSERT INTO `#__pshop_currency` VALUES (17,'Bermudian Dollar','BMD');
INSERT INTO `#__pshop_currency` VALUES (18,'Brunei Dollar','BND');
INSERT INTO `#__pshop_currency` VALUES (19,'Bolivian Boliviano','BOB');
INSERT INTO `#__pshop_currency` VALUES (20,'Brazilian Cruzeiro','BRC');
INSERT INTO `#__pshop_currency` VALUES (21,'Bahamian Dollar','BSD');
INSERT INTO `#__pshop_currency` VALUES (22,'Bhutan Ngultrum','BTN');
INSERT INTO `#__pshop_currency` VALUES (23,'Burma Kyat','BUK');
INSERT INTO `#__pshop_currency` VALUES (24,'Botswanian Pula','BWP');
INSERT INTO `#__pshop_currency` VALUES (25,'Belize Dollar','BZD');
INSERT INTO `#__pshop_currency` VALUES (26,'Canadian Dollar','CAD');
INSERT INTO `#__pshop_currency` VALUES (27,'Swiss Franc','CHF');
INSERT INTO `#__pshop_currency` VALUES (28,'Chilean Unidades de Fomento','CLF');
INSERT INTO `#__pshop_currency` VALUES (29,'Chilean Peso','CLP');
INSERT INTO `#__pshop_currency` VALUES (30,'Yuan (Chinese) Renminbi','CNY');
INSERT INTO `#__pshop_currency` VALUES (31,'Colombian Peso','COP');
INSERT INTO `#__pshop_currency` VALUES (32,'Costa Rican Colon','CRC');
INSERT INTO `#__pshop_currency` VALUES (33,'Czech Koruna','CSK');
INSERT INTO `#__pshop_currency` VALUES (34,'Cuban Peso','CUP');
INSERT INTO `#__pshop_currency` VALUES (35,'Cape Verde Escudo','CVE');
INSERT INTO `#__pshop_currency` VALUES (36,'Cyprus Pound','CYP');
INSERT INTO `#__pshop_currency` VALUES (40,'Danish Krone','DKK');
INSERT INTO `#__pshop_currency` VALUES (41,'Dominican Peso','DOP');
INSERT INTO `#__pshop_currency` VALUES (42,'Algerian Dinar','DZD');
INSERT INTO `#__pshop_currency` VALUES (43,'Ecuador Sucre','ECS');
INSERT INTO `#__pshop_currency` VALUES (44,'Egyptian Pound','EGP');
INSERT INTO `#__pshop_currency` VALUES (46,'Ethiopian Birr','ETB');
INSERT INTO `#__pshop_currency` VALUES (47,'Euro','EUR');
INSERT INTO `#__pshop_currency` VALUES (49,'Fiji Dollar','FJD');
INSERT INTO `#__pshop_currency` VALUES (50,'Falkland Islands Pound','FKP');
INSERT INTO `#__pshop_currency` VALUES (52,'British Pound','GBP');
INSERT INTO `#__pshop_currency` VALUES (53,'Ghanaian Cedi','GHC');
INSERT INTO `#__pshop_currency` VALUES (54,'Gibraltar Pound','GIP');
INSERT INTO `#__pshop_currency` VALUES (55,'Gambian Dalasi','GMD');
INSERT INTO `#__pshop_currency` VALUES (56,'Guinea Franc','GNF');
INSERT INTO `#__pshop_currency` VALUES (58,'Guatemalan Quetzal','GTQ');
INSERT INTO `#__pshop_currency` VALUES (59,'Guinea-Bissau Peso','GWP');
INSERT INTO `#__pshop_currency` VALUES (60,'Guyanan Dollar','GYD');
INSERT INTO `#__pshop_currency` VALUES (61,'Hong Kong Dollar','HKD');
INSERT INTO `#__pshop_currency` VALUES (62,'Honduran Lempira','HNL');
INSERT INTO `#__pshop_currency` VALUES (63,'Haitian Gourde','HTG');
INSERT INTO `#__pshop_currency` VALUES (64,'Hungarian Forint','HUF');
INSERT INTO `#__pshop_currency` VALUES (65,'Indonesian Rupiah','IDR');
INSERT INTO `#__pshop_currency` VALUES (66,'Irish Punt','IEP');
INSERT INTO `#__pshop_currency` VALUES (67,'Israeli Shekel','ILS');
INSERT INTO `#__pshop_currency` VALUES (68,'Indian Rupee','INR');
INSERT INTO `#__pshop_currency` VALUES (69,'Iraqi Dinar','IQD');
INSERT INTO `#__pshop_currency` VALUES (70,'Iranian Rial','IRR');
INSERT INTO `#__pshop_currency` VALUES (73,'Jamaican Dollar','JMD');
INSERT INTO `#__pshop_currency` VALUES (74,'Jordanian Dinar','JOD');
INSERT INTO `#__pshop_currency` VALUES (75,'Japanese Yen','JPY');
INSERT INTO `#__pshop_currency` VALUES (76,'Kenyan Schilling','KES');
INSERT INTO `#__pshop_currency` VALUES (77,'Kampuchean (Cambodian) Riel','KHR');
INSERT INTO `#__pshop_currency` VALUES (78,'Comoros Franc','KMF');
INSERT INTO `#__pshop_currency` VALUES (79,'North Korean Won','KPW');
INSERT INTO `#__pshop_currency` VALUES (80,'(South) Korean Won','KRW');
INSERT INTO `#__pshop_currency` VALUES (81,'Kuwaiti Dinar','KWD');
INSERT INTO `#__pshop_currency` VALUES (82,'Cayman Islands Dollar','KYD');
INSERT INTO `#__pshop_currency` VALUES (83,'Lao Kip','LAK');
INSERT INTO `#__pshop_currency` VALUES (84,'Lebanese Pound','LBP');
INSERT INTO `#__pshop_currency` VALUES (85,'Sri Lanka Rupee','LKR');
INSERT INTO `#__pshop_currency` VALUES (86,'Liberian Dollar','LRD');
INSERT INTO `#__pshop_currency` VALUES (87,'Lesotho Loti','LSL');
INSERT INTO `#__pshop_currency` VALUES (89,'Libyan Dinar','LYD');
INSERT INTO `#__pshop_currency` VALUES (90,'Moroccan Dirham','MAD');
INSERT INTO `#__pshop_currency` VALUES (91,'Malagasy Franc','MGF');
INSERT INTO `#__pshop_currency` VALUES (92,'Mongolian Tugrik','MNT');
INSERT INTO `#__pshop_currency` VALUES (93,'Macau Pataca','MOP');
INSERT INTO `#__pshop_currency` VALUES (94,'Mauritanian Ouguiya','MRO');
INSERT INTO `#__pshop_currency` VALUES (95,'Maltese Lira','MTL');
INSERT INTO `#__pshop_currency` VALUES (96,'Mauritius Rupee','MUR');
INSERT INTO `#__pshop_currency` VALUES (97,'Maldive Rufiyaa','MVR');
INSERT INTO `#__pshop_currency` VALUES (98,'Malawi Kwacha','MWK');
INSERT INTO `#__pshop_currency` VALUES (99,'Mexican Peso','MXP');
INSERT INTO `#__pshop_currency` VALUES (100,'Malaysian Ringgit','MYR');
INSERT INTO `#__pshop_currency` VALUES (101,'Mozambique Metical','MZM');
INSERT INTO `#__pshop_currency` VALUES (102,'Nigerian Naira','NGN');
INSERT INTO `#__pshop_currency` VALUES (103,'Nicaraguan Cordoba','NIC');
INSERT INTO `#__pshop_currency` VALUES (105,'Norwegian Kroner','NOK');
INSERT INTO `#__pshop_currency` VALUES (106,'Nepalese Rupee','NPR');
INSERT INTO `#__pshop_currency` VALUES (107,'New Zealand Dollar','NZD');
INSERT INTO `#__pshop_currency` VALUES (108,'Omani Rial','OMR');
INSERT INTO `#__pshop_currency` VALUES (109,'Panamanian Balboa','PAB');
INSERT INTO `#__pshop_currency` VALUES (110,'Peruvian Inti','PEI');
INSERT INTO `#__pshop_currency` VALUES (111,'Papua New Guinea Kina','PGK');
INSERT INTO `#__pshop_currency` VALUES (112,'Philippine Peso','PHP');
INSERT INTO `#__pshop_currency` VALUES (113,'Pakistan Rupee','PKR');
INSERT INTO `#__pshop_currency` VALUES (114,'Polish Zloty','PLZ');
INSERT INTO `#__pshop_currency` VALUES (116,'Paraguay Guarani','PYG');
INSERT INTO `#__pshop_currency` VALUES (117,'Qatari Rial','QAR');
INSERT INTO `#__pshop_currency` VALUES (118,'Romanian Leu','ROL');
INSERT INTO `#__pshop_currency` VALUES (119,'Rwanda Franc','RWF');
INSERT INTO `#__pshop_currency` VALUES (120,'Saudi Arabian Riyal','SAR');
INSERT INTO `#__pshop_currency` VALUES (121,'Solomon Islands Dollar','SBD');
INSERT INTO `#__pshop_currency` VALUES (122,'Seychelles Rupee','SCR');
INSERT INTO `#__pshop_currency` VALUES (123,'Sudanese Pound','SDP');
INSERT INTO `#__pshop_currency` VALUES (124,'Swedish Krona','SEK');
INSERT INTO `#__pshop_currency` VALUES (125,'Singapore Dollar','SGD');
INSERT INTO `#__pshop_currency` VALUES (126,'St. Helena Pound','SHP');
INSERT INTO `#__pshop_currency` VALUES (127,'Sierra Leone Leone','SLL');
INSERT INTO `#__pshop_currency` VALUES (128,'Somali Schilling','SOS');
INSERT INTO `#__pshop_currency` VALUES (129,'Suriname Guilder','SRG');
INSERT INTO `#__pshop_currency` VALUES (130,'Sao Tome and Principe Dobra','STD');
INSERT INTO `#__pshop_currency` VALUES (131,'USSR Rouble','SUR');
INSERT INTO `#__pshop_currency` VALUES (132,'El Salvador Colon','SVC');
INSERT INTO `#__pshop_currency` VALUES (133,'Syrian Potmd','SYP');
INSERT INTO `#__pshop_currency` VALUES (134,'Swaziland Lilangeni','SZL');
INSERT INTO `#__pshop_currency` VALUES (135,'Thai Bhat','THB');
INSERT INTO `#__pshop_currency` VALUES (136,'Tunisian Dinar','TND');
INSERT INTO `#__pshop_currency` VALUES (137,'Tongan Pa\'anga','TOP');
INSERT INTO `#__pshop_currency` VALUES (138,'East Timor Escudo','TPE');
INSERT INTO `#__pshop_currency` VALUES (139,'Turkish Lira','TRL');
INSERT INTO `#__pshop_currency` VALUES (140,'Trinidad and Tobago Dollar','TTD');
INSERT INTO `#__pshop_currency` VALUES (141,'Taiwan Dollar','TWD');
INSERT INTO `#__pshop_currency` VALUES (142,'Tanzanian Schilling','TZS');
INSERT INTO `#__pshop_currency` VALUES (143,'Uganda Shilling','UGS');
INSERT INTO `#__pshop_currency` VALUES (144,'US Dollar','USD');
INSERT INTO `#__pshop_currency` VALUES (145,'Uruguayan Peso','UYP');
INSERT INTO `#__pshop_currency` VALUES (146,'Venezualan Bolivar','VEB');
INSERT INTO `#__pshop_currency` VALUES (147,'Vietnamese Dong','VND');
INSERT INTO `#__pshop_currency` VALUES (148,'Vanuatu Vatu','VUV');
INSERT INTO `#__pshop_currency` VALUES (149,'Samoan Tala','WST');
INSERT INTO `#__pshop_currency` VALUES (150,'Democratic Yemeni Dinar','YDD');
INSERT INTO `#__pshop_currency` VALUES (151,'Yemeni Rial','YER');
INSERT INTO `#__pshop_currency` VALUES (152,'New Yugoslavia Dinar','YUD');
INSERT INTO `#__pshop_currency` VALUES (153,'South African Rand','ZAR');
INSERT INTO `#__pshop_currency` VALUES (154,'Zambian Kwacha','ZMK');
INSERT INTO `#__pshop_currency` VALUES (155,'Zaire Zaire','ZRZ');
INSERT INTO `#__pshop_currency` VALUES (156,'Zimbabwe Dollar','ZWD');


CREATE TABLE `#__pshop_function` (
  `function_id` int(11) NOT NULL auto_increment,
  `module_id` int(11) default NULL,
  `function_name` varchar(32) default NULL,
  `function_class` varchar(32) default NULL,
  `function_method` varchar(32) default NULL,
  `function_description` text,
  `function_perms` varchar(255) default NULL,
  PRIMARY KEY  (`function_id`),
  KEY `idx_function_module_id` (`module_id`),
  KEY `idx_function_name` (`function_name`)
) TYPE=MyISAM AUTO_INCREMENT=110 ;
INSERT INTO `#__pshop_function` VALUES (1, 1, 'userAdd', 'ps_user', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (2, 1, 'userDelete', 'ps_user', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (3, 1, 'userUpdate', 'ps_user', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (4, 1, 'adminPasswdUpdate', 'ps_user', 'update_admin_passwd', 'Updates Site Administrator Password', 'admin');
INSERT INTO `#__pshop_function` VALUES (31, 2, 'productAdd', 'ps_product', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (6, 1, 'functionAdd', 'ps_function', 'add', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (7, 1, 'functionUpdate', 'ps_function', 'update', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (8, 1, 'functionDelete', 'ps_function', 'delete', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (9, 1, 'userLogout', 'ps_user', 'logout', '', 'none');
INSERT INTO `#__pshop_function` VALUES (10, 1, 'userAddressAdd', 'ps_user_address', 'add', '', 'admin,storeadmin,shopper,demo');
INSERT INTO `#__pshop_function` VALUES (11, 1, 'userAddressUpdate', 'ps_user_address', 'update', '', 'admin,storeadmin,shopper');
INSERT INTO `#__pshop_function` VALUES (12, 1, 'userAddressDelete', 'ps_user_address', 'delete', '', 'admin,storeadmin,shopper');
INSERT INTO `#__pshop_function` VALUES (13, 1, 'moduleAdd', 'ps_module', 'add', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (14, 1, 'moduleUpdate', 'ps_module', 'update', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (15, 1, 'moduleDelete', 'ps_module', 'delete', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (16, 1, 'userLogin', 'ps_user', 'login', '', 'none');
INSERT INTO `#__pshop_function` VALUES (17, 3, 'vendorAdd', 'ps_vendor', 'add', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (18, 3, 'vendorUpdate', 'ps_vendor', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (19, 3, 'vendorDelete', 'ps_vendor', 'delete', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (20, 3, 'vendorCategoryAdd', 'ps_vendor_category', 'add', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (21, 3, 'vendorCategoryUpdate', 'ps_vendor_category', 'update', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (22, 3, 'vendorCategoryDelete', 'ps_vendor_category', 'delete', '', 'admin');
INSERT INTO `#__pshop_function` VALUES (23, 4, 'shopperAdd', 'ps_shopper', 'add', '', 'none');
INSERT INTO `#__pshop_function` VALUES (24, 4, 'shopperDelete', 'ps_shopper', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (25, 4, 'shopperUpdate', 'ps_shopper', 'update', '', 'admin,storeadmin,shopper');
INSERT INTO `#__pshop_function` VALUES (26, 4, 'shopperGroupAdd', 'ps_shopper_group', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (27, 4, 'shopperGroupUpdate', 'ps_shopper_group', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (28, 4, 'shopperGroupDelete', 'ps_shopper_group', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (29, 5, 'orderSearch', 'ps_order', 'find', '', 'admin,storeadmin,demo');
INSERT INTO `#__pshop_function` VALUES (30, 5, 'orderStatusSet', 'ps_order', 'order_status_update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (32, 2, 'productDelete', 'ps_product', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (33, 2, 'productUpdate', 'ps_product', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (34, 2, 'productCategoryAdd', 'ps_product_category', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (35, 2, 'productCategoryUpdate', 'ps_product_category', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (36, 2, 'productCategoryDelete', 'ps_product_category', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (37, 2, 'productPriceAdd', 'ps_product_price', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (38, 2, 'productPriceUpdate', 'ps_product_price', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (39, 2, 'productPriceDelete', 'ps_product_price', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (40, 2, 'productAttributeAdd', 'ps_product_attribute', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (41, 2, 'productAttributeUpdate', 'ps_product_attribute', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (42, 2, 'productAttributeDelete', 'ps_product_attribute', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (43, 7, 'cartAdd', 'ps_cart', 'add', '', 'none');
INSERT INTO `#__pshop_function` VALUES (44, 7, 'cartUpdate', 'ps_cart', 'update', '', 'none');
INSERT INTO `#__pshop_function` VALUES (45, 7, 'cartDelete', 'ps_cart', 'delete', '', 'none');
INSERT INTO `#__pshop_function` VALUES (46, 10, 'checkoutComplete', 'ps_checkout', 'add', '', 'shopper,storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (47, 1, 'setLanguage', 'ps_module', 'set_language', '', 'none');
INSERT INTO `#__pshop_function` VALUES (48, 8, 'paymentMethodUpdate', 'ps_payment_method', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (49, 8, 'paymentMethodAdd', 'ps_payment_method', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (50, 8, 'paymentMethodDelete', 'ps_payment_method', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (51, 5, 'orderDelete', 'ps_order', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (52, 11, 'addTaxRate', 'ps_tax', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (53, 11, 'updateTaxRate', 'ps_tax', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (54, 11, 'deleteTaxRate', 'ps_tax', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (55, 10, 'checkoutValidateST', 'ps_checkout', 'validate_shipto', '', 'none');
INSERT INTO `#__pshop_function` VALUES (59, 5, 'orderStatusUpdate', 'ps_order_status', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (60, 5, 'orderStatusAdd', 'ps_order_status', 'add', '', 'storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (61, 5, 'orderStatusDelete', 'ps_order_status', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES (62, 1, 'currencyAdd', 'ps_currency', 'add', 'add a currency', 'storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (63, 1, 'currencyUpdate', 'ps_currency', 'update', '        update a currency', 'storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (64, 1, 'currencyDelete', 'ps_currency', 'delete', 'delete a currency', 'storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (65, 1, 'countryAdd', 'ps_country', 'add', 'Add a country ', 'storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (66, 1, 'countryUpdate', 'ps_country', 'update', 'Update a country record', 'storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (67, 1, 'countryDelete', 'ps_country', 'delete', 'Delete a country record', 'storeadmin,admin');
INSERT INTO `#__pshop_function` VALUES (68, 2, 'product_csv', 'ps_csv', 'upload_csv', '', 'admin');
INSERT INTO `#__pshop_function` VALUES ('', 7, 'waitingListAdd', 'zw_waiting_list', 'add', '', 'none');
INSERT INTO `#__pshop_function` VALUES ('', 13, 'addzone', 'ps_zone', 'add', 'This will add a zone', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 13, 'updatezone', 'ps_zone', 'update', 'This will update a zone', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 13, 'deletezone', 'ps_zone', 'delete', 'This will delete a zone', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 13, 'zoneassign', 'ps_zone', 'assign', 'This will assign a country to a zone', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 1, 'writeConfig', 'ps_config', 'writeconfig', 'This will write the configuration details to phpshop.cfg.php', 'admin');
INSERT INTO `#__pshop_function` VALUES ('', '12839', 'carrierAdd', 'ps_shipping', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '12839', 'carrierDelete', 'ps_shipping', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '12839', 'carrierUpdate', 'ps_shipping', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '12839', 'rateAdd', 'ps_shipping', 'rate_add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '12839', 'rateUpdate', 'ps_shipping', 'rate_update', '', 'admin,shopadmin');
INSERT INTO `#__pshop_function` VALUES ('', '12839', 'rateDelete', 'ps_shipping', 'rate_delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '10', 'checkoutProcess', 'ps_checkout', 'process', '', 'shopper,storeadmin,admin,demo');
INSERT INTO `#__pshop_function` VALUES ('', '5', 'downloadRequest', 'ps_order', 'download_request', 'This checks if the download request is valid and sends the file to the browser as file download if the request was successful, otherwise echoes an error', 'admin,storeadmin,shopper');
INSERT INTO `#__pshop_function` VALUES ('', '98', 'affiliateAdd', 'ps_affiliate', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '98', 'affiliateUpdate', 'ps_affiliate', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '98', 'affiliateDelete', 'ps_affiliate', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '98', 'affiliateEmail', 'ps_affiliate', 'email', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '99', 'manufacturerAdd', 'ps_manufacturer', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '99', 'manufacturerUpdate', 'ps_manufacturer', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '99', 'manufacturerDelete', 'ps_manufacturer', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '99', 'manufacturercategoryAdd', 'ps_manufacturer_category', 'add', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '99', 'manufacturercategoryUpdate', 'ps_manufacturer_category', 'update', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '99', 'manufacturercategoryDelete', 'ps_manufacturer_category', 'delete', '', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '7', 'addReview', 'ps_reviews', 'process_review', 'This lets the user add a review and rating to a product.', 'admin,storeadmin,shopper,demo');
INSERT INTO `#__pshop_function` VALUES ('', '7', 'productReviewDelete', 'ps_reviews', 'delete_review', 'This deletes a review and from a product.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '8', 'creditcardAdd', 'ps_creditcard', 'add', 'Adds a Credit Card entry.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '8', 'creditcardUpdate', 'ps_creditcard', 'update', 'Updates a Credit Card entry.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '8', 'creditcardDelete', 'ps_creditcard', 'delete', 'Deletes a Credit Card entry.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '2', 'publishProduct', 'ps_product', 'product_publish', 'Changes the product_publish field, so that a product can be published or unpublished easily.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '2', 'export_csv', 'ps_csv', 'export_csv', 'This function exports all relevant product data to CSV.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', '2', 'reorder', 'ps_product_category', 'reorder', 'Changes the list order of a category.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 2, 'discountAdd', 'ps_product_discount', 'add', 'Adds a discount.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 2, 'discountUpdate', 'ps_product_discount', 'update', 'Updates a discount.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 2, 'discountDelete', 'ps_product_discount', 'delete', 'Deletes a discount.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 12843, 'couponAdd', 'ps_coupon', 'add_coupon_code', 'Adds a Coupon.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 12843, 'couponUpdate', 'ps_coupon', 'update_coupon', 'Updates a Coupon.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 12843, 'couponDelete', 'ps_coupon', 'remove_coupon_code', 'Deletes a Coupon.', 'admin,storeadmin');
INSERT INTO `#__pshop_function` VALUES ('', 12843, 'couponProcess', 'ps_coupon', 'process_coupon_code', 'Processes a Coupon.', 'admin,storeadmin,shopper,demo');


CREATE TABLE `#__pshop_manufacturer` (
    `manufacturer_id` int(11) NOT NULL auto_increment,
    `mf_name` varchar(64) default NULL,
    `mf_email` varchar(255) default NULL,
    `mf_desc` text,
    `mf_category_id` int(11) default NULL,
    `mf_url` VARCHAR( 255 ) NOT NULL,
    PRIMARY KEY  (`manufacturer_id`)
  ) TYPE=MyISAM;
INSERT INTO `#__pshop_manufacturer` VALUES ('1', 'Manufacturer', 'info@manufacturer.com', 'A manufacturer example.', '1', 'http://www.a-url.com');

CREATE TABLE `#__pshop_manufacturer_category` (
              `mf_category_id` int(11) NOT NULL auto_increment,
              `mf_category_name` varchar(64) default NULL,
              `mf_category_desc` text,
              PRIMARY KEY  (`mf_category_id`),
              KEY `idx_manufacturer_category_category_name` (`mf_category_name`)
            ) TYPE=MyISAM;
INSERT INTO `#__pshop_manufacturer_category` VALUES ('1', '-default-', 'This is the default manufacturer category');


CREATE TABLE `#__pshop_product_mf_xref` (
              `product_id` varchar(32) default NULL,
              `manufacturer_id` int(11) default NULL,
              KEY `idx_product_mf_xref_product_id` (`product_id`),
              KEY `idx_product_mf_xref_manufacturer_id` (`manufacturer_id`)
            ) TYPE=MyISAM;
            

CREATE TABLE `#__pshop_module` (
  `module_id` int(11) NOT NULL auto_increment,
  `module_name` varchar(255) default NULL,
  `module_description` text,
  `module_perms` varchar(255) default NULL,
  `module_header` varchar(255) default NULL,
  `module_footer` varchar(255) default NULL,
  `module_publish` char(1) default NULL,
  `list_order` int(11) default NULL,
  `language_code_1` varchar(4) default NULL,
  `language_code_2` varchar(4) default NULL,
  `language_code_3` varchar(4) default NULL,
  `language_code_4` varchar(4) default NULL,
  `language_code_5` varchar(4) default NULL,
  `language_file_1` varchar(255) default NULL,
  `language_file_2` varchar(255) default NULL,
  `language_file_3` varchar(255) default NULL,
  `language_file_4` varchar(255) default NULL,
  `language_file_5` varchar(255) default NULL,
  `module_label_1` varchar(255) default NULL,
  `module_label_2` varchar(255) default NULL,
  `module_label_3` varchar(255) default NULL,
  `module_label_4` varchar(255) default NULL,
  `module_label_5` varchar(255) default NULL,
  PRIMARY KEY  (`module_id`),
  KEY `idx_module_name` (`module_name`),
  KEY `idx_module_list_order` (`list_order`)
) TYPE=MyISAM AUTO_INCREMENT=12838 ;
INSERT INTO `#__pshop_module` VALUES (1, 'admin', '<h4>ADMINISTRATIVE USERS ONLY</h4>\r\n\r\n<p>Only used for the following:</p>\r\n<OL>\r\n\r\n<LI>User Maintenance</LI>\r\n<LI>Module Maintenance</LI>\r\n<LI>Function Maintenance</LI>\r\n</OL>\r\n', 'admin', 'header.ihtml', 'footer.ihtml', 'Y', 1, 'eng', 'esl', '', '', '', 'lang_eng.inc', 'lang_esl.inc', '', '', '', 'Admin', 'Admin', '', '', '');
INSERT INTO `#__pshop_module` VALUES (2, 'product', '<p>Here you can adminster your online catalog of products.  The Product Administrator allows you to create product categories, create new products, edit product attributes, and add product items for each attribute value.</p>', 'storeadmin,admin', 'header.ihtml', 'footer.ihtml', 'Y', 4, 'eng', 'esl', '', '', '', 'lang_en.inc', 'lang_es.inc', '', '', '', 'Products', 'Mis<br />Productos', '', '', '');
INSERT INTO `#__pshop_module` VALUES (3, 'vendor', '<h4>ADMINISTRATIVE USERS ONLY</h4>\r\n<p>Here you can manage the vendors on the phpShop system.</p>', 'admin', 'header.ihtml', 'footer.ihtml', 'Y', 6, 'eng', 'esl', '', '', '', 'lang_en.inc', 'lang_es.inc', '', '', '', 'Vendors', 'Los<br />Distribuidores', '', '', '');
INSERT INTO `#__pshop_module` VALUES (4, 'shopper', '<p>Manage shoppers in your store.  Allows you to create shopper groups.  Shopper groups can be used when setting the price for a product.  This allows you to create different prices for different types of users.  An example of this would be to have a \'wholesale\' group and a \'retail\' group. </p>', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'Y', 4, 'eng', 'esl', '', '', '', 'lang_en.inc', 'lang_es.inc', '', '', '', 'Shoppers', 'Mis<br />Clientes', '', '', '');
INSERT INTO `#__pshop_module` VALUES (5, 'order', '<p>View Order and Update Order Status.</p>', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'Y', 5, 'eng', 'esl', '', '', '', 'lang_en.inc', 'lang_es.inc', '', '', '', 'Orders', 'Mis<br />Ordenes', '', '', '');
INSERT INTO `#__pshop_module` VALUES (6, 'msgs', 'This module is unprotected an used for displaying system messages to users.  We need to have an area that does not require authorization when things go wrong.', 'none', 'header.ihtml', 'footer.ihtml', 'N', 99, 'eng', 'esl', '', '', '', 'lang_en.inc', '', '', '', '', 'Admin', '', '', '', '');
INSERT INTO `#__pshop_module` VALUES (7, 'shop', 'This is the Washupito store module.  This is the demo store included with the phpShop distribution.', 'none', 's_header.ihtml', 's_footer.ihtml', 'Y', 99, 'eng', 'esl', '', '', '', '', '', '', '', '', 'Shop', 'Visita<br />la Tienda', '', '', '');
INSERT INTO `#__pshop_module` VALUES (8, 'store', '', 'storeadmin,admin', 'header.ihtml', 'footer.ihtml', 'Y', 2, 'eng', 'esl', '', '', '', 'lang_en.inc', 'lang_es.inc', '', '', '', 'Store', 'Mi<br />Tienda', '', '', '');
INSERT INTO `#__pshop_module` VALUES (9, 'account', 'This module allows shoppers to update their account information and view previously placed orders.', 'shopper,storeadmin,admin,demo', 's_header.ihtml', 's_footer.ihtml', 'N', 99, 'eng', 'esl', '', '', '', '', '', '', '', '', 'Account', 'Account', '', '', '');
INSERT INTO `#__pshop_module` VALUES (10, 'checkout', '', 'none', 's_header.ihtml', 's_footer.ihtml', 'N', 99, 'eng', 'esl', '', '', '', '', '', '', '', '', 'Checkout', 'Checkout', '', '', '');
INSERT INTO `#__pshop_module` VALUES (11, 'tax', 'The tax module allows you to set tax rates for states or regions within a country.  The rate is set as a decimal figure.  For example, 2 percent tax would be 0.02.', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'Y', 8, 'eng', 'esl', '', '', '', '', '', '', '', '', 'Taxes', 'Impuestos', '', '', '');
INSERT INTO `#__pshop_module` VALUES (12, 'reportbasic', 'The report basic module allows you to do queries on all orders.', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'Y', 7, 'eng', 'esl', '', '', '', '', '', '', '', '', 'Report Basic', 'Report Basic', '', '', '');
INSERT INTO `#__pshop_module` VALUES (13, 'zone', 'This is the zone-shipping module. Here you can manage your shipping costs according to Zones.', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'N', 9, 'eng', 'esl', '', '', '', '', '', '', '', '', 'Zone Shipping', 'Zone Shipping', '', '', '');
INSERT INTO `#__pshop_module` VALUES ( '12839', 'shipping', '<h4>Shipping</h4><p>Let this module calculate the shipping fees for your customers.<br>Create carriers for shipping areas and weight groups.</p>', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'Y', '20', 'eng', 'ger', '', '', '', '', '', '', '', '', 'Shipping', 'Versand', '', '', '');
INSERT INTO `#__pshop_module` VALUES( '98', 'affiliate', 'administrate the affiliates on your store.', 'storeadmin,admin', 'header.ihtml', 'footer.ihtml', 'N', '99', 'EN', 'ES', '', '', '', 'lang_en.inc', 'lang_es.inc', '', '', '', 'affiliates', '', '', '', '');
INSERT INTO `#__pshop_module` VALUES( '99', 'manufacturer', 'Manage the manufacturers of products in your store.', 'storeadmin,admin', 'header.ihtml', 'footer.ihtml', 'Y', '99', 'EN', 'ES', '', '', '', 'lang_en.inc', 'lang_es.inc', '', '', '', 'manufacturer', '', '', '', '');
INSERT INTO `#__pshop_module` VALUES (12842, 'help', 'Help for phpshop', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'Y', 99, 'eng', '', '', '', '', '', '', '', '', '', 'Help', '', '', '', '');
INSERT INTO `#__pshop_module` VALUES (12843, 'coupon', 'Coupon Management', 'admin,storeadmin', 'header.ihtml', 'footer.ihtml', 'Y', 99, 'eng', '', '', '', '', '', '', '', '', '', 'Coupon', '', '', '', '');

CREATE TABLE `#__pshop_order_item` (
  `order_item_id` int(11) NOT NULL auto_increment,
  `order_id` int(11) default NULL,
  `user_info_id` varchar(32) default NULL default NULL,
  `vendor_id` int(11) default NULL,
  `product_id` int(11) default NULL,
  `order_item_sku` VARCHAR( 64 ) NOT NULL,
  `order_item_name` VARCHAR( 64 ) NOT NULL,
  `product_quantity` int(11) default NULL,
  `product_item_price` decimal(10,2) default NULL,
  `order_item_currency` varchar(16) default NULL,
  `order_status` char(1) default NULL,
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `product_attribute` text default NULL,
  PRIMARY KEY  (`order_item_id`),
  KEY `idx_order_item_order_id` (`order_id`),
  KEY `idx_order_item_user_info_id` (`user_info_id`),
  KEY `idx_order_item_vendor_id` (`vendor_id`)
) TYPE=MyISAM AUTO_INCREMENT=1;

CREATE TABLE `#__pshop_order_payment` (
  `order_id` int(11) NOT NULL default '0',
  `payment_method_id` int(11) default NULL,
  `order_payment_code` VARCHAR( 30 ) NOT NULL,
  `order_payment_number` blob,
  `order_payment_expire` int(11) default NULL,
  `order_payment_name` varchar(255) default NULL,
  `order_payment_log` text,
  `order_payment_trans_id` TEXT NOT NULL,
  KEY `idx_order_payment_order_id` (`order_id`),
  KEY `idx_order_payment_method_id` (`payment_method_id`)
) TYPE=MyISAM;

CREATE TABLE `#__pshop_order_status` (
  `order_status_id` int(11) NOT NULL auto_increment,
  `order_status_code` char(1) NOT NULL default '',
  `order_status_name` varchar(64) default NULL,
  `list_order` int(11) default NULL,
  `vendor_id` int(11) default NULL,
  PRIMARY KEY  (`order_status_id`),
  KEY `idx_order_status_list_order` (`list_order`),
  KEY `idx_order_status_vendor_id` (`vendor_id`)
) TYPE=MyISAM AUTO_INCREMENT=5 ;
INSERT INTO `#__pshop_order_status` VALUES (1, 'P', 'Pending', 1, 1);
INSERT INTO `#__pshop_order_status` VALUES (2, 'C', 'Confirmed', 1, 1);
INSERT INTO `#__pshop_order_status` VALUES (3, 'X', 'Cancelled', 3, 1);
INSERT INTO `#__pshop_order_status` VALUES (4, 'S', 'Shipped', 4, 1);

CREATE TABLE `#__pshop_order_user_info` (
  `order_info_id` int(11) NOT NULL auto_increment,
  `order_id` int(11) NOT NULL,
  `user_id` varchar(32) NOT NULL default '',
  `address_type` char(2) default NULL,
  `address_type_name` varchar(32) default NULL,
  `company` varchar(64) default NULL,
  `title` varchar(32) default NULL,
  `last_name` varchar(32) default NULL,
  `first_name` varchar(32) default NULL,
  `middle_name` varchar(32) default NULL,
  `phone_1` varchar(32) default NULL,
  `phone_2` varchar(32) default NULL,
  `fax` varchar(32) default NULL,
  `address_1` varchar(64) NOT NULL default '',
  `address_2` varchar(64) default NULL,
  `city` varchar(32) NOT NULL default '',
  `state` varchar(32) NOT NULL default '',
  `country` varchar(32) NOT NULL default 'US',
  `zip` varchar(32) NOT NULL default '',
  `user_email` varchar(255) default NULL,
  PRIMARY KEY  (`order_info_id`),
  KEY `idx_order_info_order_id` (`order_id`)
) TYPE=MyISAM;

CREATE TABLE `#__pshop_orders` (
  `order_id` int(11) NOT NULL auto_increment,
  `user_id` varchar(32) NOT NULL default '',
  `vendor_id` int(11) NOT NULL default '0',
  `order_number` varchar(32) default NULL,
  `user_info_id` varchar(32) default NULL,
  `order_total` DECIMAL( 10, 2 ) DEFAULT '0,0' NOT NULL,
  `order_subtotal` decimal(10,2) default NULL,
  `order_tax` decimal(10,2) default NULL,
  `order_shipping` decimal(10,2) default NULL,
  `order_shipping_tax` decimal(10,2) default NULL,
  `coupon_discount` DECIMAL( 10, 2 ) NOT NULL,
  `order_discount` DECIMAL( 10, 2 ) NOT NULL,
  `order_currency` varchar(16) default NULL,
  `order_status` char(1) default NULL,
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `ship_method_id` VARCHAR( 255 ) DEFAULT NULL,
  `customer_note` text NOT NULL,
  `ip_address` VARCHAR(15) NOT NULL,
  PRIMARY KEY  (`order_id`),
  KEY `idx_orders_user_id` (`user_id`),
  KEY `idx_orders_vendor_id` (`vendor_id`),
  KEY `idx_orders_order_number` (`order_number`),
  KEY `idx_orders_user_info_id` (`user_info_id`),
  KEY `idx_orders_ship_method_id` (`ship_method_id`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;


CREATE TABLE `#__pshop_payment_method` (
  `payment_method_id` int(11) NOT NULL auto_increment,
  `vendor_id` int(11) default NULL,
  `payment_method_name` varchar(255) default NULL,
  `payment_class` VARCHAR( 50 ) NOT NULL,
  `shopper_group_id` int(11) default NULL,
  `payment_method_discount` decimal(10,2) default NULL,
  `list_order` int(11) default NULL,
  `payment_method_code` varchar(8) default NULL,
  `enable_processor` char(1) default NULL,
  `is_creditcard` TINYINT( 1 ) NOT NULL,
  `payment_enabled` CHAR( 1 ) DEFAULT 'N' NOT NULL,
  `accepted_creditcards` VARCHAR( 128 ) NOT NULL,
  `payment_extrainfo` TEXT NOT NULL,
  `payment_passkey` BLOB NOT NULL,
  PRIMARY KEY  (`payment_method_id`),
  KEY `idx_payment_method_vendor_id` (`vendor_id`),
  KEY `idx_payment_method_name` (`payment_method_name`),
  KEY `idx_payment_method_list_order` (`list_order`),
  KEY `idx_payment_method_shopper_group_id` (`shopper_group_id`)
) TYPE=MyISAM AUTO_INCREMENT=5 ;
INSERT INTO `#__pshop_payment_method` VALUES (1, 1, 'Purchase Order', '', 5, '0.00', 4, 'PO', 'N', 0, 'Y', '', '', '');
INSERT INTO `#__pshop_payment_method` VALUES (2, 1, 'Cash On Delivery', '', 5, '-2.00', 5, 'COD', 'N', 0, 'Y', '', '', '');
INSERT INTO `#__pshop_payment_method` VALUES (3, 1, 'Credit Card', 'ps_authorize', 5, '0.00', 0, 'AN', 'Y', 0, 'Y', '1,2,6,7,', '', '');
INSERT INTO `#__pshop_payment_method` VALUES (4, 1, 'PayPal', 'ps_paypal', 5, '0.00', 0, 'PP', 'P', 0, 'Y', '', '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">\r\n<input type="image" name="submit" src="http://images.paypal.com/images/x-click-but6.gif" border="0" alt="Make payments with PayPal, it\'s fast, free, and secure!">\r\n<input type="hidden" name="cmd" value="_xclick" />\r\n<input type="hidden" name="business" value="<?php echo PAYPAL_EMAIL ?>" />\r\n<input type="hidden" name="receiver_email" value="<?php echo PAYPAL_EMAIL ?>" />\r\n<input type="hidden" name="item_name" value="Order Nr. <?php $db->p("order_id") ?>" />\r\n<input type="hidden" name="invoice" value="<?php $db->p("order_number") ?>" />\r\n<input type="hidden" name="amount" value="<?php printf("%.2f", $db->f("order_total"))?>" />\r\n<input type="hidden" name="currency_code" value="<?php echo $_SESSION[\'vendor_currency\'] ?>" />\r\n<input type="hidden" name="image_url" value="<?php echo $vendor_image_url ?>" />\r\n<input type="hidden" name="return" value="<?php echo SECUREURL ."index.php?option=com_phpshop&amp;page=checkout.result&amp;order_id=".$db->f("order_id") ?>" />\r\n<input type="hidden" name="notify_url" value="<?php echo SECUREURL ."administrator/components/com_phpshop/notify.php" ?>" />\r\n<input type="hidden" name="cancel_return" value="<?php echo SECUREURL ."index.php" ?>" />\r\n<input type="hidden" name="undefined_quantity" value="0" />\r\n<input type="hidden" name="mrb" value="R-3WH47588B4505740X" />\r\n<input type="hidden" name="no_shipping" value="0" />\r\n<input type="hidden" name="no_note" value="1" />\r\n</form>', '');
INSERT INTO `#__pshop_payment_method` VALUES (5, 1, 'PayMate', 'ps_paymate', 5, '0.00', 0, 'PM', 'P', 0, 'Y', '', '<script language="javascript">\r\nfunction openExpress(){\r\n   var url = \'https://www.paymate.com.au/PayMate/ExpressPayment?mid=<?php echo PAYMATE_USERNAME."&amt=".$db->f("order_total")."&currency=".$_SESSION[\'vendor_currency\']."&ref=".$db->f("order_id")."&pmt_sender_email=".$dbbt->f("email");?>\'\r\n   var newWin = window.open(url, \'wizard\', \'height=580,width=500,scrollbars=1,toolbar=no\');\r\n   self.name = \'parent\';\r\n   newWin.focus();\r\n}\r\n</script>\r\n<div align="center">\r\n<p>\r\n<a href="javascript:openExpress();">\r\n<img src="https://www.paymate.com.au/images/paymate-PE-payment-88x31.gif" border="0" alt="Pay with Paymate Express"></a>\r\n<br />Pay with Paymate Express\r\n</p>\r\n</div>', '');
INSERT INTO `#__pshop_payment_method` VALUES (6, 1, 'WorldPay', 'ps_worldpay', 5, '0.00', 0, 'WP', 'P', 0, 'N', '', '<form action="https://select.worldpay.com/wcc/purchase" method="post">\r\n<input type="hidden" name="instId" value="<?php echo WORLDPAY_INST_ID ?>" />\r\n<input type="hidden" name="cartId" value="<?php echo $db->f("order_id") ?>" />\r\n<input type="hidden" name="amount" value="<?php echo $db->f("order_total") ?>" />\r\n<input type="hidden" name="currency" value="<?php echo $_SESSION[\'vendor_currency\'] ?>" />\r\n<input type="hidden" name="desc" value="" />\r\n<input type="hidden" name="email" value="<?php $dbbt->p("email"); ?>" />\r\n<input type="image" scr="http://www.ecommercetemplates.com/images/worldpay.gif" alt="WorldPay" />\r\n</form>', '');
INSERT INTO `#__pshop_payment_method` VALUES (7, 1, 'Credit Card (2Checkout)', 'ps_twocheckout', 5, '0.00', 0, '2CO', 'P', 0, 'N', '', '<?php
$q  = "SELECT * FROM #__users WHERE user_info_id=\'".$db->f("user_info_id")."\'"; 
$dbbt = new ps_DB;
$dbbt->setQuery($q);
$dbbt->query();
$dbbt->next_record(); 
// Get ship_to information
if( $db->f("user_info_id") != $dbbt->f("user_info_id")) {
  $q2  = "SELECT * FROM #__pshop_user_info WHERE user_info_id=\'".$db->f("user_info_id")."\'"; 
  $dbst = new ps_DB;
  $dbst->setQuery($q2);
  $dbst->query();
  $dbst->next_record();
}
else  {
  $dbst = $dbbt;
}
        
//Authnet vars to send
$formdata = array (
 \'x_login\' => TWOCO_LOGIN,
 \'x_email_merchant\' => ((TWOCO_MERCHANT_EMAIL == \'True\') ? \'TRUE\' : \'FALSE\'),
         
 // Customer Name and Billing Address
 \'x_first_name\' => $dbbt->f("first_name"),
 \'x_last_name\' => $dbbt->f("last_name"),
 \'x_company\' => $dbbt->f("company"),
 \'x_address\' => $dbbt->f("address_1"),
 \'x_city\' => $dbbt->f("city"),
 \'x_state\' => $dbbt->f("state"),
 \'x_zip\' => $dbbt->f("zip"),
 \'x_country\' => $dbbt->f("country"),
 \'x_phone\' => $dbbt->f("phone_1"),
 \'x_fax\' => $dbbt->f("fax"),
 \'x_email\' => $dbbt->f("email"),

 // Customer Shipping Address
 \'x_ship_to_first_name\' => $dbst->f("first_name"),
 \'x_ship_to_last_name\' => $dbst->f("last_name"),
 \'x_ship_to_company\' => $dbst->f("company"),
 \'x_ship_to_address\' => $dbst->f("address_1"),
 \'x_ship_to_city\' => $dbst->f("city"),
 \'x_ship_to_state\' => $dbst->f("state"),
 \'x_ship_to_zip\' => $dbst->f("zip"),
 \'x_ship_to_country\' => $dbst->f("country"),

 \'x_invoice_num\' => $db->f("order_number"),
 \'x_receipt_link_url\' => SECUREURL."2checkout_notify.php"
 );
 
if( TWOCO_TESTMODE == "Y" )
  $formdata[\'demo\'] = "Y";

if( intval(TWOCO_LOGIN) > 199999 ) {
  $version = "2";
  $url = "https://www2.2checkout.com/2co/buyer/purchase";
  $formdata[\'x_amount\'] = $db->f("order_total");
}
else {
  $version = "1";
  $url = "https://www.2checkout.com/cgi-bin/Abuyers/purchase.2c";
  $formdata[\'x_amount\'] = $_SESSION[\'vendor_currency\'] . " " . $db->f("order_total");
}  
 //build the post string
 $poststring = \'\';
 foreach($formdata AS $key => $val){
   $poststring .= "<input type=\'hidden\' name=\'$key\' value=\'$val\' />
";
 }

?>
<form action="<?php echo $url ?>" method="post" target="_blank">
<?php echo $poststring ?>
<p>Click on the Image below to pay...</p>
<input type="image" name="submit" src="https://www.2checkout.com/images/buy_logo.gif" border="0" alt="Make payments with 2Checkout, it\'s fast and secure!" title="Pay your Order with 2Checkout, it\'s fast and secure!" />
</form>', '');
INSERT INTO `#__pshop_payment_method` VALUES (8, 1, 'NoChex', 'ps_nochex', 5, '0.00', 0, 'NOCHEX', 'P', 0, 'N', '', '<form action="https://www.nochex.com/nochex.dll/checkout" method=post target="_blank"> 
                                                <input type="hidden" name="email" value="<?php echo NOCHEX_EMAIL ?>" />
                                                <input type="hidden" name="amount" value="<?php printf("%.2f", $db->f("order_total"))?>" />
                                                <input type="hidden" name="ordernumber" value="<?php $db->p("order_id") ?>" />
                                                <input type="hidden" name="logo" value="<?php echo $vendor_image_url ?>" />
                                                <input type="hidden" name="returnurl" value="<?php echo SECUREURL ."index.php?option=com_phpshop&amp;page=checkout.result&amp;order_id=".$db->f("order_id") ?>" />
                                                <input type="image" name="submit" SRC="http://www.nochex.com/web/images/paymeanimated.gif"> 
                                                </form>', '');
INSERT INTO `#__pshop_payment_method` VALUES (9, 1, 'Credit Card (PayMeNow)', 'ps_paymenow', 5, '0.00', 0, 'PN', 'Y', 0, 'N', '1,2,3,', '', '');
INSERT INTO `#__pshop_payment_method` VALUES (10, 1, 'eWay', 'ps_eway', 5, '0.00', 0, 'EW', 'Y', 0, 'N', '', '', '');
INSERT INTO `#__pshop_payment_method` VALUES (11, 1, 'eCheck.net', 'ps_echeck', 5, '0.00', 0, 'ECK', 'B', 0, 'N', '', '', '');
INSERT INTO `#__pshop_payment_method` VALUES (12, 1, 'Credit Card (eProcessingNetwork)', 'ps_epn', 5, '0.00', 0, 'EPN', 'Y', 0, 'N', '1,2,3,', '', '');
INSERT INTO `#__pshop_payment_method` VALUES (13, 1, 'iKobo', '', 5, '0.00', 0, 'IK', 'P', 0, 'N', '', '<form action="https://www.iKobo.com/store/index.php" method="post"> 
    <input type="hidden" name="cmd" value="cart" />Click on the image below to Pay with iKobo
    <input type="image" src="https://www.ikobo.com/merchant/buttons/ikobo_pay1.gif" name="submit" alt="Pay with iKobo" /> 
    <input type="hidden" name="poid" value="USER_ID" /> 
    <input type="hidden" name="item" value="Order: <?php $db->p("order_id") ?>" /> 
    <input type="hidden" name="price" value="<?php printf("%.2f", $db->f("order_total"))?>" /> 
    <input type="hidden" name="firstname" value="<?php echo $user->first_name?>" /> 
    <input type="hidden" name="lastname" value="<?php echo $user->last_name?>" /> 
    <input type="hidden" name="address" value="<?php echo $user->address_1?>&#10<?php echo $user->address_2?>" /> 
    <input type="hidden" name="city" value="<?php echo $user->city?>" /> 
    <input type="hidden" name="state" value="<?php echo $user->state?>" /> 
    <input type="hidden" name="zip" value="<?php echo $user->zip?>" /> 
    <input type="hidden" name="phone" value="<?php echo $user->phone_1?>" /> 
    <input type="hidden" name="email" value="<?php echo $user->email?>" /> 
    </form> >', '');
INSERT INTO `#__pshop_payment_method` VALUES (14, 1, 'iTransact', '', 5, '0.00', 0, 'ITR', 'P', 0, 'N', '', '<?php
//your iTransact account details
$vendorID = "XXXXX";
global $vendor_name;
$mername = $vendor_name;

//order details
$total = $db->f("order_total");$first_name = $user->first_name;$last_name = $user->last_name;$address = $user->address_1;$city = $user->city;$state = $user->state;$zip = $user->zip;$country = $user->country;$email = $user->email;$phone = $user->phone_1;$home_page = $mosConfig_live_site."/index.php";$ret_addr = $mosConfig_live_site."/index.php";$cc_payment_image = $mosConfig_live_site."/components/com_phpshop/shop_image/ps_image/cc_payment.jpg";
?>
<form action="https://secure.paymentclearing.com/cgi-bin/mas/split.cgi" method="POST"> 
			<input type="hidden" name="vendor_id" value="<?php echo $vendorID; ?>" />
			<input type="hidden" name="home_page" value="<?php echo $home_page; ?>" />
			<input type="hidden" name="ret_addr" value="<?php echo $ret_addr; ?>" />
			<input type="hidden" name="mername" value="<?php echo $mername; ?>" />
			<!--Enter text in the next value that should appear on the bottom of the order form.-->
			<INPUT type="hidden" name="mertext" value="" />
			<!--If you are accepting checks, enter the number 1 in the next value.  Enter the number 0 if you are not accepting checks.-->
			<INPUT type="hidden" name="acceptchecks" value="0" />
			<!--Enter the number 1 in the next value if you want to allow pre-registered customers to pay with a check.  Enter the number 0 if not.-->
			<INPUT type="hidden" name="allowreg" value="0" />
			<!--If you are set up with Check Guarantee, enter the number 1 in the next value.  Enter the number 0 if not.-->
			<INPUT type="hidden" name="checkguar" value="0" />
			<!--Enter the number 1 in the next value if you are accepting credit card payments.  Enter the number zero if not.-->
			<INPUT type="hidden" name="acceptcards" value="1">
			<!--Enter the number 1 in the next value if you want to allow a separate mailing address for credit card orders.  Enter the number 0 if not.-->
			<INPUT type="hidden" name="altaddr" value="0" />
			<!--Enter the number 1 in the next value if you want the customer to enter the CVV number for card orders.  Enter the number 0 if not.-->
			<INPUT type="hidden" name="showcvv" value="1" />
			
			<input type="hidden" name="1-desc" value="Order Total" />
			<input type="hidden" name="1-cost" value="<?php echo $total; ?>" />
			<input type="hidden" name="1-qty" value="1" />
			<input type="hidden" name="total" value="<?php echo $total; ?>" />
			<input type="hidden" name="first_name" value="<?php echo $first_name; ?>" />
			<input type="hidden" name="last_name" value="<?php echo $last_name; ?>" />
			<input type="hidden" name="address" value="<?php echo $address; ?>" />
			<input type="hidden" name="city" value="<?php echo $city; ?>" />
			<input type="hidden" name="state" value="<?php echo $state; ?>" />
			<input type="hidden" name="zip" value="<?php echo $zip; ?>" />
			<input type="hidden" name="country" value="<?php echo $country; ?>" />
			<input type="hidden" name="phone" value="<?php echo $phone; ?>" />
			<input type="hidden" name="email" value="<?php echo $email; ?>" />
			<p><input type="image" alt="Process Secure Credit Card Transaction using iTransact" border="0" height="60" width="210" src="<?php echo $cc_payment_image; ?>" /> </p>
			</form>', '');
            

CREATE TABLE `#__pshop_product` (
  `product_id` int(11) NOT NULL auto_increment,
  `vendor_id` int(11) NOT NULL default '0',
  `product_parent_id` int(11) default '0' NOT NULL,
  `product_sku` varchar(64) NOT NULL default '',
  `product_s_desc` varchar(255) default NULL,
  `product_desc` text,
  `product_thumb_image` varchar(255) default NULL,
  `product_full_image` varchar(255) default NULL,
  `product_publish` char(1) default NULL,
  `product_weight` decimal(10,4) default NULL,
  `product_weight_uom` varchar(32) default 'pounds.',
  `product_length` decimal(10,4) default NULL,
  `product_width` decimal(10,4) default NULL,
  `product_height` decimal(10,4) default NULL,
  `product_lwh_uom` varchar(32) default 'inches',
  `product_url` varchar(255) default NULL,
  `product_in_stock` int(11) default NULL,
  `product_available_date` int(11) default NULL,
  `product_availability` VARCHAR( 56 ) NOT NULL,
  `product_special` char(1) default NULL,
  `product_discount_id` int(11) default NULL,
  `ship_code_id` int(11) default NULL,
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `product_name` varchar(64) default NULL,
  `product_sales` int(11) NOT NULL default 0,
  `attribute` text default NULL,
  `custom_attribute` text default NULL,
  `product_tax_id` TINYINT( 2 ) NOT NULL,
  PRIMARY KEY  (`product_id`),
  KEY `idx_product_vendor_id` (`vendor_id`),
  KEY `idx_product_product_parent_id` (`product_parent_id`),
  KEY `idx_product_sku` (`product_sku`),
  KEY `idx_product_ship_code_id` (`ship_code_id`),
  KEY `idx_product_name` (`product_name`)
) TYPE=MyISAM AUTO_INCREMENT=17;


CREATE TABLE `#__pshop_product_attribute` (
  `product_id` int(11) NOT NULL default '0',
  `attribute_name` char(255) NOT NULL default '',
  `attribute_value` char(255) default NULL,
  KEY `idx_product_attribute_product_id` (`product_id`),
  KEY `idx_product_attribute_name` (`attribute_name`)
) TYPE=MyISAM;


CREATE TABLE `#__pshop_product_attribute_sku` (
  `product_id` int(11) NOT NULL default '0',
  `attribute_name` char(255) NOT NULL default '',
  `attribute_list` int(11) default NULL,
  KEY `idx_product_attribute_sku_product_id` (`product_id`),
  KEY `idx_product_attribute_sku_attribute_name` (`attribute_name`),
  KEY `idx_product_attribute_list` (`attribute_list`)
) TYPE=MyISAM;


CREATE TABLE `#__pshop_product_category_xref` (
  `category_id` varchar(32) default NULL,
  `product_id` int(11) NOT NULL default '0',
  `product_list` int(11) default NULL,
  KEY `idx_product_category_xref_category_id` (`category_id`),
  KEY `idx_product_category_xref_product_id` (`product_id`),
  KEY `idx_product_category_xref_product_list` (`product_list`)
) TYPE=MyISAM;


CREATE TABLE `#__pshop_product_discount` (
      `discount_id` int(11) NOT NULL auto_increment,
      `amount` decimal(3,2) NOT NULL default '0.00',
      `is_percent` tinyint(1) NOT NULL default '0',
      `start_date` int(11) NOT NULL default '0',
      `end_date` int(11) NOT NULL default '0',
	  PRIMARY KEY  (`discount_id`)
    ) TYPE=MyISAM;


CREATE TABLE `#__pshop_product_download` (
  `product_id` int( 11 ) DEFAULT '0' NOT NULL ,
  `user_id` varchar( 255 ) DEFAULT '' NOT NULL ,
  `order_id` varchar( 255 ) DEFAULT '' NOT NULL ,
  `end_date` varchar( 255 ) DEFAULT '' NOT NULL ,
  `download_max` varchar( 255 ) DEFAULT '' NOT NULL ,
  `download_id` varchar( 255 ) DEFAULT '' NOT NULL ,
  `file_name` varchar( 255 ) DEFAULT '' NOT NULL ,
  PRIMARY KEY ( `download_id` ) 
  );

CREATE TABLE `#__pshop_product_files` (
  `file_id` int(19) NOT NULL auto_increment,
  `file_product_id` int(11) NOT NULL default '0',
  `file_name` varchar(128) NOT NULL default '',
  `file_title` varchar(128) NOT NULL default '',
  `file_description` mediumtext NOT NULL,
  `file_extension` varchar(128) NOT NULL default '',
  `file_mimetype` varchar(64) NOT NULL default '',
  `file_url` varchar(254) NOT NULL default '',
  `file_published` tinyint(1) NOT NULL default '0',
  `file_is_image` tinyint(1) NOT NULL default '0',
  `file_image_height` int NOT NULL default '0',
  `file_image_width` int NOT NULL default '0',
  `file_image_thumb_height` int NOT NULL default '50',
  `file_image_thumb_width` int NOT NULL default '0',
  PRIMARY KEY  (`file_id`)
) TYPE=MyISAM;

CREATE TABLE `#__pshop_product_price` (
  `product_price_id` int(11) NOT NULL auto_increment,
  `product_id` int(11) NOT NULL default '0',
  `product_price` decimal(10,2) default NULL,
  `product_currency` char(16) default NULL,
  `product_price_vdate` int(11) default NULL,
  `product_price_edate` int(11) default NULL,
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `shopper_group_id` int(11) default NULL,
  PRIMARY KEY  (`product_price_id`),
  KEY `idx_product_price_product_id` (`product_id`),
  KEY `idx_product_price_shopper_group_id` (`shopper_group_id`)
) TYPE=MyISAM AUTO_INCREMENT=17 ;


CREATE TABLE `#__pshop_product_reviews` (
      `product_id` varchar(255) NOT NULL default '',
      `comment` text NOT NULL,
      `userid` int(11) NOT NULL default '0',
      `time` int(11) NOT NULL default '0',
      `user_rating` tinyint(1) NOT NULL default '0',
      `review_ok` int(11) NOT NULL default '0',
      `review_votes` int(11) NOT NULL default '0'
    ) TYPE=MyISAM;
    

CREATE TABLE `#__pshop_product_votes` (
  `product_id` int(255) NOT NULL default '0',
  `votes` text NOT NULL,
  `allvotes` int(11) NOT NULL default '0',
  `rating` tinyint(1) NOT NULL default '0',
  `lastip` varchar(50) NOT NULL default '0'
) TYPE=MyISAM;


create table `#__pshop_shipping_carrier` (
                `shipping_carrier_id` int(11) not null auto_increment, 
                `shipping_carrier_name` char(80) default '' not null, 
                `shipping_carrier_list_order` int(11) not null default 0, 
                PRIMARY KEY (`shipping_carrier_id`)) ;
INSERT INTO `#__pshop_shipping_carrier` VALUES (1, 'DHL', 0);
INSERT INTO `#__pshop_shipping_carrier` VALUES (2, 'UPS', 1);


CREATE TABLE `#__pshop_shipping_rate` (
            `shipping_rate_id` int(11) not null auto_increment, 
            `shipping_rate_name` varchar(255) default '' not null, 
            `shipping_rate_carrier_id` int(11) default '0' not null, 
            `shipping_rate_country` text default '' not null, 
            `shipping_rate_zip_start` varchar(32) default '' not null, 
            `shipping_rate_zip_end` varchar(32) default '' not null, 
            `shipping_rate_weight_start` decimal(10,3) default '0' not null, 
            `shipping_rate_weight_end` decimal(10,3) default '0' not null, 
            `shipping_rate_value` decimal(10,2) default '0' not null, 
            `shipping_rate_package_fee` decimal(10,2) default '0' not null, 
            `shipping_rate_currency_id` int(11) default '0' not null, 
            `shipping_rate_vat_id` int(11) default '0' not null,
            `shipping_rate_list_order` int(11) default '0' not null, 
            PRIMARY KEY (`shipping_rate_id`));
            
INSERT INTO `#__pshop_shipping_rate` VALUES (1,'Inland &gt; 4kg','1','DEU','00000','99999','0.0','4.0','5.62','2','47','0','1');
INSERT INTO `#__pshop_shipping_rate` VALUES (2,'Inland &gt; 8kg','1','DEU','00000','99999','4.0','8.0','6.39','2','47','0','2');
INSERT INTO `#__pshop_shipping_rate` VALUES (3,'Inland &gt; 12kg','1','DEU','00000','99999','8.0','12.0','7.16','2','47','0','3');
INSERT INTO `#__pshop_shipping_rate` VALUES (4,'Inland &gt; 20kg','1','DEU','00000','99999','12.0','20.0','8.69','2','47','0','4');
INSERT INTO `#__pshop_shipping_rate` VALUES (5,'EU+ &gt;  4kg','1','AND;BEL;DNK;FRO;FIN;FRA;GRC;GRL;GBR;IRL;ITA;LIE;LUX;MCO;NLD;AUT;POL;PRT;SMR;SWE;CHE;SVK;ESP;CZE','00000','99999','0.0','4.0','14,57','2','47','0','5');
INSERT INTO `#__pshop_shipping_rate` VALUES (6,'EU+ &gt;  8kg','1','AND;BEL;DNK;FRO;FIN;FRA;GRC;GRL;GBR;IRL;ITA;LIE;LUX;MCO;NLD;AUT;POL;PRT;SMR;SWE;CHE;SVK;ESP;CZE','00000','99999','4.0','8.0','18,66','2','47','0','6');
INSERT INTO `#__pshop_shipping_rate` VALUES (7,'EU+ &gt; 12kg','1','AND;BEL;DNK;FRO;FIN;FRA;GRC;GRL;GBR;IRL;ITA;LIE;LUX;MCO;NLD;AUT;POL;PRT;SMR;SWE;CHE;SVK;ESP;CZE','00000','99999','8.0','12.0','22,57','2','47','0','7');
INSERT INTO `#__pshop_shipping_rate` VALUES (8,'EU+ &gt; 20kg','1','AND;BEL;DNK;FRO;FIN;FRA;GRC;GRL;GBR;IRL;ITA;LIE;LUX;MCO;NLD;AUT;POL;PRT;SMR;SWE;CHE;SVK;ESP;CZE','00000','99999','12.0','20.0','30,93','2','47','0','8');
INSERT INTO `#__pshop_shipping_rate` VALUES (9,'Europe &gt; 4kg','1','ALB;ARM;AZE;BLR;BIH;BGR;EST;GEO;GIB;ISL;YUG;KAZ;HRV;LVA;LTU;MLT;MKD;MDA;NOR;ROM;RUS;SVN;TUR;UKR;HUN;BLR;CYP','00000','99999','0.0','4.0','23,78','2','47','0','9');
INSERT INTO `#__pshop_shipping_rate` VALUES (10,'Europe &gt;  8kg','1','ALB;ARM;AZE;BLR;BIH;BGR;EST;GEO;GIB;ISL;YUG;KAZ;HRV;LVA;LTU;MLT;MKD;MDA;NOR;ROM;RUS;SVN;TUR;UKR;HUN;BLR;CYP','00000','99999','4.0','8.0','29,91','2','47','0','10');
INSERT INTO `#__pshop_shipping_rate` VALUES (11,'Europe &gt; 12kg','1','ALB;ARM;AZE;BLR;BIH;BGR;EST;GEO;GIB;ISL;YUG;KAZ;HRV;LVA;LTU;MLT;MKD;MDA;NOR;ROM;RUS;SVN;TUR;UKR;HUN;BLR;CYP','00000','99999','8.0','12.0','36,05','2','47','0','11');
INSERT INTO `#__pshop_shipping_rate` VALUES (12,'Europe &gt; 20kg','1','ALB;ARM;AZE;BLR;BIH;BGR;EST;GEO;GIB;ISL;YUG;KAZ;HRV;LVA;LTU;MLT;MKD;MDA;NOR;ROM;RUS;SVN;TUR;UKR;HUN;BLR;CYP','00000','99999','12.0','20.0','48,32','2','47','0','12');
INSERT INTO `#__pshop_shipping_rate` VALUES (13,'World_1 &gt;  4kg','1','EGY;DZA;BHR;IRQ;IRN;ISR;YEM;JOR;CAN;QAT;KWT;LBN;LBY;MAR;OMN;SAU;SYR;TUN;ARE;USA','00000','99999','0.0','4.0','26,84','2','47','0','13');
INSERT INTO `#__pshop_shipping_rate` VALUES (14,'World_1 &gt; 8kg','1','EGY;DZA;BHR;IRQ;IRN;ISR;YEM;JOR;CAN;QAT;KWT;LBN;LBY;MAR;OMN;SAU;SYR;TUN;ARE;USA','00000','99999','4.0','8.0','35,02','2','47','0','14');
INSERT INTO `#__pshop_shipping_rate` VALUES (15,'World_1 &gt;12kg','1','EGY;DZA;BHR;IRQ;IRN;ISR;YEM;JOR;CAN;QAT;KWT;LBN;LBY;MAR;OMN;SAU;SYR;TUN;ARE;USA','00000','99999','8.0','12.0','43,20','2','47','0','15');
INSERT INTO `#__pshop_shipping_rate` VALUES (16,'World_1 &gt;20kg','1','EGY;DZA;BHR;IRQ;IRN;ISR;YEM;JOR;CAN;QAT;KWT;LBN;LBY;MAR;OMN;SAU;SYR;TUN;ARE;USA','00000','99999','12.0','20.0','59,57','2','47','0','16');
INSERT INTO `#__pshop_shipping_rate` VALUES (17,'World_2 &gt; 4kg','1','','00000','99999','0.0','4.0','32,98','2','47','0','17');
INSERT INTO `#__pshop_shipping_rate` VALUES (18,'World_2 &gt; 8kg','1','','00000','99999','4.0','8.0','47,29','2','47','0','18');
INSERT INTO `#__pshop_shipping_rate` VALUES (19,'World_2 &gt; 12kg','1','','00000','99999','8.0','12.0','61,61','2','47','0','19');
INSERT INTO `#__pshop_shipping_rate` VALUES (20,'World_2 &gt; 20kg','1','','00000','99999','12.0','20.0','90,24','2','47','0','20');
INSERT INTO `#__pshop_shipping_rate` VALUES (21,'UPS Express','2','AND;BEL;DNK;FRO;FIN;FRA;GRC;GRL;GBR;IRL;ITA;LIE;LUX;MCO;NLD;AUT;POL;PRT;SMR;SWE;CHE;SVK;ESP;CZE','00000','99999','0.0','20.0','5,24','2','47','0','21');


CREATE TABLE `#__pshop_shopper_group` (
  `shopper_group_id` int(11) NOT NULL auto_increment,
  `vendor_id` int(11) default NULL,
  `shopper_group_name` varchar(32) default NULL,
  `shopper_group_desc` text,
  `shopper_group_discount` DECIMAL( 3,2 ) DEFAULT '0.00' NOT NULL,
  `default`tinyint(1) default '0' NOT NULL,
  PRIMARY KEY  (`shopper_group_id`),
  KEY `idx_shopper_group_vendor_id` (`vendor_id`),
  KEY `idx_shopper_group_name` (`shopper_group_name`)
) TYPE=MyISAM AUTO_INCREMENT=8 ;
INSERT INTO `#__pshop_shopper_group` VALUES (5, 1, '-default-', 'This is the default shopper group.', '0.00', '1');
INSERT INTO `#__pshop_shopper_group` VALUES (6, 1, 'Gold Level', 'Gold Level phpShoppers.', '0.00', '0');
INSERT INTO `#__pshop_shopper_group` VALUES (7, 1, 'Wholesale', 'Shoppers that can buy at wholesale.', '0.00', '0');


CREATE TABLE `#__pshop_shopper_vendor_xref` (
  `user_id` varchar(32) default NULL,
  `vendor_id` int(11) default NULL,
  `shopper_group_id` int(11) default NULL,
  `customer_number` varchar(32) default NULL,
  KEY `idx_shopper_vendor_xref_user_id` (`user_id`),
  KEY `idx_shopper_vendor_xref_vendor_id` (`vendor_id`),
  KEY `idx_shopper_vendor_xref_shopper_group_id` (`shopper_group_id`)
) TYPE=MyISAM;


CREATE TABLE `#__pshop_tax_rate` (
  `tax_rate_id` int(11) NOT NULL auto_increment,
  `vendor_id` int(11) default NULL,
  `tax_state` varchar(64) default NULL,
  `tax_country` varchar(64) default NULL,
  `mdate` int(11) default NULL,
  `tax_rate` decimal(10,4) default NULL,
  PRIMARY KEY  (`tax_rate_id`),
  KEY `idx_tax_rate_vendor_id` (`vendor_id`)
) TYPE=MyISAM AUTO_INCREMENT=3 ;
INSERT INTO `#__pshop_tax_rate` VALUES (2, 1, 'CA', 'USA', 964565926, '0.0650');


CREATE TABLE `#__pshop_user_info` (
  `user_info_id` int(11) NOT NULL auto_increment,
  `user_id` varchar(32) NOT NULL default '',
  `address_type` char(2) default NULL,
  `address_type_name` varchar(32) default NULL,
  `company` varchar(64) default NULL,
  `title` varchar(32) default NULL,
  `last_name` varchar(32) default NULL,
  `first_name` varchar(32) default NULL,
  `middle_name` varchar(32) default NULL,
  `phone_1` varchar(32) default NULL,
  `phone_2` varchar(32) default NULL,
  `fax` varchar(32) default NULL,
  `address_1` varchar(64) NOT NULL default '',
  `address_2` varchar(64) default NULL,
  `city` varchar(32) NOT NULL default '',
  `state` varchar(32) NOT NULL default '',
  `country` varchar(32) NOT NULL default 'US',
  `zip` varchar(32) NOT NULL default '',
  `user_email` varchar(255) default NULL,
  `extra_field_1` varchar(255) default NULL,
  `extra_field_2` varchar(255) default NULL,
  `extra_field_3` varchar(255) default NULL,
  `extra_field_4` char(1) default NULL,
  `extra_field_5` char(1) default NULL,
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `perms` VARCHAR( 40 ) DEFAULT 'shopper' NOT NULL,
  PRIMARY KEY  (`user_info_id`),
  KEY `idx_user_info_user_id` (`user_id`)
) TYPE=MyISAM AUTO_INCREMENT=20;


CREATE TABLE `#__pshop_vendor` (
  `vendor_id` int(11) NOT NULL auto_increment,
  `vendor_name` varchar(64) default NULL,
  `contact_last_name` varchar(32) NOT NULL default '',
  `contact_first_name` varchar(32) NOT NULL default '',
  `contact_middle_name` varchar(32) default NULL,
  `contact_title` varchar(32) default NULL,
  `contact_phone_1` varchar(32) NOT NULL default '',
  `contact_phone_2` varchar(32) default NULL,
  `contact_fax` varchar(32) default NULL,
  `contact_email` varchar(255) default NULL,
  `vendor_phone` varchar(32) default NULL,
  `vendor_address_1` varchar(64) NOT NULL default '',
  `vendor_address_2` varchar(64) default NULL,
  `vendor_city` varchar(32) NOT NULL default '',
  `vendor_state` varchar(32) NOT NULL default '',
  `vendor_country` varchar(32) NOT NULL default 'US',
  `vendor_zip` varchar(32) NOT NULL default '',
  `vendor_store_name` varchar(128) NOT NULL default '',
  `vendor_store_desc` text,
  `vendor_category_id` int(11) default NULL,
  `vendor_thumb_image` varchar(255) default NULL,
  `vendor_full_image` varchar(255) default NULL,
  `vendor_currency` varchar(16) default NULL,
  `cdate` int(11) default NULL,
  `mdate` int(11) default NULL,
  `vendor_image_path` varchar(255) default NULL,
  `vendor_terms_of_service` TEXT NOT NULL,
  `vendor_url` VARCHAR( 255 ) NOT NULL,
  `vendor_min_pov` DECIMAL( 10, 2 ),
  `vendor_freeshipping` DECIMAL( 10, 2 ) NOT NULL,
  `vendor_currency_display_style` VARCHAR( 64 ) NOT NULL,
  PRIMARY KEY  (`vendor_id`),
  KEY `idx_vendor_name` (`vendor_name`),
  KEY `idx_vendor_category_id` (`vendor_category_id`)
) TYPE=MyISAM AUTO_INCREMENT=2 ;

INSERT INTO `#__pshop_vendor` VALUES (1, 'Washupito\'s Tiendita', 'Owner', 'Demo', 'Store', 'Mr.', 
  '555-555-1212', '555-555-1212', '555-555-1212', 'demo_order@phpshop.org', '555-555-1212', '100 Washupito Avenue, N.W.', 
  '', 'Lake Forest', 'CA', 'USA', '92630', 'Washupito\'s Tiendita', '<p>We have the best tools for do-it-yourselfers.  Check us out! </p>\r\n
  <p>We were established in 1969 in a time when getting good tools was expensive, but the quality was good.  Now that only a select few of those authentic 
  tools survive, we have dedicated this store to bringing the experience alive for collectors and master mechanics everywhere.  </p>\r\n\r\n
  <p>You can easily find products selecting the category you would like to browse above.</p>', 0, '', 'c19970d6f2970cb0d1b13bea3af3144a.gif', 'USD', 950302468, 968309845, 'shop_image/', 
  '<h5>You haven\'t configured any terms of service yet. Click <a href=administrator/index2.php?page=store.store_form&option=com_phpshop>here</a> to change this text.</h5>',
  'http://www.mambo-phpshop.net','0.00','0.00','1|$|2|.| |2|1');


CREATE TABLE `#__pshop_vendor_category` (
  `vendor_category_id` int(11) NOT NULL auto_increment,
  `vendor_category_name` varchar(64) default NULL,
  `vendor_category_desc` text,
  PRIMARY KEY  (`vendor_category_id`),
  KEY `idx_vendor_category_category_name` (`vendor_category_name`)
) TYPE=MyISAM AUTO_INCREMENT=7 ;
INSERT INTO `#__pshop_vendor_category` VALUES (6, '-default-', 'Default');


CREATE TABLE #__pshop_waiting_list (
      waiting_list_id int(11) NOT NULL auto_increment,
      product_id int(11) NOT NULL default '0',
      user_id varchar(32) NOT NULL default '',
      notify_email varchar(150) NOT NULL default '',
      notified enum('0','1') default '0',
      notify_date timestamp(14) NOT NULL,
      PRIMARY KEY  (waiting_list_id),
      KEY product_id (product_id),
      KEY notify_email (notify_email)
    ) TYPE=MyISAM;
    

CREATE TABLE `#__pshop_zone_shipping` (
  `zone_id` int(11) NOT NULL auto_increment,
  `zone_name` varchar(255) default NULL,
  `zone_cost` decimal(10,2) default NULL,
  `zone_limit` decimal(10,2) default NULL,
  `zone_description` text NOT NULL,
  PRIMARY KEY  (`zone_id`),
  KEY zone_id (`zone_id`)
) TYPE=MyISAM;
INSERT INTO `#__pshop_zone_shipping` VALUES (1, 'Default', '6.00', '35.00', 'This is the default Shipping Zone. This is the zone information that all countries will use until you assign each individual country to a Zone.');
INSERT INTO `#__pshop_zone_shipping` VALUES (2, 'Zone 1', '1000.00', '10000.00', 'This is a zone example');
INSERT INTO `#__pshop_zone_shipping` VALUES (3, 'Zone 2', '2.00', '22.00', 'This is the second zone. You can use this for notes about this zone');
INSERT INTO `#__pshop_zone_shipping` VALUES (4, 'Zone 3', '11.00', '64.00', 'Another usefull thing might be details about this zone or special instructions.');


CREATE TABLE `#__pshop_affiliate_sale` (
               `order_id` int(11) NOT NULL,
               `visit_id` varchar(32) NOT NULL,
               `affiliate_id` int(11) NOT NULL,
               `rate` int(2) NOT NULL,
               PRIMARY KEY (`order_id`));
               

CREATE TABLE `#__pshop_affiliate` (
       `affiliate_id` int(11) NOT NULL auto_increment,
       `user_id` VARCHAR(32) NOT NULL,
       `active` char(1) DEFAULT 'N' NOT NULL,
       `rate` int(11) NOT NULL,
       PRIMARY KEY (`affiliate_id`));
       

CREATE TABLE `#__pshop_visit` (
             `visit_id` varchar(255) NOT NULL,
             `affiliate_id` int(11) NOT NULL,
             `pages` int(11) NOT NULL,
             `entry_page` varchar(255) NOT NULL,
             `exit_page` varchar(255) NOT NULL,
             `sdate` int(11) NOT NULL,
             `edate` int(11) NOT NULL,
             PRIMARY KEY (`visit_id`));
             

CREATE TABLE `#__pshop_creditcard` (
              `creditcard_id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
              `vendor_id` INT( 11 ) NOT NULL,
              `creditcard_name` VARCHAR( 70 ) NOT NULL ,
              `creditcard_code` VARCHAR( 30 ) NOT NULL ,
              PRIMARY KEY ( `creditcard_id` ));  
INSERT INTO `#__pshop_creditcard` VALUES (1, 1, 'Visa', 'VISA');
INSERT INTO `#__pshop_creditcard` VALUES (2, 1, 'MasterCard', 'MC');
INSERT INTO `#__pshop_creditcard` VALUES (3, 1, 'American Express', 'amex');
INSERT INTO `#__pshop_creditcard` VALUES (4, 1, 'Discover Card', 'discover');
INSERT INTO `#__pshop_creditcard` VALUES (5, 1, 'Diners Club', 'diners');
INSERT INTO `#__pshop_creditcard` VALUES (6, 1, 'JCB', 'jcb');
INSERT INTO `#__pshop_creditcard` VALUES (7, 1, 'Australian Bankcard', 'australian_bc');



#
# Table structure for table `#__sections`
#

CREATE TABLE `#__sections` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(50) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `image` varchar(100) NOT NULL default '',
  `scope` varchar(50) NOT NULL default '',
  `image_position` varchar(10) NOT NULL default '',
  `description` text NOT NULL,
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) unsigned NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `count` int(11) NOT NULL default '0',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `idx_scope` (`scope`)
) TYPE=MyISAM;

#
# Table structure for table `#__session`
#

CREATE TABLE `#__session` (
  `username` varchar(50) default '',
  `time` varchar(14) default '',
  `session_id` varchar(200) NOT NULL default '0',
  `guest` tinyint(4) default '1',
  `userid` int(11) default '0',
  `usertype` varchar(50) default '',
  `gid` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`session_id`),
  KEY `whosonline` (`guest`,`usertype`)
) TYPE=MyISAM;

#
# Table structure for table `#__stats_agents`
#

CREATE TABLE `#__stats_agents` (
  `agent` varchar(255) NOT NULL default '',
  `type` tinyint(1) unsigned NOT NULL default '0',
  `hits` int(11) unsigned NOT NULL default '1'
) TYPE=MyISAM;

#
# Table structure for table `#__templates_menu`
#

CREATE TABLE `#__templates_menu` (
  `template` varchar(50) NOT NULL default '',
  `menuid` int(11) NOT NULL default '0',
  `client_id` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`template`,`menuid`)
) TYPE=MyISAM;

# Dumping data for table `#__templates_menu`

INSERT INTO `#__templates_menu` VALUES ('rhuk_solarflare_ii', '0', '0');
INSERT INTO `#__templates_menu` VALUES ('mambo_admin_blue', '0', '1');

# --------------------------------------------------------

#
# Table structure for table `#__template_positions`
#

CREATE TABLE `#__template_positions` (
  `id` int(11) NOT NULL auto_increment,
  `position` varchar(10) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `#__template_positions`
#

INSERT INTO `#__template_positions` VALUES (0, 'left', '');
INSERT INTO `#__template_positions` VALUES (0, 'right', '');
INSERT INTO `#__template_positions` VALUES (0, 'top', '');
INSERT INTO `#__template_positions` VALUES (0, 'bottom', '');
INSERT INTO `#__template_positions` VALUES (0, 'inset', '');
INSERT INTO `#__template_positions` VALUES (0, 'banner', '');
INSERT INTO `#__template_positions` VALUES (0, 'header', '');
INSERT INTO `#__template_positions` VALUES (0, 'footer', '');
INSERT INTO `#__template_positions` VALUES (0, 'newsflash', '');
INSERT INTO `#__template_positions` VALUES (0, 'legals', '');
INSERT INTO `#__template_positions` VALUES (0, 'pathway', '');
INSERT INTO `#__template_positions` VALUES (0, 'toolbar', '');
INSERT INTO `#__template_positions` VALUES (0, 'cpanel', '');
INSERT INTO `#__template_positions` VALUES (0, 'user1', '');
INSERT INTO `#__template_positions` VALUES (0, 'user2', '');
INSERT INTO `#__template_positions` VALUES (0, 'user3', '');
INSERT INTO `#__template_positions` VALUES (0, 'user4', '');
INSERT INTO `#__template_positions` VALUES (0, 'user5', '');
INSERT INTO `#__template_positions` VALUES (0, 'user6', '');
INSERT INTO `#__template_positions` VALUES (0, 'user7', '');
INSERT INTO `#__template_positions` VALUES (0, 'user8', '');
INSERT INTO `#__template_positions` VALUES (0, 'user9', '');
INSERT INTO `#__template_positions` VALUES (0, 'advert1', '');
INSERT INTO `#__template_positions` VALUES (0, 'advert2', '');
INSERT INTO `#__template_positions` VALUES (0, 'advert3', '');
INSERT INTO `#__template_positions` VALUES (0, 'icon', '');
INSERT INTO `#__template_positions` VALUES (0, 'debug', '');
# --------------------------------------------------------

#
# Table structure for table `#__users`
#

CREATE TABLE `#__users` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `username` varchar(25) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `password` varchar(100) NOT NULL default '',
  `usertype` varchar(25) NOT NULL default '',
  `block` tinyint(4) NOT NULL default '0',
  `sendEmail` tinyint(4) default '0',
  `gid` tinyint(3) unsigned NOT NULL default '1',
  `registerDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `activation` varchar(100) NOT NULL default '',
  `params` text NOT NULL,
  `user_info_id` varchar(32) default NULL,
  `address_type` char(2) default NULL,
  `address_type_name` varchar(32) default NULL,
  `company` varchar(64) default NULL,
  `title` varchar(32) default NULL,
  `last_name` varchar(32) default NULL,
  `first_name` varchar(32) default NULL,
  `middle_name` varchar(32) default NULL,
  `phone_1` varchar(32) default NULL,
  `phone_2` varchar(32) default NULL,
  `fax` varchar(32) default NULL,
  `address_1` varchar(64) NOT NULL default '',
  `address_2` varchar(64) default NULL,
  `city` varchar(32) NOT NULL default '',
  `state` varchar(32) NOT NULL default '',
  `country` varchar(32) NOT NULL default 'US',
  `zip` varchar(32) NOT NULL default '',
  `extra_field_1` varchar(255) default NULL,
  `extra_field_2` varchar(255) default NULL,
  `extra_field_3` varchar(255) default NULL,
  `extra_field_4` char(1) default NULL,
  `extra_field_5` char(1) default NULL,
  `perms` varchar(40) NOT NULL default 'shopper',
  `bank_account_nr` varchar(32) NOT NULL default '',
  `bank_name` varchar(32) NOT NULL default '',
  `bank_sort_code` varchar(16) NOT NULL default '',
  `bank_iban` varchar(64) NOT NULL default '',
  `bank_account_holder` varchar(48) NOT NULL default '',
  `bank_account_type` enum('Checking','Business Checking','Savings') NOT NULL default 'Checking',
  PRIMARY KEY  (`id`),
  KEY `usertype` (`usertype`),
  KEY `idx_name` (`name`)
) TYPE=MyISAM;

#
# Table structure for table `#__usertypes`
#

CREATE TABLE `#__usertypes` (
  `id` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mask` varchar(11) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Dumping data for table `#__usertypes`
#

INSERT INTO `#__usertypes` VALUES (0, 'superadministrator', '');
INSERT INTO `#__usertypes` VALUES (1, 'administrator', '');
INSERT INTO `#__usertypes` VALUES (2, 'editor', '');
INSERT INTO `#__usertypes` VALUES (3, 'user', '');
INSERT INTO `#__usertypes` VALUES (4, 'author', '');
INSERT INTO `#__usertypes` VALUES (5, 'publisher', '');
INSERT INTO `#__usertypes` VALUES (6, 'manager', '');
# --------------------------------------------------------

#
# Table structure for table `#__weblinks`
#

CREATE TABLE `#__weblinks` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `sid` int(11) NOT NULL default '0',
  `title` varchar(250) NOT NULL default '',
  `url` varchar(250) NOT NULL default '',
  `description` varchar(250) NOT NULL default '',
  `date` datetime NOT NULL default '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '0',
  `checked_out` int(11) NOT NULL default '0',
  `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL default '0',
  `archived` tinyint(1) NOT NULL default '0',
  `approved` tinyint(1) NOT NULL default '1',
  `params` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `catid` (`catid`,`published`,`archived`)
) TYPE=MyISAM;

#
# Table structure for table `#__core_acl_aro`
#

CREATE TABLE `#__core_acl_aro` (
  `aro_id` int(11) NOT NULL auto_increment,
  `section_value` varchar(240) NOT NULL default '0',
  `value` varchar(240) NOT NULL default '',
  `order_value` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `hidden` int(11) NOT NULL default '0',
  PRIMARY KEY  (`aro_id`),
  UNIQUE KEY `section_value_value_aro` (`section_value`,`value`),
  UNIQUE KEY `#__gacl_section_value_value_aro` (`section_value`,`value`),
  KEY `hidden_aro` (`hidden`),
  KEY `#__gacl_hidden_aro` (`hidden`)
) TYPE=MyISAM;

#
# Table structure for table `#__core_acl_aro_groups`
#
CREATE TABLE `#__core_acl_aro_groups` (
  `group_id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `lft` int(11) NOT NULL default '0',
  `rgt` int(11) NOT NULL default '0',
  PRIMARY KEY  (`group_id`),
  KEY `parent_id_aro_groups` (`parent_id`),
  KEY `#__gacl_parent_id_aro_groups` (`parent_id`),
  KEY `#__gacl_lft_rgt_aro_groups` (`lft`,`rgt`)
) TYPE=MyISAM;

#
# Dumping data for table `#__core_acl_aro_groups`
#
INSERT INTO `#__core_acl_aro_groups` VALUES (17,0,'ROOT',1,22);
INSERT INTO `#__core_acl_aro_groups` VALUES (28,17,'USERS',2,21);
INSERT INTO `#__core_acl_aro_groups` VALUES (29,28,'Public Frontend',3,12);
INSERT INTO `#__core_acl_aro_groups` VALUES (18,29,'Registered',4,11);
INSERT INTO `#__core_acl_aro_groups` VALUES (19,18,'Author',5,10);
INSERT INTO `#__core_acl_aro_groups` VALUES (20,19,'Editor',6,9);
INSERT INTO `#__core_acl_aro_groups` VALUES (21,20,'Publisher',7,8);
INSERT INTO `#__core_acl_aro_groups` VALUES (30,28,'Public Backend',13,20);
INSERT INTO `#__core_acl_aro_groups` VALUES (23,30,'Manager',14,19);
INSERT INTO `#__core_acl_aro_groups` VALUES (24,23,'Administrator',15,18);
INSERT INTO `#__core_acl_aro_groups` VALUES (25,24,'Super Administrator',16,17);

#
# Table structure for table `#__core_acl_groups_aro_map`
#
CREATE TABLE `#__core_acl_groups_aro_map` (
  `group_id` int(11) NOT NULL default '0',
  `section_value` varchar(240) NOT NULL default '',
  `aro_id` int(11) NOT NULL default '0',
  UNIQUE KEY `group_id_aro_id_groups_aro_map` (`group_id`,`section_value`,`aro_id`)
) TYPE=MyISAM;

#
# Table structure for table `#__core_acl_aro_sections`
#
CREATE TABLE `#__core_acl_aro_sections` (
  `section_id` int(11) NOT NULL auto_increment,
  `value` varchar(230) NOT NULL default '',
  `order_value` int(11) NOT NULL default '0',
  `name` varchar(230) NOT NULL default '',
  `hidden` int(11) NOT NULL default '0',
  PRIMARY KEY  (`section_id`),
  UNIQUE KEY `value_aro_sections` (`value`),
  UNIQUE KEY `#__gacl_value_aro_sections` (`value`),
  KEY `hidden_aro_sections` (`hidden`),
  KEY `#__gacl_hidden_aro_sections` (`hidden`)
) TYPE=MyISAM;

INSERT INTO `#__core_acl_aro_sections` VALUES (10,'users',1,'Users',0);
