(************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad P5.7A                                                      *
 ************************************************************************)

program tp5_7a;

function rkw(a,b,c: real; var x1, x2: real): integer;
var delta: real;
begin
  if a = 0
    then rkw := -2
    else begin
           delta := b*b-4*a*c;
           if delta > 0
             then begin
                    x1 := (-b-sqrt(delta))/(2*a);
                    x2 := (-b+sqrt(delta))/(2*a);
                    rkw := 1;
                  end
             else if delta = 0
               then begin
                      x1 := -b/(2*a);
                      x2 := x1;
                      rkw := 0;
                    end
               else begin
                      { pierwiastki zespolone - liczby sprzone }
                      x1 := -b/(2*a); {cz rzeczywista}
                      x2 := abs(sqrt(-delta)/(2*a)); {cz urojona}
                      rkw := -1;
                    end
         end;
end;

procedure pierwiastki(kod: integer; var x1, x2: real);
begin
  case kod of
    1: begin
         writeln('x = ', x1:0:4);
         writeln('x = ', x2:0:4);
       end;
    0: writeln('x = ', x1:0:4, ' (pierwiastek dwukrotny)');
   -1: begin
         writeln('x = ', x1:0:4, ' - ', x2:0:4, 'i');
         writeln('x = ', x1:0:4, ' + ', x2:0:4, 'i');
       end;
   -2: writeln('a = 0, rwnanie nie jest rwnaniem kwadratowym.');
  end;
end;

var a, b, c, y1, y2, x1, x2, x3, x4: real;

begin
  writeln('Rozwizywanie rwnania dwukwadratowego ax^4+bx^2+c = 0.');
  writeln('Podaj wspczynniki rwnania:');
  {wczytanie danych}
  write('a = ');
  readln(a);
  write('b = ');
  readln(b);
  write('c = ');
  readln(c);
  writeln('Pierwiastki rwnania:');
  { rozwizanie rwnania i wywietlenie wynikw }
  case rkw(a, b, c, y1, y2) of
    1: begin {cztery pierwiastki rzeczywiste, dwa rzeczywiste
              i dwa zespolone lub cztery zespolone (y1 <> y2)}
         pierwiastki(rkw(1, 0, -y1, x1, x2), x1, x2);
         pierwiastki(rkw(1, 0, -y2, x1, x2), x1, x2);
       end;
    0: begin {dwa podwjne pierwiastki (y1 = y2): rzeczywiste,
              rzeczywisty i zespolony lub dwa zespolone}
         if y1 = 0
           then writeln('x = 0 (pierwiastek czterokrotny)')
           else pierwiastki(rkw(1, 0, -y1, x1, x2), x1, x2);
       end;
   -1: begin {tych pierwiastkw chwilowo nie umiemy obliczy}
         writeln('Cztery pierwiastki zespolone...');
       end;
   -2: writeln('Rwnanie nie jest rwnaniem kwadratowym!');
  end;
  readln;
end.
