(************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 8.10b                                                      *
 ************************************************************************)

program p8_10b;

type fraction = record
                  licz: longint;
                  mian: longint;
                end;

procedure setfrac(l, m: longint; var x: fraction);
begin
  x.licz := l;
  x.mian := m;
end; {Turbo Pascal, Free Pascal}

function setfrac(l, m: longint): fraction;
begin
  setfrac.licz := l;
  setfrac.mian := m;
end; {Tylko Free Pascal}

procedure printfrac(x: fraction);
begin
  write(x.licz, ' / ', x.mian);
end;

function frac2str(x: fraction): string;
var s, tmp: string[25];
begin
  str(x.licz, tmp);
  s := tmp + ' / ';
  str(x.mian, tmp);
  frac2str := s+tmp;
end;

procedure inputfrac(var x: fraction);
var znak: char;
begin
  readln(x.licz, znak, znak, x.mian);
  if x.mian < 0
    then begin {korekta znakw licznika i mianownika}
           x.licz := -x.licz;
           x.mian := - x.mian;
         end
    else if x.mian = 0
           then x.mian := 1;
end; {Turbo Pascal, Free Pascal}

function inputfrac(): fraction;
var znak: char;
    licz, mian: longint;
begin
  readln(licz, znak, znak, mian);
  if mian < 0
    then begin {korekta znakw licznika i mianownika}
           licz := -licz;
           mian := -mian;
         end
    else if mian = 0
           then mian := 1;
  inputfrac.licz := licz;
  inputfrac.mian := mian;
end; {Tylko: Free Pascal}

function sum(x, y: fraction): fraction;
begin
  if x.mian = y.mian
    then sum.mian := x.mian
    else begin
           sum.mian := x.mian*y.mian;
           x.licz := x.licz*y.mian;
           y.licz := x.mian*y.licz;
         end;
  sum.licz := x.licz+y.licz;
end;

function difference(x, y: fraction): fraction;
begin
  y.licz := -y.licz; {liczba przeciwna}
  difference := sum(x, y);
end;

function product(x, y: fraction): fraction;
begin
  product.licz := x.licz*y.licz;
  product.mian := x.mian*y.mian;
end;

function quotient(x, y: fraction): fraction;
begin
  quotient.licz := x.licz*y.mian;
  quotient.mian := x.mian*y.licz;
end;

var a, b: fraction;

begin
  writeln('Podstawowe dziaania na uamkach - wersja z funkcjami.');
  writeln;
  a := setfrac(2, 5);
  b := setfrac(1, 3);
  writeln(frac2str(a), ' + ', frac2str(b), ' = ', frac2str(sum(a,b)));
  writeln(frac2str(a), ' - ', frac2str(b), ' = ', frac2str(difference(a,b)));
  writeln(frac2str(a), ' x ', frac2str(b), ' = ', frac2str(product(a,b)));
  writeln(frac2str(a), ' : ', frac2str(b), ' = ', frac2str(quotient(a,b)));
  readln;
end.
