/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 8.10b                                                      *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
/* wersja z funkcjami */

struct fraction {
    int licz;
    int mian;
};

struct fraction setfrac(int l, int m)
{
    struct fraction z;
    z.licz = l;
    z.mian = m;
    return z;
}

void printfrac(struct fraction x)
{
    printf("%d/%d", x.licz, x.mian);
}

char* strfrac(struct fraction x)
{
    static char str[50];
    sprintf(str, "%d/%d", x.licz, x.mian);
    return str;
}

struct fraction inputfrac(void)
{
    struct fraction x;
    char znak;
    scanf("%d%c%d", &x.licz, &znak, &x.mian);
    if (x.mian < 0) {   /* korekta znakw licznika i mianownika */
        x.licz = -x.licz;
        x.mian = -x.mian;
    } else if (x.mian == 0)
        x.mian = 1;
    return x;
}

struct fraction sum(struct fraction x, struct fraction y)
{
    if (x.mian == y.mian)
        return setfrac(x.licz+y.licz, x.mian);
    else
        return setfrac(x.licz*y.mian+x.mian*y.licz, x.mian*y.mian);
}

struct fraction difference(struct fraction x, struct fraction y)
{
    y.licz = -y.licz;
    return sum(x, y);
}

struct fraction product(struct fraction x, struct fraction y)
{
    return setfrac(x.licz*y.licz, x.mian*y.mian);
}

struct fraction quotient(struct fraction x, struct fraction y)
{
    return setfrac(x.licz*y.mian, x.mian*y.licz);
}

int main()
{
    system("chcp 1250");
    struct fraction a, b, c;
    printf("Podstawowe dziaania na uamkach - wersja z funkcjami.\n\n");
    a = setfrac(2, 5);
    b = setfrac(1, 3);
    printf("%s + ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(sum(a, b)));
    printf("%s - ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(difference(a, b)));
    printf("%s x ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(product(a, b)));
    printf("%s : ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(quotient(a, b)));
    system("pause");
    return 0;
}
