(************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad moduu z funkcjami trygonometrycznymi                      *
 ************************************************************************)

unit funtrygo;

interface

  var a, b, c, alfa, beta, gamma: real;
  const PIx2 = 6.283185307179586;    {dwa pi}
  const PI2  = 1.570796326794897;    {pi drugich}
  const PI4  = 0.785398163397448;    {pi czwartych}
  function sin(st: real): real;      { st -  miara kta w stopniach }
  function cos(st: real): real;      { st -  miara kta w stopniach }
  function tg(st: real): real;       { st -  miara kta w stopniach }
  function ctg(st: real): real;      { st -  miara kta w stopniach }
  function tan(rad: real): real;     { rad -  miara kta w radianach }
  function cot(rad: real): real;     { rad -  miara kta w radianach }
  function deg2rad(st: real): real;  {zamiana stopni na radiany}
  function rad2deg(rad: real): real; {zamiana radianw na stopnie}
  procedure printdeg(x: real);       {wywietlanie stopni, minut, sekund}
  procedure inputdeg(var x: real);   {wczytywanie stopni, minut, sekund}
  function arcsin(x: real): real;    {arcus sinus }
  function arccos(x: real): real;    {arcus cosinus }
  function readSide(name: char): real; {wczytanie dugoci boku}
  function isTriangle(x, y, z: real): boolean; {badanie warunku trjkta}

implementation

function sin(st: real): real; { st -  miara kta w stopniach }
begin
  sin := system.sin(st/180*PI)
end;

function cos(st: real): real; { st -  miara kta w stopniach }
begin
  cos := system.cos(st/180*PI)
end;

function tg(st: real): real; { st -  miara kta w stopniach }
begin
  tg := sin(st)/cos(st)
end;

function ctg(st: real): real; { st -  miara kta w stopniach }
begin
  ctg := cos(st)/sin(st)
end;

function tan(rad: real): real; { rad -  miara kta w radianach }
begin
  tan := system.sin(rad)/system.cos(rad)
end;

function cot(rad: real): real; { rad -  miara kta w radianach }
begin
  cot := system.cos(rad)/system.sin(rad)
end;

function deg2rad(st: real): real;  {zamiana stopni na radiany}
begin
  deg2rad := st*PI/180
end;

function rad2deg(rad: real): real; {zamiana radianw na stopnie}
begin
  rad2deg := rad*180/PI
end;

function modf(x: real; var y: integer): real;
{prywatna funkcja moduu}
begin
  y := round(x);
  modf := frac(x);
end;

procedure printdeg(x: real);  {wywietlanie stopni, minut, sekund}
var st, min, sek: integer;
begin
  modf(60*modf(60*modf(x, st), min), sek);
  {korekta sekund i minut...}
  if sek = 60
    then begin
           sek := 0;
           min := min+1
         end;
  if min >= 60
    then begin
           min := min-60;
           st := st+1
         end;
  write(st:0, #248, min:0, #39, sek, #39#39);
end;

procedure inputdeg(var x: real);  {wczytywanie stopni, minut, sekund}
var st, min, sek: integer; error: boolean;
begin
  repeat
    error := false;
    write('Podaj miar kta (stopnie minuty sekundy): ');
    readln(st, min, sek);
    if (st < 0) or (st > 360)
      then begin
             writeln('Niewaciwa liczba stopni!');
             error := true;
           end;
    if (min < 0) or (min > 59)
      then begin
             writeln('Niewaciwa liczba minut!');
             error := true;
           end;
    if (sek < 0) or (sek > 59)
      then begin
             writeln('Niewaciwa liczba sekund!');
             error := true;
           end;
  until not error; {wyjcie, gdy nie byo bdu}
  if (st = 360) and ((min > 0) or (sek > 0))
    then st := 0;
  x := st+min/60+sek/3600; {wynik}
end;

function arcsin(x: real): real; { arcus sinus }
begin
  if x = -1
    then arcsin := -PI2
    else if x = 1
           then arcsin := PI2
           else arcsin := arctan(x/sqrt(1-x*x));
end;

function arccos(x: real): real; {arcus cosinus }
begin
  arccos := PI2-arcsin(x);
end;

function readSide(name: char): real;
var x: real;
begin
  repeat
    write('Podaj dugo boku ', name, ' = ');
    readln(x);
    if x <= 0
      then writeln('Bd! Dugo boku powinna by liczb dodatni!');
  until x > 0;  {wyjcie z ptli dla wartoci dodatniej x}
  readSide := x; {wynik zwracamy przez nazw funkcji}
end;

function isTriangle(x, y, z: real): boolean;
begin
  isTriangle := (x+y > z) and (y+z > x) and (z+x > y);
end;

begin
  writeln('Zestaw funkcji do rozwizywania zada z trygonometrii');
  writeln('Modu: FunTrygo 2011');
end.
