/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 10.10a                                                     *
 ************************************************************************/

#include <iostream>
#include <cmath>
#include <iomanip>
#define PI  3.14159265358979324
#define EPS 1e-15
using namespace std;

double atan_1(double x) /* szereg zbieny dla |x| < 1 */
{
    double a, kwx, suma;
    int n;
    suma = 0;               /* pocztkowa warto sumy */
    a = x;                  /* pierwszy wyraz szeregu */
    kwx = -x*x;             /* liczba przeciwna do kwadratu x */
    n = 1;                  /* licznik kolejnych wyrazw */
    do {
        suma += a;          /* dodanie wyrazu */
        a = a*(2*n-1)/(2*n+1)*kwx;
        n += 1;             /* nastpny wyraz */
    } while (fabs(a) >= EPS);
    return suma;
}

double atan_2(double x) /* szereg zbieny dla x > 1 */
{
    double a, kwx, suma;
    int n;
    suma = PI/2;        /* pocztkowa warto sumy */
    a = -1.0/x;         /* pierwszy wyraz szeregu */
    kwx = -x*x;         /* liczba przeciwna do kwadratu x */
    n = 1;              /* licznik kolejnych wyrazw */
    do {
        suma += a;                  /* dodanie wyrazu */
        a = a*(2*n-1)/(2*n+1)/kwx;  /* nastpny wyraz */
        n += 1;
    } while (fabs(a) >= EPS);
    return suma;
}

double arctg(double x)
{
    if (x < 0)
        return -arctg(-x);
    else if (x > 1)
        return atan_2(x);
    else if (x == 1)
        return PI/4;
    else
        return atan_1(x);
}

int main()
{
    system("chcp 1250");
    double x;
    cout << "Obliczanie wartoci funkcji arcus tangens x.\n";
    cout << "Podanie wartoci x = 0 zakoczy obliczenia.\n";
    cout << setiosflags(ios::fixed) << setprecision(15);
    do {
        cout << "x = ";
        cin >> x;
        cout << "Suma szeregu - funkcja arctg(x) = " << arctg(x) << endl;
        cout << "Funkcja standardowa   arctan(x) = " << atan(x) << endl;
    } while(x != 0);
    system("pause");
    return 0;
}
