/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 9.1                                                        *
 ************************************************************************/

#include <iostream>
#include <cmath>
#include <iomanip>
using namespace std;

struct fraction {
    int licz;
    int mian;
};

void printfrac(struct fraction x)
{
    cout << x.licz << "/" << x.mian;
}

struct fraction setfrac(int l, int m)
{
    struct fraction z;
    z.licz = l;
    z.mian = m;
    return z;
}

struct fraction sqrfrac(struct fraction x)
{
    return setfrac(x.licz*x.licz, x.mian*x.mian);
}

struct fraction frac_x10(struct fraction x)
{
    return setfrac(10*x.licz, 10*x.mian);
}

struct fraction incfrac(struct fraction x)
{
    return setfrac(++x.licz, x.mian);
}

struct fraction decfrac(struct fraction x)
{
    return setfrac(--x.licz, x.mian);
}
int compfrac(struct fraction x, struct fraction y)
{
    int i = x.licz*y.mian;
    int j = x.mian*y.licz;
    if (i < j)
        return -1;
    else if (i > j)
        return 1;
    else
        return -1;
}

int main()
{
    struct fraction a, dwa;
    int i = 1, f;
    dwa = setfrac(2, 1);
    a = setfrac(1, 1);
    cout << setiosflags(ios::fixed) << setprecision(15);
    do {
        f = 0;
        while (compfrac(sqrfrac(a), dwa) == -1) {
            a = incfrac(a);
            f = 1;
        }
        if (f) a = decfrac(a);
        printfrac(a);
        cout << " = " << (double)a.licz/a.mian << endl;
        a = frac_x10(a);
    } while (++i < 11);
    cout << "Wynik standardowej funkcji sqrt(2) = " << sqrt(2) << endl;
    system("pause");
    return 0;
}
