/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 8.10a                                                      *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
/* wersja z procedurami */

struct fraction {
    int licz;
    int mian;
};

void setfrac(int l, int m, struct fraction* x)
{
    x->licz = l;
    x->mian = m;
}

void printfrac(struct fraction x)
{
    printf("%d/%d", x.licz, x.mian);
}

char* strfrac(struct fraction x)
{   /*zamiana uamka na acuch znakw */
    static char str[50];
    sprintf(str, "%d/%d", x.licz, x.mian);
    return str;
}

void inputfrac(struct fraction *x)
{
    int licz, mian; char znak;
    scanf("%d%c%d", &licz, &znak, &mian);
    if (mian < 0) {     /* korekta znakw licznika i mianownika */
        licz = -licz;
        mian = -mian;
    } else if (mian == 0)
        mian = 1;
    x->licz = licz;
    x->mian = mian;
}

void sum(struct fraction x, struct fraction y, struct fraction* z)
{
    if (x.mian == y.mian)
        z->mian = x.mian;
    else {
        z->mian = x.mian*y.mian;
        x.licz = x.licz*y.mian;
        y.licz = x.mian*y.licz;
    }
    z->licz = x.licz+y.licz;
}

void difference(struct fraction x, struct fraction y, struct fraction* z)
{
    y.licz = -y.licz;
    sum(x, y, z);
}

void product(struct fraction x, struct fraction y, struct fraction* z)
{
    z->licz = x.licz*y.licz;
    z->mian = x.mian*y.mian;
}

void quotient(struct fraction x, struct fraction y, struct fraction* z)
{
    z->licz = x.licz*y.mian;
    z->mian = x.mian*y.licz;
}

int main()
{
    system("chcp 1250");
    struct fraction a, b, c;
    printf("Podstawowe dziaania na uamkach - wersja z procedurami.\n\n");
    setfrac(2, 5, &a);
    setfrac(1, 3, &b);
    sum(a, b, &c); /* suma uamkw */
    printf("%s + ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(c));
    difference(a, b, &c); /* rnica uamkw */
    printf("%s - ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(c));
    product(a, b, &c); /* iloczyn uamkw */
    printf("%s x ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(c));
    quotient(a, b, &c); /* iloraz uamkw */
    printf("%s x ", strfrac(a));
    printf("%s = ", strfrac(b));
    printf("%s\n",  strfrac(c));
    system("pause");
    return 0;
}
