/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 5.7a                                                       *
 ************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

int rkw(double a, double b, double c, double* x1, double* x2)
{
    if (a == 0)
        return -2;
    double delta;
    delta = b*b-4*a*c;
    if (delta > 0) {
        *x1 = (-b-sqrt(delta))/(2 * a);
        *x2 = (-b+sqrt(delta))/(2 * a);
        return 1;
    } else if (delta == 0) {
        *x1 = *x2= -b/(2*a);
        return 0;
    } else {
        /* pierwiastki zespolone - liczby sprzone */
        *x1 = -b/(2*a);                 /* cz rzeczywista */
        *x2 = fabs(sqrt(-delta)/(2*a)); /* cz urojona */
        return -1;
    }
}

void pierwiastki(int kod, double x1, double x2)
{
    switch (kod) {
        case 1:
            printf("x = %lf\nx = %lf\n", x1, x2);
            break;
        case 0:
            printf("x = %lf (pierwiastek dwukrotny)\n", x1);
            break;
        case -1:
            printf("x = %lf - %lfi\n", x1, x2);
            printf("x = %lf + %lfi\n", x1, x2);
            break;
        case -2:
            printf("a = 0, rwnanie nie jest rwnaniem kwadratowym.\n");
            break;
    }
}

int main()
{
    system("chcp 1250");
    double a, b, c, x1 ,x2, x3, x4, y1, y2;
    printf("Rozwizywanie rwnania dwukwadratowego ax^4+bx^2+c = 0.\n");
    printf("Podaj wspczynniki rwnania:\n");
    /* wczytanie danych */
    printf("a = ");
    scanf("%lf", &a);
    printf("b = ");
    scanf("%lf", &b);
    printf("c = ");
    scanf("%lf", &c);
    /* rozwizanie rwnania i wywietlenie wynikw */
    printf("Pierwiastki rwnania:\n");
    switch (rkw(a, b, c, &y1, &y2)) {
        case 1: /* dwa podwjne pierwiastki: rzeczywiste, rzeczywisty
                   i zespolony lub dwa zespolone, y1 rne od y2 */
            pierwiastki(rkw(1, 0, -y1, &x1, &x2), x1, x2);
            pierwiastki(rkw(1, 0, -y2, &x1, &x2), x1, x2);
            break;
        case 0: /* cztery pierwiastki rzeczywiste, dwa rzeczywiste i dwa
                   zespolone lub cztery zespolone, y1 rwne y2 */
            if (y1 == 0)
                printf("x = 0 (pierwiastek czterokrotny)\n");
            else
                pierwiastki(rkw(1, 0, -y1, &x1, &x2), x1, x2);
            break;
        case -1: /* tych pierwiastkw chwilowo nie umiemy obliczy */
            printf("Cztery pierwiastki zespolone\n");
            break;
        case -2:
            printf("Rwnanie nie jest rwnaniem kwadratowym!\n");
            break;
    }
    system("pause");
    return 0;
}
