(************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 10.10                                                      *
 ************************************************************************)

program p10_10;

function atan_1(x: real): real;
const eps = 1e-16;
var a, kwx, suma: real;
    n: integer;
begin {szereg zbieny dla |x| < 1}
  suma := 0;
  a := x;        {pierwszy wyraz szeregu}
  kwx := -x*x;   {liczba przeciwna do kwadratu x}
  n := 1;        {licznik kolejnych wyrazw}
  repeat
    suma := suma+a;                 {dodanie wyrazu}
    a := a*(2*n-1)/(2*n+1)*kwx;     {nastpny wyraz}
    n := n+1;
  until abs(a) < eps;
  atan_1 := suma;
end;

function atan_2(x: real): real;
const eps = 1e-16;
var a, kwx, suma:
    real; n: integer;
begin {szereg zbieny dla x > 1}
  suma := PI/2;
  a := -1/x;          {pierwszy wyraz szeregu}
  kwx := -x*x;        {liczba przeciwna do kwadratu x}
  n := 1;             {licznik kolejnych wyrazw}
  repeat
    suma := suma+a;                 {dodanie wyrazu}
    a := a*(2*n-1)/(2*n+1)/kwx;     {nastpny wyraz}
    n := n+1;
  until abs(a) < eps;
  atan_2 := suma;
end;

function atan_3(x: real): real;
const eps = 1e-16;
var a, kwx, suma: real;
    n: integer;
begin {szereg zbieny dla x < -1}
  suma := -PI/2;
  a := -1/x;          {pierwszy wyraz szeregu}
  kwx := -x*x;        {liczba przeciwna do kwadratu x}
  n := 1;             {licznik kolejnych wyrazw}
  repeat
    suma := suma+a;                     {dodanie wyrazu}
    a := a*(2*n-1)/(2*n+1)/kwx;         {nastpny wyraz}
    n := n+1;
  until abs(a) < eps;
  atan_3 := suma;
end;

function arctg(x: real): real;
begin
  if x > 1
    then arctg := atan_2(x)
    else if x = 1
           then arctg := PI/4
           else if x = -1
                  then arctg := -PI/4
                  else if x < -1
                         then arctg := atan_3(x)
                         else arctg := atan_1(x);
end;

var x: real;

begin
  writeln('Obliczanie wartoci funkcji arcus tangens x.');
  writeln('Podanie wartoci x = 0 zakoczy obliczenia.');
  repeat
    write('x = ');
    readln(x);
    writeln('Suma szeregu - funkcja arctg(x) = ', arctg(x):0:15);
    writeln('Funkcja standardowa   arctan(x) = ', arctan(x):0:15);
  until x = 0;
end.
