      #include <stdio.h>
      #include <signal.h>
      #include <ctype.h>
      #include <sys/types.h>
      #include <sys/socket.h>
      #include <netinet/in.h>             /* Dla PF_INET sockets */
      #include <arpa/inet.h>
      #include <netdb.h>

      #define DAYTIME_PORT        13      /* Standardowy nr portu */
      #define DEFAULT_PROTOCOL    0

      unsigned long promptForINETAddress();
      unsigned long nameToAddr ();

      /***********************************************************************/

      main  ()

      {
        int clientFd; /* Deskryptor pliku gniazda klienta */
        int serverLen; /* Długość struktury adresu serwera */
        int result; /* Wynik wywołania call() */
        struct sockaddr_in serverINETAddress;          /* Adres serwera */
        struct sockaddr* serverSockAddrPtr;            /* Wskaźnik do adresu */
        unsigned long inetAddress;                     /* 32-bitowy adres IP */

        /* Ustaw dwie zmienne serwera */
        serverSockAddrPtr = (struct sockaddr*) &serverINETAddress;
        serverLen = sizeof (serverINETAddress);        /* Długość adresu */

        while (1) /* Wykonuj pętlę */
            {
              inetAddress = promptForINETAddress ();   /* Pobierz 32-bitowy IP */
              if (inetAddress == 0) break;             /* Zrobione */
              /* Zacznij od wyzerowania całej struktury adresu */
              memset ((char*)&serverINETAddress,0,sizeof(serverINETAddress));
              serverINETAddress.sin_family = PF_INET;  /* Użyj internetu */
              serverINETAddress.sin_addr.s_addr = inetAddress;     /* IP */
              serverINETAddress.sin_port = htons (DAYTIME_PORT);
              /* Teraz utwórz gniazdo klienta */
              clientFd = socket (PF_INET, SOCK_STREAM, DEFAULT_PROTOCOL);
              do /* Wykonuj pętlę do momentu nawiązania połączenia z serwerem */
                {
                  result = connect (clientFd,serverSockAddrPtr,serverLen);
                  if (result == -1) sleep (1); /* Spróbuj ponownie po sekundzie */
                }
              while (result == -1);

              readTime (clientFd);      /* Odczytaj czas z serwera */
              close (clientFd);         /* Zamknij gniazdo */
            }

        exit (/* KOD_SUKCESU */ 0);
      }

      /****************************************************************/

      unsigned long promptForINETAddress ()

      {
        char hostName [100];            /* Nazwa podana przez użytkownika: symboliczna lub numeryczna */
        unsigned long inetAddress;      /* 32-bitowy format IP */

        /* Wykonuj pętlę do zakończenia programu lub wprowadzenia poprawnej wartości */
        /* Jeżeli wyjście, zwróć 0, w przeciwnym razie zwróć adres IP */
        do
          {
            printf ("Nazwa hosta (k = koniec, s = lokalny): ");
            scanf ("%s", hostName);     /* Pobierz nazwę z klawiatury */
            if (strcmp (hostName, "k") == 0) return (0);      /* Wyjście */
            inetAddress = nameToAddr (hostName);              /* Zamień na IP */
            if (inetAddress == 0) printf ("Nie znaleziono hosta\n");
          }
        while (inetAddress == 0);
        return (inetAddress);
      }
      /****************************************************************/

      unsigned long nameToAddr (name)

      char* name;

      {
        char hostName [100];
        struct hostent* hostStruct;
        struct in_addr* hostNode;

        /* Zamień nazwę na 32-bitowy adres IP */

        /* Jeżeli rozpoczyna się cyfrą, załóż, że to poprawny numeryczny adres IP w */
        /* formacie A.B.C.D, i konwertuj bezpośrednio */
        if (isdigit (name[0])) return (inet_addr (name));

        if (strcmp (name, "s") == 0)      /* Pobierz nazwę hosta z bazy danych */
          {
            gethostname (hostName,100);
            printf ("Nazwa hosta lokalnego to %s\n", hostName);
          }
       else /* Załóż, że to poprawna symboliczna nazwa hosta */
         strcpy (hostName, name);

       /* Teraz uzyskaj z bazy danych informacje o adresie */
       hostStruct = gethostbyname (hostName);
       if (hostStruct == NULL) return (0);      /* Nie znaleziono */
       /* Wydobądź adres IP ze struktury hostent */
       hostNode = (struct in_addr*) hostStruct->h_addr;
       /* Dla zabawy wypisz nazwę, którą można odczytać */
       printf ("Adres internetowy = %s\n", inet_ntoa (*hostNode));
       return (hostNode->s_addr);               /* Zwróć adres IP */
     }

     /****************************************************************/

     readTime (fd)

     int fd;

     {
       char str [200]; /* Bufor wiersza */

       printf ("Na docelowym hoście jest ");
       while (readLine (fd, str))      /* Czytaj wiersze aż do końca wejścia */
       printf ("%s\n", str);           /* Wypisz odebrane wiersze */
     }

     /****************************************************************/

     readLine (fd, str)

     int fd;
     char* str;

     /* Czytaj pojedynczo wiersze zakończone znakiem nowego wiersza */

     {
       int n;

       do /* Czytaj znaki aż do NULL lub końca wejścia */
         {
           n = read (fd, str, 1); /* Czytaj jeden znak */
         }
       while (n > 0 && *str++ != '\n');
       return (n > 0); /* Zwróć fałsz, jeżeli koniec wejścia */
     }
