    #include <fcntl.h> /* Na potrzeby definicji trybów dostępu do pliku */
    #include <stdio.h>
    #include <stdlib.h>


    /* Enumerator */
    enum { FALSE, TRUE };             /* Standardowe wartości FAŁSZ i PRAWDA */
    enum { STDIN, STDOUT, STDERR };   /* Standardowe określniki kanału wejścia-
                                          wyjścia */


   /* Polecenia #define */
   #define BUFFER_SIZE   4096
   #define NAME_SIZE     12
   #define MAX_LINES     100000      /* Maksymalna liczba wierszy w pliku */


   /* Zmienne globalne */
   char *fileName = 0; /* Wskazuje nazwę pliku */
   char tmpName [NAME_SIZE];
   int charOption = FALSE;     /* Gdy zostanie podana opcja -c, wartość ustawiana 
     jest na TRUE (prawda) */
   int standardInput = FALSE;  /* Gdy odczytywane jest stdin, ustawiana na TRUE */
   int lineCount = 0;          /* Całkowita liczba wierszy wejścia */
   int lineStart [MAX_LINES];  /* Przechowuje pozycję początku każdego wiersza */
   int fileOffset = 0;         /* Bieżąca pozycja w pliku wejściowym */
   int fd;                     /* Deskryptor pliku wejściowego */

   /****************************************************************************/

   main (argc, argv)

        int argc;
        char* argv [];

   {
        parseCommandLine (argc, argv);      /* Przetwarza wiersz poleceń */
        pass1 ();  /* Wykonuje pierwszy przebieg poprzez dane z pliku wejściowego */
        pass2 ();  /* Wykonuje drugi przebieg poprzez dane z pliku wejściowego */
        return (/* Działanie zakończone powodzeniem */ 0);      /* Koniec */
   }

   /****************************************************************************/

   parseCommandLine (argc, argv)

        int argc;
        char* argv [];

        /* Przetwarzanie argumentów wiersza poleceń */

   {
        int i;

        for (i= 1; i < argc; i++)
        {
             if(argv[i][0] == '-')
               processOptions (argv[i]);
             else if (fileName == 0)
               fileName= argv[i];
             else
               usageError ();      /* Wystąpił błąd */
        }

        standardInput = (fileName == 0);
   }

   /****************************************************************************/

   processOptions (str)

        char* str;

        /* Przetwarzanie opcji */

   {
        int j;

        for (j= 1; str[j] != 0; j++)
        {
             switch(str[j])      /* Bada opcje przekazane w wierszu poleceń */
             {
               case 'c':
                    charOption = TRUE;
                    break;

               default:
                    usageError ();
                    break;
             }
        }
   }

   /****************************************************************************/

   usageError ()

   {
        fprintf (stderr, "Sposób użycia: wspak -c [plik]\n");
        exit (/* Działanie zakończone niepowodzeniem */ 1);
   }

  /****************************************************************************/

  pass1 ()

       /* Wykonaj pierwsze przeszukiwanie pliku */

  {
       int tmpfd, charsRead, charsWritten;
       char buffer [BUFFER_SIZE];

       if (standardInput) /* Czytaj standardowe wejście */
       {
         fd = STDIN;
         sprintf (tmpName, ".rev.%d", getpid ());      /* Losowa nazwa */
         /* Utwórz tymczasowy plik, w którym przechowywana będzie kopia wejścia */
         tmpfd = open (tmpName, O_CREAT | O_RDWR, 0600);
         if (tmpfd == -1) fatalError ();
       }
       else /* Otwórz do odczytu plik, którego nazwa została podana */
       {
         fd = open (fileName, O_RDONLY);
         if (fd == -1) fatalError ();
       }

       lineStart[0] = 0;      /* Pozycja pierwszego wiersza */

       while (TRUE) /* Czytaj całe wejście */
       {
         /* Wypełnij bufor */
         charsRead = read (fd, buffer, BUFFER_SIZE);
         if (charsRead == 0) break;               /* EOF */
         if (charsRead == -1) fatalError ();      /* Błąd */
         trackLines (buffer, charsRead);          /* Przetwarzaj wiersz */
         /* Jeżeli czytane jest stdin, kopiuj wiersz do pliku tymczasowego */
         if (standardInput)
         {
              charsWritten = write (tmpfd, buffer, charsRead);
              if (charsWritten != charsRead) fatalError ();
         }
       }

       /* Przechowaj pozycję zamykającego wiersza, jeżeli istnieje */
       lineStart[lineCount +1] = fileOffset;

       /* Jeżeli czytane jest standardowe wejście, przygotuj deskryptor do 
             drugiego przebiegu */
       if (standardInput) fd = tmpfd;
  }

  /****************************************************************************/

  trackLines (buffer, charsRead)

       char *buffer;
       int charsRead;

       /* Przechowuje pozycję początku każdego wiersza pliku */

  {
       int i;

       for (i = 0; i < charsRead; i++)
       {
         ++fileOffset;      /* Uaktualnij bieżącą pozycję w pliku */
         if (buffer[i] == '\n') lineStart[++lineCount] = fileOffset;
       }
  }

  /****************************************************************************/

  int pass2 ()
       /* Jeszcze raz przegląda wejście i wyświetla wiersze w odwrotnej 
             kolejności */

  {
       int i;

       for (i = lineCount - 1; i >= 0; i--)
         processLine (i);

       close (fd);                               /* Zamknij plik wejściowy */
       if (standardInput) unlink (tmpName);      /* Usuń plik tymczasowy */
  }

  /****************************************************************************/

  processLine (i)

       int i;

       /* Czyta wiersz i go wyświetla */

  {
       int charsRead;
       char buffer [BUFFER_SIZE];

       lseek (fd, lineStart[i], SEEK_SET);  /* Wyszukaj wiersz i go odczytaj */
       charsRead = read (fd, buffer, lineStart[i+1] - lineStart[i]);
       /* Jeżeli podano opcję -c, odwróć kolejność znaków w wierszu */
       if (charOption) reverseLine (buffer, charsRead);
       write (1, buffer, charsRead);        /* Zapisz do standardowego wyjścia */
  }

  /****************************************************************************/

  reverseLine (buffer, size)

       char* buffer;
       int size;

       /* Odwróć kolejność wszystkich znaków znajdujących się w buforze */

  {
       int start = 0, end = size - 1;
       char tmp;

       if (buffer[end] == '\n') --end;      /* Zostaw poprzedzający znak nowego 
                                                  wiersza */

       /* Zamieniaj pary znaków */
       while (start < end)
       {
         tmp = buffer[start];
         buffer[start] = buffer[end];
         buffer[end] = tmp;
         ++start;               /* Zwiększ wartość indeksu początku */
         --end;                 /* Zmniejsz wartość indeksu końca */
       }
  }

  /****************************************************************************/

  fatalError ()

  {
       perror ("wspak: ");      /* Opisz błąd */
       exit (1);
  }
