#!/bin/ksh
# skrypt śmieci
# Wersja dla powłoki Korn
# Autor: Graham Glass
# 25.09.1991
#
# Inicjalizacja zmiennych
#
licznikPlikow=0         # liczba podanych plików
opcjaList=0             # 1, jeżeli podano opcję (-l)
opcjaUsun=0             # 1, jeżeli podano opcję wyczyść (-p)
sygnPlik=0              # 1, jeżeli podano chociaż jeden plik
smietnik=~/.smieci      # określa nazwę katalogu-śmietnika
#
blad ()
{
#
# Wypisz komunikat o błędzie i zakończ działanie
#
cat << KONIECTEKSTU
Drogi $USER, oto sposób użycia skryptu smieci:
  smieci -p oznacza "usuń wszystkie pliki"
  smieci -l oznacza "pokaż pliki przeniesione do śmietnika"
  smieci <lista plików> aby przenieść je na śmietnik
KONIECTEKSTU
exit 1
}
#
# Przetwarzaj wiersz poleceń
#
for arg in $*
do
 case $arg in
   "-p")
     opcjaUsun=1
     ;;

   "-l")
     opcjaList=1
     ;;
   -*)
    echo $arg nie jest prawidłową opcją
    ;;
   *)
    sygnPlik=1
    listaPlikow[$licznikPlikow]=$arg      # dołącz do listy
    let licznikPlikow=licznikPlikow+1
    ;;
 esac
done
#
# sprawdź, czy nie podano zbyt wielu opcji
#
let wszystkie=$opcjaList+$opcjaUsun+$sygnPlik
if (( wszystkie != 1 ))
then
 blad
fi
#
# utwórz katalog śmieci, jeżeli nie istnieje
#
if [[ ! (-d $smietnik) ]]
then
 'mkdir' $smietnik       # zacytowane na wypadek, gdyby ustawiony był alias
fi
#
# Przetwarzaj opcje
#
if (( opcjaList == 1 ))
then
 'ls' -lF $smietnik      # wypisz zawartość katalogu-śmietnika
 exit 0
fi
#
if (( opcjaUsun == 1 ))
then
 'rm' $smietnik/*                      # usuń pliki z katalogu-śmietnika
 exit 0
fi
#
if (( sygnPlik == 1 ))
then
 'mv' ${listaPlikow[*]} $smietnik      # przenieś pliki do katalogu-śmietnika
 exit 0
fi
#
exit 0
