#!/bin/csh
# skrypt śmieci
# autor: Graham Glass
# 25.09.1991
#
# Inicjalizacja zmiennych
#
set listaPlikow = ()          # lista wszystkich podanych plików
set opcjaList = 0             # ustawiana na 1, jeżeli podano opcję -l
set opcjaUsun = 0             # 1, jeżeli podano opcję -p
set sygnPlik = 0              # 1, jeżeli podano chociaż 1 plik
set smietnik = ~/.smieci      # katalog-śmietnik
#
# Przetwarzaj wiersz poleceń
#
foreach arg ($*)
 switch ($arg)
   case "-p":
     set opcjaUsun = 1
     breaksw

   case "-l":
     set opcjaList = 1
     breaksw

   case -*:
     echo $arg nie jest prawidłową opcją
     goto blad
     breaksw

   default:
     set sygnPlik = 1
     set listaPlikow = ($listaPlikow $arg)  # dołącz do listy
     breaksw
 endsw
end
#
# Sprawdź, czy nie podano za dużo opcji
#
@ total = $opcjaList + $opcjaUsun + $sygnPlik
if ($total != 1) goto blad
#
# Jeżeli katalog-śmietnik nie istnieje, utwórz go
#
if (!(-e $smietnik)) then
 'mkdir' $smietnik
endif
#
# Przetwarzaj opcje
#
if ($opcjaList) then
 'ls' -lgF $smietnik              # wypisz zawartość katalogu-śmietnika
 exit 0
endif
#
if ($opcjaUsun) then
 'rm' $smietnik/*                 # usuń zawartość katalogu-śmietnika
 exit 0
endif
#
if ($sygnPlik) then
 'mv' $listaPlikow $smietnik      # przenieś pliki do katalogu-śmietnika
 exit 0
endif
#
exit 0
#
# Wyświetl komunikat o błędzie i przerwij działanie
#
blad:
cat << KONIECTEKSTU
Drogi $USER, oto sposób użycia skryptu śmieci:
  śmieci -p oznacza "usuń wszystkie pliki"
  śmieci -l oznacza "pokaż pliki przeniesione do śmietnika"
  śmieci <lista plików> aby przenieść je do śmietnika
KONIECTEKSTU
exit 1
