#!/bin/bash
# sprawdza systemy w lokalnej sieci, dopuszczając różne metody wprowadzania danych
#
#
########### Określenie metody wprowadzania danych ###################
#
# sprawdzenie opcji wiersza poleceń za pomocą polecenia getopts
# jeśli nie ma żadnej, następuje przejście do metody z wykorzystaniem pliku
#
while getopts t: opt
do
    case "$opt" in
         t) # znaleziono opcję -t
            if [ $OPTARG = "IPv4" ]
            then
                pingcommand=$(which ping)
            #
            elif [ $OPTARG = "IPv6" ]
            then
                pingcommand=$(which ping6)
            #
            else
                echo "Użycie: -t IPv4 lub -t IPv6"
                echo "Zamykanie skryptu..."
                exit
            fi
            ;;
         *) echo "Użycie: -t IPv4 lub -t IPv6"
            echo "Zamykanie skryptu..."
            exit;;
    esac
    #
    shift $[ $OPTIND - 1 ]
    #
    if [ $# -eq 0 ]
    then
        echo
        echo "Brak parametrów z adresami IP."
        echo
        echo "Zamykanie skryptu..."
        exit
    fi
    #
    for ipaddress in "$@"
    do
        echo
        echo "Sprawdzanie systemu pod adresem $ipaddress..."
        echo
        $pingcommand -q -c 3 $ipaddress
        echo
    done
    exit
done
#
########### Metoda plikowa ###################
#
echo
echo "Wpisz nazwę pliku z bezwzględną ścieżką..."
echo
choice=0
while [ $choice -eq 0 ]
do
    read -t 60 -p "Wpisz nazwę pliku: " filename
    if [ -z $filename ]
    then
        quitanswer=""
        read -t 10 -n 1 -p "Zakończyć skrypt [t/n]? " quitanswer
        #
        case $quitanswer in
        T | t) echo
               echo "Kończenie skryptu..."
               exit;;
        N | n) echo
               echo "Odpowiedz na pytanie: "
               choice=0;;
        *)     echo
               echo "Brak odpowiedzi. Kończenie skryptu..."
               exit;;
        esac
    else
        choice=1
    fi
done
#
if [ -s $filename ] && [ -r $filename ]
    then
        echo "$filename jest plikiem, jest czytelny i nie jest pusty."
        echo
        cat $filename | while read line
        do
            ipaddress=$line
            read line
            iptype=$line
            if [ $iptype = "IPv4" ]
            then
                pingcommand=$(which ping)
            else
                pingcommand=$(which ping6)
            fi
            echo "Sprawdzanie systemu pod adresem $ipaddress..."
            $pingcommand -q -c 3 $ipaddress
            echo
        done
        echo "Zakończono przetwarzanie pliku. Wszystkie systemy sprawdzone."
    else
        echo
        echo "$filename nie jest plikiem albo jest plikiem pustym lub"
        echo "niedostępnym dla Ciebie do odczytu. Zamykanie skryptu..."
fi
#
#################### Koniec skryptu #####################
#
exit