#!/bin/bash
# Menu utworzone za pomocą zenity

temp=$(mktemp -t temp.XXXXXX)
temp2=$(mktemp -t temp2.XXXXXX)

function diskspace {
   df -k > $temp
   zenity --text-info --title "Przestrzeń dyskowa" --filename=$temp --width 750 --height 10
}

function whoseon {
   who > $temp
   zenity --text-info --title "Zalogowani użytkownicy" --filename=$temp --width 500 --height 10
}

function memusage {
   cat /proc/meminfo > $temp
   zenity --text-info --title "Użycie pamięci" --filename=$temp --width 300 --height 500
}

while [ 1 ]
do
zenity --list --radiolist --title "Menu administratora systemu" --column "Wybierz" --column "Pozycja menu" FALSE "Pokaż miejsce na dysku" FALSE "Pokaż użytkowników" FALSE "Pokaż użycie pamięci" FALSE "Zamknij" > $temp2
if [ $? -eq 1 ]
then
   break
fi

selection=$(cat $temp2)
case $selection in
"Pokaż miejsce na dysku")
   diskspace ;;
"Pokaż użytkowników")
   whoseon ;;
"Pokaż użycie pamięci")
   memusage ;;
Exit)
   break ;;
*)
   zenity --info "Zły wybór"
esac
done
