#!/bin/bash
#
#Delete_User - automatyzuje cztery kroki usuwania konta
#
###############################################################
# Definicje funkcji
#
#####################################################
function get_answer {
#
unset answer
ask_count=0
#
while [ -z "$answer" ]    # Ponawia pytanie w przypadku braku odpowiedzi.
do
     ask_count=$[ $ask_count + 1 ]
#
     case $ask_count in   # Jeśli użytkownik nie odpowie w określonym czasie
     2)
          echo
          echo "Odpowiedz na pytanie."
          echo
     ;;
     3)
          echo
          echo "Ostatnia szansa. Odpowiedz na pytanie."
          echo
     ;;
     4)
          echo
          echo "Ponieważ odmawiasz udzielenia odpowiedzi na pytane, "
          echo "program zostaje zamknięty."
          echo
          #
          exit 
     ;;
     esac
#
     if [ -n "$line2" ]
     then               # Drukuje dwa wiersze
          echo $line1
          echo -e $line2" \c"
     else                    # Drukuje jeden wiersz
          echo -e $line1" \c"
     fi
#
#     Daje 60 na udzielenie odpowiedzi
     read -t 60 answer
done
# Czyszczenie zmiennych
unset line1
unset line2
#
}  # Koniec funkcji get_answer
# 
#####################################################
function process_answer {
#
answer=$(echo $answer | cut -c1)
#
case $answer in
y|Y) 
# Jeśli użytkownik odpowie „tak”, nic nie robimy. 
;;
*)                   
# Jeśli użytkownik udzieli jakiejkolwiek innej odpowiedzi niż „tak”, nie zamykamy procesów. 
        echo 
        echo $exit_line1 
        echo $exit_line2
        echo 
        exit
;;
esac
#
# Czyszczenie zmiennych
#
unset exit_line1
unset exit_line2
#
} # Koniec funkcji process_answer
#
##############################################
# Koniec definicji funkcji
#
############# Skrypt główny ####################
# Pobranie nazwy konta użytkownika do sprawdzenia 
#
echo "Krok 1 - Określenie nazwy konta użytkownika do usunięcia"
echo
line1="Wpisz nazwę użytkownika konta, " 
line2="które chcesz usunąć z systemu:"
get_answer
user_account=$answer
#
# Upewnienie się, że użytkownik podał właściwą nazwę konta do usunięcia 
# 
line1="Czy chcesz usunąć konto $user_account " 
line2="z systemu? [t/n]"
get_answer
# 
# Wywołanie funkcji process_answer: 
#     Jeśli użytkownik udzieli jakiejkolwiek innej odpowiedzi niż „tak”, zamknij skrypt
#
exit_line1="Ponieważ nie chcesz usunąć konta $user_account, " 
exit_line1="skrypt zostaje zamknięty."  
process_answer
#
################################################################
# Sprawdzenie, czy konto user_account istnieje w systemie 
# 
user_account_record=$(cat /etc/passwd | grep -w $user_account) 
# 
if [ $? -eq 1 ]          # Jeśli nie ma konta w systemie, zamknij skrypt
then 
     echo 
     echo "Nie znaleziono konta $user_account. " 
     echo "Zamykanie skryptu..." 
     echo 
     exit 
fi 
# 
echo 
echo "Znalazłem ten rekord:" 
echo $user_account_record 
echo 
# 
line1="Czy to jest właściwe konto użytkownika? [t/n]" 
get_answer
# 
# 
# Wywołanie funkcji process_answer: 
#       Jeśli użytkownik udzieli jakiejkolwiek innej odpowiedzi niż „tak”, zamykamy skrypt.
# 
exit_line1="Ponieważ nie chcesz usunąć konta $user_account, "
exit_line2="skrypt zostanie zamknięty." 
process_answer
#
##################################################################
# Wyszukiwanie działających procesów należących do konta użytkownika 
#
echo 
echo "Krok 2 - Wyszukiwanie w systemie procesów należących do konta użytkownika."
echo
# 
ps -u $user_account > /dev/null  # Lista działających procesów użytkownika.

case $? in 
1)     # To konto użytkownika nie ma żadnych uruchomionych procesów.
        #  
     echo "To konto obecnie nie ma żadnych uruchomionych procesów." 
     echo 
;; 
0)   # Uruchomione procesy konta. 
     # Pytanie do użytkownika, czy zamknąć wszystkie procesy. 
     # 
     echo "Konto $user_account ma uruchomione następujące procesy:"
     ps -u $user_account
     #
     line1="Czy chcesz zamknąć te procesy? [t/n]" 
     get_answer 
     # 
     answer=$(echo $answer | cut -c1)
     #
     case $answer in                  
     y|Y)   # Jeśli użytkownik odpowie „tak”, 
            # zamknij procesy konta. 
            # 
            echo
            echo "Zamykanie procesów."
            #
            # Lista działajacych procesów użytkownika w command_1.
            command_1="ps -u $user_account --no-heading"
            #
            # Utworzenie zmiennej command_3 do zamknięcia procesów.
            command_3="xargs -d \\n /usr/bin/sudo /bin/kill -9"
            #
            # Zamknięcie procesów przez połączenie poleceń w potok.
            $command_1 | gawk '{print $1}' | $command_3
            #
            echo
            echo "Procesy zostały zamknięte."
     ;;
     *)     # Jeśli użytkownik udzieli jakiejkolwiek innej odpowiedzi niż „tak”, nie zamykamy procesów.
            echo
            echo "Procesy nie zostaną zamknięte."
     ;;
     esac
;;
esac
#################################################################
# Tworzenie raportu na temat wszystkich plików posiadanych przez użytkownika.
#
echo 
echo "Krok 3 - Znajdowanie plików w systemie należących do konta użytkownika."
echo 
echo "Tworzenie raportu na temat wszystkich plików posiadanych przez $user_account." 
echo 
echo "Zaleca się wykonanie kopii zapasowej tych plików," 
echo "a następnie wykonanie jednej z dwóch poniższych czynności:" 
echo "  1) Usunięcie plików." 
echo "  2) Przeniesienie prawa własności do plików na obecne konto użytkownika." 
echo 
echo "Czekaj. To może chwilę potrwać." 
# 
report_date=$(date +%y%m%d) 
report_file="$user_account"_Files_"$report_date".rpt 
# 
find / -user $user_account > $report_file 2>/dev/null 
# 
echo 
echo "Raport jest gotowy." 
echo "Nazwa raportu:      $report_file" 
echo -n "Lokalizacja raportu: "; pwd
echo
####################################
#  Usuń konto użytkownika
echo 
echo "Krok 4 - Usunięcie konta użytkownika."
echo
# 
line1="Czy chcesz usunąć konto użytkownika $user_account z systemu? [t/n]"
get_answer
# 
# Wywołanie funkcji process_answer: 
#       Jeśli użytkownik udzieli jakiejkolwiek innej odpowiedzi niż „tak”, zamykamy skrypt
# 
exit_line1="Ponieważ nie chcesz usunąć konta "
exit_line2="$user_account, skrypt zostanie zamknięty."
process_answer
#
userdel $user_account          # Usuwanie konta użytkownika.
echo
echo "Konto użytkownika $user_account zostało usunięte."
echo
#
exit
