#!/bin/bash
#
# Daily_Archive - archiwizuje wyznaczone pliki i katalogi
########################################################
#
# Pobiera bieżącą datę
#
today=$(date +%y%m%d)
#
# Ustawia nazwę pliku archiwum
#
backupFile=archive$today.tar.gz
#
# Ustawia plik konfiguracyjny i docelowy
#
config_file=/archive/Files_To_Backup.txt
destination=/archive/$backupFile
#
######### Skrypt główny #########################
#
# Sprawdza, czy plik konfiguracji kopii zapasowej istnieje
#
if [ -f $config_file ]   # Sprawdza, czy plik konfiguracyjny nadal istnieje.
then                # Jeśli tak, kontynuujemy działanie.
     echo
else                # Jeśli nie, zgłaszamy błąd i zamykamy skrypt.
     echo
     echo "Plik $config_file nie istnieje."
     echo "Kopia zapasowa nie została wykonana z powodu braku pliku konfiguracyjnego."
     echo
     exit
fi
#
# Budowa nazw wszystkich plików do archiwizacji
#
file_no=1               # Zaczyna od pierwszego wiersza pliku konfiguracyjnego.
exec 0< $config_file    # Przekierowanie wejścia standardowego do nazwy pliku konfiguracyjnego.
#
read file_name          # Wczytanie pierwszego rekordu.
#
while [ $? -eq 0 ]      # Tworzenie listy plików do archiwizacji.
do
        # Sprawdzenie, czy plik lub katalog istnieje.
     if [ -f $file_name -o -d $file_name ]
     then
          # Jeśli plik istnieje, dodaje jego nazwę do listy.
          file_list="$file_list $file_name"
     else
          # Jeśli plik nie istnieje, wyświetla ostrzeżenie.
          echo
          echo "Plik $file_name nie istnieje."
          echo "Oczywiście nie umieszczę go w tym archiwum."
          echo "Jest wymieniony w wierszu $file_no pliku konfiguracyjnego."
          echo "Kontynuuję budowę listy archiwalnej..."
          echo
     fi
#
     file_no=$[$file_no + 1]  # Zwiększenie numeru wiersza/pliku o jeden.
     read file_name           # Wczytanie następnego rekordu.
done
#
#######################################
#
# Archiwizacja plików i kompresja archiwum
#
echo "Rozpoczynanie archiwizacji..."
echo
#
tar -czf $destination $file_list 2> /dev/null
#
echo "Archiwum ukończone"
echo "Plik archiwum: $destination"
echo
#
exit