#import <Foundation/Foundation.h>
#include <stdio.h>

@interface MyDelegate : NSObject
{

}
-(void)connectionDidFinishLoading:(NSURLConnection *)connection;
-(void)connection:(NSURLConnection *)connection 
    didFailWithError:(NSError *)error;
@end

@implementation MyDelegate

-(void)connectionDidFinishLoading:(NSURLConnection *)connection
{
    NSLog(@"%s nawizano poczenie", __func__);
    [ connection release ];
}

-(void)connection:(NSURLConnection *)connection 
    didFailWithError:(NSError *)error
{
    NSLog(@"%s nieudana prba nawizania poczenia: %@", 
        __func__, 
        [ error localizedDescription ]);
    [ connection release ];
}
@end

int main(void) {
    MyDelegate *myDelegate = [ [ MyDelegate alloc ] init ];

    NSURLRequest *request = [ [ NSURLRequest alloc ] 
        initWithURL: [ NSURL URLWithString: @"https://www.paypal.com" ]
    ];

    NSURLConnection *connection = [ [ NSURLConnection alloc ] 
        initWithRequest: request delegate: myDelegate ];

    if (!connection) {
       NSLog(@"%s nieudana prba nawizania poczenia");
    } 

    CFRunLoopRun();
    return 0;
}

