# Laboratorium r14

## Konfiguracja

Wdróż podsystem monitorowania:

```
kubectl apply -f lab/monitoring/
```

> Otwórz interfejs użytkownika Prometheusa – nie ma żadnych celów

## Przykładowe rozwiązania

Oto informacje podstawowe:

- Prometheus został [skonfigurowany](./monitoring/prometheus-config.yaml) do odszukiwania celów w przestrzni nazw `kiamol-ch14-lab`

- wszystkie eksportery zostały wymienione w [dokumentacji Prometheusa](https://prometheus.io/docs/instrumenting/exporters/)

- [Eksporter Elasticsearch](https://github.com/justwatchcom/elasticsearch_exporter) udostępnia wskaźniki na porcie 9114.

Moje rozwiązanie znajduje się w [elasticsearch.yaml](./solution/elasticsearch.yaml).

Utwórz przestrzeń nazw i wdróż aplikację:

```
kubectl create ns kiamol-ch14-lab

kubectl apply -f lab/elasticsearch.yml -n kiamol-ch14-lab
```

> Gdy wrócisz do Prometheusa, zobaczysz dodane cele wraz z około 300 nowymi wskaźnikami

`elasticsearch_cluster_health_up` to najbardziej podstawowy i powinien zwracać `1` oraz pokazywać informacje o wersji z etykiet:

![Wskaźniki Prometheusa z eksportera Elasticsearch](./docs/prometheus.png)

## Czyszczenie

Usuń przestrzenie nazw i wszystko inne:

```
kubectl delete ns kiamol-ch14-lab

kubectl delete ns kiamol-ch14-lab-monitoring
```