# Laboratorium r10

Uruchom aplikację przy użyciu zwykłych manifestów (z tego folderu `lab`):

```
kubectl apply -f ./todo-list/
```

Pobierz adres URL i otwórz aplikację:

```
kubectl get svc todo-web -o jsonpath='http://{.status.loadBalancer.ingress[0].*}:8080'
```


## Przykładowe rozwiązanie

Mój wykres Helma opiera na szablonach manifesty Kubernetesa dla wszystkich zasobów:

- [templates/todo-web-configMap.yaml](./ch10-lab-solution/templates/todo-web-configMap.yaml)
- [templates/todo-web-deployment.yaml](./ch10-lab-solution/templates/todo-web-deployment.yaml)
- [templates/todo-web-service.yaml](./ch10-lab-solution/templates/todo-web-service.yaml)

[Wartości domyślne](./ch10-lab-solution/values.yaml) określają środowisko testowe i port 8080 usługi.

Sprawdź poprawność wykresu:

```
helm lint ./ch10-lab-solution
```

Zainstaluj konfigurację testową:

```
helm install lab-test ./ch10-lab-solution
```

> Jeśli otworzysz przeglądarkę na porcie 8080, ścieżka /config zwróci 404

Zainstaluj konfigurację programistyczną:

```
helm install -f dev-values.yaml lab-dev ./ch10-lab-solution
```

> Jeśli otworzysz przeglądarkę na porcie 8080, ścieżka /config będzie działać

## Czyszczenie

Odinstaluj wydania Helma:

```
helm uninstall lab-test lab-dev
```

Usuń pozostałe zasoby laboratorium:

```
kubectl delete all -l kiamol=ch10-lab
```