# Laboratorium r20

## Konfiguracja

Wdróż niestandardowy kontroler:

```
kubectl apply -f lab/timecheck-controller/
```

Spróbuj utworzyć niestandardowy zasób:

```
kubectl apply -f lab/timecheck-test.yaml
```

Sprawdź dzienniki kontrolera:

```
kubectl logs -l app=timecheck-controller --tail 100
```

> Ten kontroler nie obsługuje sytuacji, w której CRD nie istnieje, dlatego kontener kończy działanie, a kapsuła będzie nieustannie restartowana

## Przykładowe rozwiązanie

[To CRD](./solution/timecheck-crd.yaml) określa strukturę niestandardowego zasobu timecheck.

```
kubectl apply -f lab/solution/timecheck-crd.yaml
```

Zrestartuj kontroler – do tej pory będzie miał już statys CrashLoopBackOff:

```
kubectl delete pods -l app=timecheck-controller
```

Teraz utwórz niestandardowy zasób:

```
kubectl apply -f lab/timecheck-test.yaml
```

Sprawdź, czy kontroler utworzył Deployment:

```
kubectl logs -l app=timecheck-controller --tail 4
```

Wypisz listę zasobów timecheck:

```
kubectl get tc
```

I sprawdź dzienniki aplikacji timecheck:

```
kubectl logs -l app=timecheck -c logger
```

## Czyszczenie

Usuń CRD:

```
kubectl delete crd timechecks.ch20.kiamol.net
```

Usuń kontroler:

```
kubectl delete -f lab/timecheck-controller/
```