# Laboratorium r21

## Konfiguracja

Wdróż Knative z Contour:

```
kubectl apply -f lab/knative/
```

Wdróż aplokację to-do:

```
kubectl apply -f lab/todo-list/
```

Pobierz URL kontrolera ruchu przychodzącego:

```
kubectl get svc -n contour-external envoy -o jsonpath='http://{.status.loadBalancer.ingress[0].*}:80'
```

> Zmapuj swój plik `hosts`, aby używał IP Contour dla `todo.kiamol.local` oraz `api.todo.kiamol.local`


## Rozwiązanie

Użyłem [niestandardowego zasobu usługi Knative](./solution/todo-api.yaml), który określa obraz kontenera API.

```
kubectl apply -f lab/solution/todo-api.yaml
```

Sprawdź, czy usługa Knative działa:

```
kubectl get ksvc -n todo
```

Wywołaj funkcję:

```
curl --data 'Napisać r22 KIAMOL' http://api.todo.kiamol.local/todos
```

Wypisz dzienniki funkcji – powinieneś zobaczyć, że opublikowane zostało zdarzenie:

```
kubectl -n todo logs -l serving.knative.dev/service=api -c user-container
```

Wypisz dzienniki procedury obsługi zapisu – powinieneś zobaczyć, że zapisany został nowy element:

```
kubectl -n todo logs -l component=save-handler
```

> Aby zobaczyć ten nowy element, otwórz stronę http://todo.kiamol.local