# Laboratorium r15

## Konfiguracja

Wdróż kontroler ruchu przychodzącego:

```
kubectl apply -f lab/ingress-nginx/
```

## Przykładowe rozwiązanie

Bazowe informacje znajdują się w [specyfikacji kontrolera ruchu przychodzącego Nginx](./ingress-nginx/nginx-ingress-controller.yaml)

- został ustawiony do monitorowania do monitorowania jednej przestrzeni nazw za pomocą argumentu:  `--watch-namespace=kiamol-ch15-lab`

- używa niestandardowej nazwy klasy Ingress: `--ingress-class=nginx-lab`          

Wdróż aplikacje we właściwej przestrzeni nazw:

```
kubectl apply -f lab/apod/ -n kiamol-ch15-lab
```

Moja specyfikacja Ingress dla [API](./solution/ingress-api.yaml) oraz [strony internetowej](./solution/ingress-web.yaml) określa klasę Ingress oraz limit przepustowości w adnotacjach:

```
kubectl apply -f lab/solution/ -n kiamol-ch15-lab
```

Dodaj domenę do swojego pliku hosts (w systemach Linux i macOS użyj pliku skryptu .sh):

```
./add-to-hosts.ps1 api.apod.local ingress-lab

./add-to-hosts.ps1 web.apod.local ingress-lab
```

> Otwórz strony http://www.apod.local/ oraz http://api.apod.local/image, a otrzymasz odpowiedzi

> Wielokrotnie odśwież, a otrzymasz błąd 503:

![503 z kontrolera ruchu przycjodzącego ograniczającego przepustowość](./docs/503.png)

## Czyszczenie

Usuń przestrzenie nazw laboratorium:

```
kubectl delete ns -l kiamol=ch15-lab
```