#!/bin/bash
clear

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Krok 1. operacji instalowania OIDC"
echo -e "*******************************************************************************************************************"

echo -e "\n\n*******************************************************************************************************************"
echo -e "Wdrażanie Dashboard 2"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl apply -f https://raw.githubusercontent.com/kubernetes/dashboard/v2.0.0/aio/deploy/recommended.yaml

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Dodawanie repozytorium Helm i jego uaktualnianie"
echo -e "*******************************************************************************************************************"
tput setaf 2
helm repo add tremolo https://nexus.tremolo.io/repository/helm/
helm repo update

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Tworzenie przestrzeni nazw openunison"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl create ns openunison

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Wdrażanie charta operatora"
echo -e "*******************************************************************************************************************"
tput setaf 2
helm install openunison tremolo/openunison-operator --namespace openunison

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Tworzenia klucza tajnego użytkownika - NIE STOSUJ TEGO ROZWIĄZANIA W PRODUKCJI"
echo -e "*******************************************************************************************************************"
tput setaf 2

kubectl create -f - <<EOF
 apiVersion: v1
 type: Opaque
 metadata:
   name: orchestra-secrets-source
   namespace: openunison
 data:
   K8S_DB_SECRET: cGFzc3dvcmQK
   unisonKeystorePassword: cGFzc3dvcmQK
 kind: Secret
EOF

tput setaf 3
echo -e "\n\n*******************************************************************************************************************"
echo -e "Operator został wdrożony.  Przed przejściem do kroku 2. skryptu instalacyjnego należy zarejestrować środowisko SAML2 Test Lab."
echo -e "Po rejestracji należy przeprowadzić edycję wartości pliku values.yaml i podać informacje dotyczące Twojego środowiska SAML2. \n"
echo -e "\nPo zarejestrowaniu i uaktualnieniu wartości w pliku values.yaml file, należy wykonać następny skrypt ./install-oidc-step2.sh."
echo -e "*******************************************************************************************************************\n"
tput setaf 2


