#!/bin/bash
clear

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Instalowanie MetalLB"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl apply -f https://raw.githubusercontent.com/metallb/metallb/v0.9.3/manifests/namespace.yaml
kubectl apply -f https://raw.githubusercontent.com/metallb/metallb/v0.9.3/manifests/metallb.yaml
kubectl create secret generic -n metallb-system memberlist --from-literal=secretkey="$(openssl rand -base64 128)"

tput setaf 5
echo -e "\n*******************************************************************************************************************"
echo -e "Konfigurowanie puli adresów IP MetalLB"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl apply -f metallb-config.yaml

tput setaf 3
echo -e "\n*******************************************************************************************************************"
echo -e "Zakończenie instalowania MetalLB"
echo -e "*******************************************************************************************************************\n"
tput setaf 2

kubectl get pods -n metallb-system

echo -e "\n\n"
