#!/bin/bash
clear

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Instalowanie komponentów kopii zapasowej..."
echo -e "\nPodczas wykonywania skryptu może być konieczne podanie hasła dla polecenia sudo"
echo -e "*******************************************************************************************************************"

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Instalowanie Minio"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl apply -f minio-deployment.yaml

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Dodawanie reguły Ingress dla Minio"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl apply -f minio-ingress.yaml

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Pobieranie pliku wykonywalego Velero"
echo -e "*******************************************************************************************************************"
tput setaf 2
wget  https://github.com/vmware-tanzu/velero/releases/download/v1.4.0/velero-v1.4.0-linux-amd64.tar.gz

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Wyodrębnienie plików"
echo -e "*******************************************************************************************************************"
tput setaf 2
tar xvf velero-v1.4.0-linux-amd64.tar.gz

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Przeniesienie pliku wykonywalego do katalogu /usr/bin"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo mv velero-v1.4.0-linux-amd64/velero /usr/bin

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Instalowanie serwera Velero"
echo -e "*******************************************************************************************************************"
tput setaf 2
velero install \
     --provider aws \
     --plugins velero/velero-plugin-for-aws:v1.1.0 \
     --bucket velero \
     --secret-file ./credentials-velero \
     --use-volume-snapshots=false \
     --backup-location-config region=minio,s3ForcePathStyle="true",s3Url=http://minio.velero.svc:9000

echo -e "\n \n*******************************************************************************************************************"
echo -e "Wdrożono Minio i Velero."
echo -e "*******************************************************************************************************************"
tput setaf 2

hostip=$(hostname  -I | cut -f1 -d' ')

tput setaf 7
echo -e "\n \n*******************************************************************************************************************"
echo -e "Zewnętrzna domena Minio Ingress: minio.$hostip.nip.io"
echo -e "******************************************************************************************************************* \n"


echo -e "\n\n"
