data class Recipe(
    val title: String,
    val mainIngredient: String,
    val isVegetarian: Boolean = false,
    val difficulty: String = "łatwy"
) {
}

class Mushroom(val size: Int, val isMagic: Boolean) {
    constructor(isMagic_param: Boolean) : this(0, isMagic_param) {
        // Kod wykonywany w momencie wywołania konstruktora pomocniczego.
    }
}

fun findRecipes(
    title: String = "",
    ingredient: String = "",
    isVegetarian: Boolean = false,
    difficulty: String = ""
): Array<Recipe> {
    // Kod do odnajdywania przepisów.
    return arrayOf(Recipe(title, ingredient, isVegetarian, difficulty))
}

fun addNumbers(a: Int, b: Int): Int {
    return a + b
}

fun addNumbers(a: Double, b: Double): Double {
    return a + b
}

fun main(args: Array<String>) {
    val r1 = Recipe("Tajskie curry", "Kurczak")
    val r2 = Recipe(title = "Tajskie curry", mainIngredient = "Kurczak")
    val r3 = r1.copy(title = "Kurczak Bhuna")
    println("r1 ma kod mieszający: ${r1.hashCode()}")
    println("r2 ma kod mieszający: ${r2.hashCode()}")
    println("r3 ma kod mieszający: ${r3.hashCode()}")
    println("r1 toString: ${r1.toString()}")
    println("r1 == r2? ${r1 == r2}")
    println("r1 === r2? ${r1 === r2}")
    println("r1 == r3? ${r1 == r3}")
    val (title, mainIngradient, vegetarian, difficulty) = r1
    println("Zmienna title = $title, a vegetarian = $vegetarian.")

    val m1 = Mushroom(6, false)
    println("m1 - właściwość size = ${m1.size} oraz właściwość isMagic = ${m1.isMagic}.")
    val m2 = Mushroom(true)
    println("m2 - właściwość size = ${m2.size} oraz właściwość isMagic = ${m2.isMagic}.")
    println(addNumbers(2, 5))
    println(addNumbers(1.6, 7.3))
}