
typealias DoubleConversion = (Double) -> Double

fun convert(x: Double,
            converter: DoubleConversion) : Double {
    val result = converter(x)
    println("Wartość $x została przekształcona na wartość: $result.")
    return result
}

fun convertFive(converter: (Int) -> Double) : Double {
    val result = converter(5)
    println("Liczba 5 została przekształcona na wartość: $result.")
    return result
}

fun getConversionLambda(str: String): (Double) -> Double {
    if (str == "CelsjuszeNaFahrenheity") {
        return { it * 1.8 + 32 }
    } else if (str == "KgNaFunty") {
        return { it * 2.204623 }
    } else if (str == "FuntyNaTonyUS") {
        return { it / 2000.0 }
    } else {
        return { it }
    }
}

fun combine(lambda1: DoubleConversion,
            lambda2: DoubleConversion): DoubleConversion {
    return { x: Double -> lambda2(lambda1(x)) }
}

fun main(args: Array<String>) {
    // Konwertujemy 2.5 kg na funty.
    println("Konwertujemy 2.5kg na funty: ${getConversionLambda("KgsToPounds")(2.5)}.")

    // Definiujemy dwa wyrażenia lambda do konwersji.
    val kgsToPoundsLambda = getConversionLambda("KgNaFunty")
    val poundsToUSTonsLambda = getConversionLambda("FuntyNaTonyUS")

    // Łączymy dwa wyrażenia lambda w jedno.
    val kgsToUSTonsLambda = combine(kgsToPoundsLambda, poundsToUSTonsLambda)

    // Używamy nowego wyrażenia lambda by skonwertować 17.4 kg na tony ameryskańskie.
    val value = 17.4
    println("$value kg to ${convert(value, kgsToUSTonsLambda)} ton amerykańskich.")
}
