package ch03.ex6_3_LocalFunctionsAndExtensions2

class User(val id: Int, val name: String, val address: String)

fun saveUser(user: User) {
    fun validate(value: String, fieldName: String) {
        if (value.isEmpty()) {
            throw IllegalArgumentException(
                "Nie można zapisać użytkownika ${user.id}: " +
                    "brak $fieldName")
        }
    }

    validate(user.name, "nazwiska")
    validate(user.address, "adresu")

    // Save user to the database
}

fun main(args: Array<String>) {
    saveUser(User(1, "", ""))
}
