# import modułu RELAY i OLED
from OmegaExpansion import oledExp
from OmegaExpansion import relayExp
import subprocess, time

addrRelay = 7    # adres I2C urządzenia od 0 (0x20) do 7 (0x27)
channelRelay = 0 # numer przekaźnika 0 lub 1
acceptedUids = ['04167a32ed4c80'] # zaufane UID identyfikatorów

# inicjacja modułów rozszerzających OLED i RELAY
def initial_setup():
    status_oled = oledExp.driverInit()
    status_relay = relayExp.driverInit(addrRelay)
    check = relayExp.readChannel(addrRelay, channelRelay)
    if check == 1:
        relay_off()
    return

# włącz przekaźnik
def relay_on():
    relayExp.setChannel(addrRelay, channelRelay, 1) # 1 - włączenie
    return

# wyłącz przekaźnik
def relay_off():
    relayExp.setChannel(addrRelay, channelRelay, 0) # 0 - wyłaczenie
    return

# włącz przekaźnik, a następnie po 5 sekundach wyłącz
# wyświetl UID karty (nalepki) NFC na ekranie OLED
def access(uid):
    oledExp.write("UID: " + uid)
    relay_on()
    time.sleep(5)
    relay_off()
    oledExp.clear()
    return

def __main__():
    initial_setup()
    while 1:
        # odczytaj UID karty i wstaw do zmiennej cmd
        cmd = "nfc-list | grep UID | sed -e 's/ //g' -e 's/^.*://'"
        uid = subprocess.check_output(cmd, shell=True)
        uid = uid.decode('utf-8').rstrip('\n')
        # sprawdź czy UID jest zaufany
        for acceptedUid in acceptedUids:
            if(acceptedUid == uid):
                access(uid)

if __name__ == '__main__':
    __main__()