#include <stdio.h>
#include "relay-exp.h"

int main()
{
  int state, status, init;
  int addr = 7;    // adres I2C urządzenia od 0 (0x20) do 7 (0x27)
  int channel = 0; // numer przekaźnika 0 lub 1

  relayDriverInit(addr);

  status = relayCheckInit(addr, &init); // sprawdź status urządzenia
  if (init == 0) {
    printf("Moduł Relay Expansion nie jest zainicjowany.\n");
    exit;
  } 
  
  relaySetChannel(addr, channel, 1); // ustaw status przekaźnika
  status = relayReadChannel(addr, channel, &state); // odczytaj status przekaźnika

  if (status == EXIT_SUCCESS) {
    if (state == 1) {
      printf("Przekaźnik %d jest WŁĄCZONY!\n", channel);
    } else {
      printf("Przekaźnik %d jest WYŁĄCZONY!\n", channel);
    }
  }
  
  return(0);
}