<?php
include(__DIR__.'/Omega/OledExp.php');
include(__DIR__.'/Omega/GPSExp.php');
include(__DIR__.'/Omega/NMEA/NMEA.php');

class MyOLED extends \Omega\OledExp
{
  public function setCursor($x, $y)
  {
    \oledSetCursor($x, $y);
  }
}

class MyGPS extends \Omega\GPSExp
{

  private function convertGPGGA($s)
  {
    $p = strpos($s, '.');
    $s[$p] = $s[$p-1];
    $s[$p-1] = $s[$p-2];
    $s[$p-2] = '.';
    return $s;
  }

  public function writePositionToOLED($oled)
  {
    if (!$this->fileHandler) {
      $this->fileHandler = fopen(self::FILE_DESCRIPTOR, 'r');
    }
    $sentence = fgets($this->fileHandler);
    if (trim($sentence) == '') {
      $sentence = fgets($this->fileHandler);
    }

    switch (substr($sentence, 0, 6))
    {
      case '$GPGGA':
        $gps = NMEA::getFields($sentence);

        # zdekoduj współrzędne GPS
        $latitude = (isset($gps[2]) && $gps[2] != '') ? $this->convertGPGGA($gps[2]) : '-';
        $longitude = (isset($gps[4]) && $gps[4] != '') ? $this->convertGPGGA($gps[4]) : '-';

        # OLED
        $oled->clear();
        $oled->setCursor(1,1);
        $oled->write(sprintf("GPS Expansion DEMO"));
        $oled->setCursor(3,1);
        $oled->write(sprintf("Latitude:  %f\n", $latitude));
        $oled->setCursor(4,1);
        $oled->write(sprintf("Longitude: %f\n", $longitude));

        # konsola
        system('clear');
        $message = sprintf("GPS Expansion DEMO\n");
        $message.= sprintf("Latitude:  %f\n", $latitude);
        $message.= sprintf("Longitude: %f\n", $longitude);
        print($message);

      break;
    }

    return true;
  }
}

$oled = new MyOLED($initialize = true);
if (!$oled->isInitialized())
{
  die("Wystąpił błąd poczas inicjacji modułu OLED Expansion!\n");
}

$gps = new MyGPS();
if (!$gps->checkInit())
{
  die("Wystąpił błąd poczas inicjacji modułu GPS Expansion!\n");
}

print "Szukam ...";

while ($gps->writePositionToOLED($oled))
{
  sleep(1);
}