#!/bin/bash
#Ping i sprawdzanie nazwy DNS dla adresów IP zapisanych w pliku

#Poproś użytkownika o podanie nazwy pliku z adresami IP.
read -p "Wprowadź ścieżkę i nazwę pliku z adresami IP:" FILE_PATH_NAME


function check_host(){
	#jeżeli adres IP nie jest pusty
	if [[ -n $IP_ADDRESS ]]
	then
		ping_cmd=$(nmap -sn $IP_ADDRESS| grep 'Host is up' | cut -d '(' -f 1)
		echo '------------------------------------------------'
		if [[ -z $ping_cmd ]]
		then
			printf "$IP_ADDRESS jest wyłączony\n"
		else
			printf "$IP_ADDRESS jest aktywny\n"
			dns_name
		fi
	fi
}

function dns_name(){
	dns_name=$(host $IP_ADDRESS)
	printf "$dns_name\n"
}

#Odczytywanie w pętli kolejnych adresów IP z pliku
for ip in $(cat $FILE_PATH_NAME)
do
	IP_ADDRESS=$ip
	check_host
done


