package com.shapira.examples.streams.stockstats;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;

/**
 * Ładujemy konfigurację z pliku. Chodzi głównie o informacje o połączeniu, żeby można było przełączać się między klastrami bez rekompilacji.
 * Możesz jednak umieścić tu inny plik konfiguracji klienta, lecz może zostać nadpisany...
 */
public class LoadConfigs {

    // Domyślne dla chmury
    private static final String DEFAULT_CONFIG_File =
            System.getProperty("user.home") + File.separator + ".ccloud" + File.separator + "config";

    static Properties loadConfig() throws IOException {
        return loadConfig(DEFAULT_CONFIG_File);
    }

    static Properties loadConfig(String configFile) throws IOException {
        if (!Files.exists(Paths.get(configFile))) {
            throw new RuntimeException(configFile + " nie istnieje. Potrzebujesz pliku z konfiguracją klienta, " +
                    "utwórz więc taki plik lub uruchom `ccloud init`, jeśli jesteś użytkownikiem Confluent Cloud");
        }
        System.out.println("Ładowanie konfiguracji z pliku:" + configFile);
        final Properties cfg = new Properties();
        try (InputStream inputStream = new FileInputStream(configFile)) {
            cfg.load(inputStream);
        }

        return cfg;
    }
}
