/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;

class LocalJobRunnerMetrics
implements Updater {
    private final MetricsRecord metricsRecord;
    private int numMapTasksLaunched = 0;
    private int numMapTasksCompleted = 0;
    private int numReduceTasksLaunched = 0;
    private int numReduceTasksCompleted = 0;
    private int numWaitingMaps = 0;
    private int numWaitingReduces = 0;

    public LocalJobRunnerMetrics(JobConf conf) {
        String sessionId = conf.getSessionId();
        JvmMetrics.init("JobTracker", sessionId);
        MetricsContext context = MetricsUtil.getContext("mapred");
        this.metricsRecord = MetricsUtil.createRecord(context, "jobtracker");
        this.metricsRecord.setTag("sessionId", sessionId);
        context.registerUpdater(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext unused) {
        LocalJobRunnerMetrics localJobRunnerMetrics = this;
        synchronized (localJobRunnerMetrics) {
            this.metricsRecord.incrMetric("maps_launched", this.numMapTasksLaunched);
            this.metricsRecord.incrMetric("maps_completed", this.numMapTasksCompleted);
            this.metricsRecord.incrMetric("reduces_launched", this.numReduceTasksLaunched);
            this.metricsRecord.incrMetric("reduces_completed", this.numReduceTasksCompleted);
            this.metricsRecord.incrMetric("waiting_maps", this.numWaitingMaps);
            this.metricsRecord.incrMetric("waiting_reduces", this.numWaitingReduces);
            this.numMapTasksLaunched = 0;
            this.numMapTasksCompleted = 0;
            this.numReduceTasksLaunched = 0;
            this.numReduceTasksCompleted = 0;
            this.numWaitingMaps = 0;
            this.numWaitingReduces = 0;
        }
        this.metricsRecord.update();
    }

    public synchronized void launchMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksLaunched;
        this.decWaitingMaps(taskAttemptID.getJobID(), 1);
    }

    public synchronized void completeMap(TaskAttemptID taskAttemptID) {
        ++this.numMapTasksCompleted;
    }

    public synchronized void launchReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksLaunched;
        this.decWaitingReduces(taskAttemptID.getJobID(), 1);
    }

    public synchronized void completeReduce(TaskAttemptID taskAttemptID) {
        ++this.numReduceTasksCompleted;
    }

    private synchronized void decWaitingMaps(JobID id, int task) {
        this.numWaitingMaps -= task;
    }

    private synchronized void decWaitingReduces(JobID id, int task) {
        this.numWaitingReduces -= task;
    }
}

