/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.ClientServiceDelegate;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.YarnRPC;

public class ClientCache {
    private final Configuration conf;
    private final ResourceMgrDelegate rm;
    private static final Log LOG = LogFactory.getLog(ClientCache.class);
    private Map<JobID, ClientServiceDelegate> cache = new HashMap<JobID, ClientServiceDelegate>();
    private MRClientProtocol hsProxy;

    public ClientCache(Configuration conf, ResourceMgrDelegate rm) {
        this.conf = conf;
        this.rm = rm;
    }

    public synchronized ClientServiceDelegate getClient(JobID jobId) {
        ClientServiceDelegate client;
        if (this.hsProxy == null) {
            try {
                this.hsProxy = this.instantiateHistoryProxy();
            }
            catch (IOException e) {
                LOG.warn("Could not connect to History server.", e);
                throw new YarnRuntimeException("Could not connect to History server.", e);
            }
        }
        if ((client = this.cache.get(jobId)) == null) {
            client = new ClientServiceDelegate(this.conf, this.rm, jobId, this.hsProxy);
            this.cache.put(jobId, client);
        }
        return client;
    }

    protected synchronized MRClientProtocol getInitializedHSProxy() throws IOException {
        if (this.hsProxy == null) {
            this.hsProxy = this.instantiateHistoryProxy();
        }
        return this.hsProxy;
    }

    protected MRClientProtocol instantiateHistoryProxy() throws IOException {
        final String serviceAddr = this.conf.get("mapreduce.jobhistory.address");
        if (StringUtils.isEmpty(serviceAddr)) {
            return null;
        }
        LOG.debug("Connecting to HistoryServer at: " + serviceAddr);
        final YarnRPC rpc = YarnRPC.create(this.conf);
        LOG.debug("Connected to HistoryServer at: " + serviceAddr);
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        return currentUser.doAs(new PrivilegedAction<MRClientProtocol>(){

            @Override
            public MRClientProtocol run() {
                return (MRClientProtocol)rpc.getProxy(HSClientProtocol.class, NetUtils.createSocketAddr(serviceAddr), ClientCache.this.conf);
            }
        });
    }

    public void close() throws IOException {
        if (this.rm != null) {
            this.rm.close();
        }
        if (this.hsProxy != null) {
            RPC.stopProxy(this.hsProxy);
            this.hsProxy = null;
        }
        if (this.cache != null && !this.cache.isEmpty()) {
            for (ClientServiceDelegate delegate : this.cache.values()) {
                if (delegate == null) continue;
                delegate.close();
                Object var2_2 = null;
            }
            this.cache.clear();
            this.cache = null;
        }
    }
}

