/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageDelimitedTextWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class OfflineImageViewerPB {
    public static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final String usage = "Usage: bin/hdfs oiv [OPTIONS] -i INPUTFILE -o OUTPUTFILE\nOffline Image Viewer\nView a Hadoop fsimage INPUTFILE using the specified PROCESSOR,\nsaving the results in OUTPUTFILE.\n\nThe oiv utility will attempt to parse correctly formed image files\nand will abort fail with mal-formed image files.\n\nThe tool works offline and does not require a running cluster in\norder to process an image file.\n\nThe following image processors are available:\n  * XML: This processor creates an XML document with all elements of\n    the fsimage enumerated, suitable for further analysis by XML\n    tools.\n  * FileDistribution: This processor analyzes the file size\n    distribution in the image.\n    -maxSize specifies the range [0, maxSize] of file sizes to be\n     analyzed (128GB by default).\n    -step defines the granularity of the distribution. (2MB by default)\n  * Web: Run a viewer to expose read-only WebHDFS API.\n    -addr specifies the address to listen. (localhost:5978 by default)\n  * Delimited (experimental): Generate a text file with all of the elements common\n    to both inodes and inodes-under-construction, separated by a\n    delimiter. The default delimiter is \\t, though this may be\n    changed via the -delimiter argument.\n\nRequired command line arguments:\n-i,--inputFile <arg>   FSImage file to process.\n\nOptional command line arguments:\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten.\n                       (output to stdout by default)\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file. (XML|FileDistribution|Web|Delimited)\n                       (Web by default)\n-delimiter <arg>       Delimiting string to use with Delimited processor.  \n-t,--temp <arg>        Use temporary dir to cache intermediate result to generate\n                       Delimited outputs. If not set, Delimited processor constructs\n                       the namespace in memory before outputting text.\n-h,--help              Display usage information and exit\n";

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt("inputFile");
        options.addOption(OptionBuilder.create("i"));
        options.addOption("o", "outputFile", true, "");
        options.addOption("p", "processor", true, "");
        options.addOption("h", "help", false, "");
        options.addOption("maxSize", true, "");
        options.addOption("step", true, "");
        options.addOption("addr", true, "");
        options.addOption("delimiter", true, "");
        options.addOption("t", "temp", true, "");
        return options;
    }

    public static void main(String[] args) throws Exception {
        int status = OfflineImageViewerPB.run(args);
        System.exit(status);
    }

    /*
     * Unable to fully structure code
     */
    public static int run(String[] args) throws Exception {
        block53: {
            block54: {
                options = OfflineImageViewerPB.buildOptions();
                if (args.length == 0) {
                    OfflineImageViewerPB.printUsage();
                    return 0;
                }
                parser = new PosixParser();
                try {
                    cmd = parser.parse(options, args);
                }
                catch (ParseException e) {
                    System.out.println("Error parsing command-line options: ");
                    OfflineImageViewerPB.printUsage();
                    return -1;
                }
                if (cmd.hasOption("h")) {
                    OfflineImageViewerPB.printUsage();
                    return 0;
                }
                inputFile = cmd.getOptionValue("i");
                processor = cmd.getOptionValue("p", "Web");
                outputFile = cmd.getOptionValue("o", "-");
                delimiter = cmd.getOptionValue("delimiter", "\t");
                tempPath = cmd.getOptionValue("t", "");
                conf = new Configuration();
                out = outputFile.equals("-") != false ? System.out : new PrintStream(outputFile, "UTF-8");
                var11_14 = null;
                var12_15 = processor;
                var13_18 = -1;
                switch (var12_15.hashCode()) {
                    case -1749581248: {
                        if (!var12_15.equals("FileDistribution")) break;
                        var13_18 = 0;
                        break;
                    }
                    case 87031: {
                        if (!var12_15.equals("XML")) break;
                        var13_18 = 1;
                        break;
                    }
                    case 86836: {
                        if (!var12_15.equals("Web")) break;
                        var13_18 = 2;
                        break;
                    }
                    case 1753449945: {
                        if (!var12_15.equals("Delimited")) break;
                        var13_18 = 3;
                    }
                }
                switch (var13_18) {
                    case 0: {
                        maxSize = Long.parseLong(cmd.getOptionValue("maxSize", "0"));
                        step = Integer.parseInt(cmd.getOptionValue("step", "0"));
                        new FileDistributionCalculator(conf, maxSize, step, out).visit(new RandomAccessFile(inputFile, "r"));
                        break;
                    }
                    case 1: {
                        new PBImageXmlWriter(conf, out).visit(new RandomAccessFile(inputFile, "r"));
                        break;
                    }
                    case 2: {
                        addr = cmd.getOptionValue("addr", "localhost:5978");
                        viewer = new WebImageViewer(NetUtils.createSocketAddr(addr));
                        var19_25 = null;
                        viewer.start(inputFile);
                        if (viewer == null) break;
                        if (var19_25 == null) ** GOTO lbl67
                        try {
                            viewer.close();
                        }
                        catch (Throwable x2) {
                            var19_25.addSuppressed(x2);
                        }
                        break;
lbl67:
                        // 1 sources

                        viewer.close();
                        break;
                        catch (Throwable x2) {
                            try {
                                var19_25 = x2;
                                throw x2;
                            }
                            catch (Throwable var21_31) {
                                if (viewer != null) {
                                    if (var19_25 != null) {
                                        try {
                                            viewer.close();
                                        }
                                        catch (Throwable x2) {
                                            var19_25.addSuppressed(x2);
                                        }
                                    } else {
                                        viewer.close();
                                    }
                                }
                                throw var21_31;
                            }
                        }
                    }
                    case 3: {
                        writer = new PBImageDelimitedTextWriter(out, delimiter, tempPath);
                        var19_26 = null;
                        writer.visit(new RandomAccessFile(inputFile, "r"));
                        if (writer == null) break;
                        if (var19_26 == null) ** GOTO lbl97
                        try {
                            writer.close();
                        }
                        catch (Throwable x2) {
                            var19_26.addSuppressed(x2);
                        }
                        break;
lbl97:
                        // 1 sources

                        writer.close();
                        break;
                        catch (Throwable var20_30) {
                            try {
                                var19_26 = var20_30;
                                throw var20_30;
                            }
                            catch (Throwable var23_33) {
                                if (writer != null) {
                                    if (var19_26 != null) {
                                        try {
                                            writer.close();
                                        }
                                        catch (Throwable x2) {
                                            var19_26.addSuppressed(x2);
                                        }
                                    } else {
                                        writer.close();
                                    }
                                }
                                throw var23_33;
                            }
                        }
                    }
                }
                var12_16 = 0;
                if (out == null) break block53;
                if (var11_14 == null) break block54;
                try {
                    out.close();
                }
                catch (Throwable x2) {
                    var11_14.addSuppressed(x2);
                }
                break block53;
            }
            out.close();
        }
        return var12_16;
        catch (Throwable var12_17) {
            try {
                try {
                    var11_14 = var12_17;
                    throw var12_17;
                }
                catch (Throwable var25_35) {
                    if (out != null) {
                        if (var11_14 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable x2) {
                                var11_14.addSuppressed(x2);
                            }
                        } else {
                            out.close();
                        }
                    }
                    throw var25_35;
                }
            }
            catch (EOFException e) {
                System.err.println("Input file ended unexpectedly. Exiting");
            }
            catch (IOException e) {
                System.err.println("Encountered exception.  Exiting: " + e.getMessage());
            }
        }
        return -1;
    }

    private static void printUsage() {
        System.out.println(usage);
    }
}

