/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsDataInputStream
extends FSDataInputStream {
    public HdfsDataInputStream(DFSInputStream in) throws IOException {
        super(in);
    }

    public HdfsDataInputStream(CryptoInputStream in) throws IOException {
        super(in);
        Preconditions.checkArgument(in.getWrappedStream() instanceof DFSInputStream, "CryptoInputStream should wrap a DFSInputStream");
    }

    private DFSInputStream getDFSInputStream() {
        if (this.in instanceof CryptoInputStream) {
            return (DFSInputStream)((CryptoInputStream)this.in).getWrappedStream();
        }
        return (DFSInputStream)this.in;
    }

    @Override
    public InputStream getWrappedStream() {
        return this.in;
    }

    public DatanodeInfo getCurrentDatanode() {
        return this.getDFSInputStream().getCurrentDatanode();
    }

    public ExtendedBlock getCurrentBlock() {
        return this.getDFSInputStream().getCurrentBlock();
    }

    public List<LocatedBlock> getAllBlocks() throws IOException {
        return this.getDFSInputStream().getAllBlocks();
    }

    public long getVisibleLength() throws IOException {
        return this.getDFSInputStream().getFileLength();
    }

    public DFSInputStream.ReadStatistics getReadStatistics() {
        return this.getDFSInputStream().getReadStatistics();
    }

    public void clearReadStatistics() {
        this.getDFSInputStream().clearReadStatistics();
    }
}

