/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import junit.framework.*;
import java.io.*;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TestLargestDataFile extends TestCase {

  public TestLargestDataFile(String name) {
    super(name);
  }

  /* Wykonuje testy zapisane w pliku testdata.txt (nie testuje
   * przypadku wyjtku). Wyrzuca wyjtek w przypadku
   * gdy ktra operacja wejcia i wyjcia zakoczy si bdem.
   */

  public void testFromFile() throws Exception {

    String line;
    BufferedReader rdr = new BufferedReader(
                                    new FileReader(
                                    "testdata.txt"));
    
    while ((line = rdr.readLine()) != null) {

      if (line.startsWith("#")) { // Ignoruje komentarz
        continue;
      }

      StringTokenizer st = new StringTokenizer(line);
      if (!st.hasMoreTokens()) {
        continue; // Pusty wiersz
      }

      // Pobiera spodziewany wynik
      String val = st.nextToken();
      int expected = Integer.valueOf(val).intValue();

      // Oraz argumenty dla testowanej metody
      ArrayList argument_list = new ArrayList();
      
      while (st.hasMoreTokens()) {
        argument_list.add(Integer.valueOf(
                                   st.nextToken()));
      }

      // Zamienia list obiektw w tablic typu podstawowego
      int[] arguments = new int[argument_list.size()];
      for (int i=0; i < argument_list.size(); i++) {
        arguments[i] = ((Integer)argument_list.
                        get(i)).intValue();
      }

      // Wykonuje asercj
      assertEquals(expected, 
                   Largest.largest(arguments));
    }
  }
}
