/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */


public class MyStack {
  public MyStack() {
    stack = new String[100];
    next_index = 0;
  }
  
  public String pop() {
    return stack[--next_index];
  }
  // Usuwa n elementw ze stosu za jednym razem
  public void delete(int n) {
    next_index -= n;
  }
  
  public void push(String aString) {
    stack[next_index++] = aString;
  }

  public String top() {
    return stack[next_index-1];
  }



  public void checkInvariant() 
    throws InvariantException {
    // w JDK 1.4 moemy uy w zamian assert()
    if (!(next_index >= 0 && 
          next_index  < stack.length)) {
      throw new InvariantException(
                           "next_index spoza zakresu: " + 
                           next_index + 
                           " dla stosu o rozmiarze " + 
                           stack.length);
    }
  }

  

  private int next_index;
  private String[] stack;
}

