/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import junit.framework.*;
import java.util.Calendar;

public class TestChecker extends TestCase {
  
  public void testQuittingTime() {

    MockSystemEnvironment env = 
      new MockSystemEnvironment();

    // Konfiguruje czas testu
    Calendar cal = Calendar.getInstance();
    cal.set(Calendar.YEAR, 2004);
    cal.set(Calendar.MONTH, 10);
    cal.set(Calendar.DAY_OF_MONTH, 1);
    cal.set(Calendar.HOUR_OF_DAY, 16);
    cal.set(Calendar.MINUTE, 55);
    long t1 = cal.getTimeInMillis();

    env.setTime(t1);

    Checker checker = new Checker(env);

    // wywouje metod przypomnienia
    checker.reminder();

    // plik dwikowy nie zosta odtworzony
    assertFalse(env.wavWasPlayed());

    // zwiksza czas o 5 minut
    t1 += (5 * 60 * 1000);
    env.setTime(t1);

    // jeszcze raz wywouje metod przypomnienia
    checker.reminder();

    // plik dwikowy powinien zosta odtworzony

    assertTrue(env.wavWasPlayed());

    // resetuje znacznik, aby wykona test raz jeszcze
    env.resetWav();

    // zwiksz czas o 2 godziny i testuje ponownie
    t1 += 2 * 60 * 60 * 1000;
    env.setTime(t1);

    checker.reminder();
    assertTrue(env.wavWasPlayed());
  }
}
