/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */


import junit.framework.*;

/**
 * Bazowa klasa testujca specyficzna dla projektu
 */
public class ProjectTest extends TestCase {

  /**
   * Sprawdza, czy kwota jest okrg sum 
   * wyraon w dolarach (bez centw)
   *
   * @param message Komunikat wywietlany, gdy asercja
   *                  zawiedzie
   * @param amount testowany obiekt typu Money
   *
   */

  public void assertEvenDollars(String message, 
                                Money amount) {
    assertEquals(message, 
          amount.asDouble() - (int)amount.asDouble(), 
          0.0, 
          0.001);
  }

  /**
   * Sprawdza, czy kwota jest okrg sum 
   * wyraon w dolarach (bez centw)
   *
   * @param amount testowany obiekt typu Money
   *
   */

  public void assertEvenDollars(Money amount) {
    assertEvenDollars("", amount);
  }

}
