/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

public interface AVTransport {

  /**
   * Przesuwa biec pozycj tamy 
   * o podan liczb sekund nagrania. 

   * Przekroczenie czasu nagrania spowoduje
   * ustawienie tamy w pozycji EOT.
   */

  public void fastForward(float seconds);

  /**
   * Przesuwa biec pozycj tamy wstecz
   * o podan liczb sekund nagrania. 

   * Przekroczenie pocztku nagrania spowoduje
   * ustawienie tamy w pozycji BOT.
   */
  public void rewind(float seconds);
  
  /**
   * Zwraca biec pozycj tamy
   * wyraon w sekundach nagrania.
   */
  public float currentTimePosition();
  
  /**
   * Oznacza biec pozycj tamy
   * za pomoc podanej etykiety.
   */
  public void markTimePosition(String name);
  
  /**
   * Przesuwa biec pozycj tamy
   * do oznaczonej podan etykiet.
   */
  public void gotoMark(String name);

}
