var Westeros;
(function (Westeros) {
    var Banking;
    (function (Banking) {
        class NaiveBanking {
            constructor() {
                this.state = "";
                this.balance = 0;
            }
            NextState(action, amount) {
                if (this.state == "przekroczone" && action == "wypłata") {
                    this.state = "wstrzymane";
                }
                if (this.state == "wstrzymane" && action != "depozyt") {
                    this.state = "wstrzymane";
                }
                if (this.state == "dobra sytuacja" && action == "wypłata" && amount <= this.balance) {
                    this.balance -= amount;
                }
                if (this.state == "dobra sytuacja" && action == "wypłata" && amount > this.balance) {
                    this.balance -= amount;
                    this.state = "przekroczone";
                }
            }
        }
        class BankAccountManager {
            constructor() {
                this.currentState = new GoodStandingState(this);
            }
            Deposit(amount) {
                this.currentState.Deposit(amount);
            }
            Withdraw(amount) {
                this.currentState.Withdraw(amount);
            }
            addToBalance(amount) {
                this.balance += amount;
            }
            getBalance() {
                return this.balance;
            }
            moveToState(newState) {
                this.currentState = newState;
            }
        }
        Banking.BankAccountManager = BankAccountManager;
        class GoodStandingState {
            constructor(manager) {
                this.manager = manager;
            }
            Deposit(amount) {
                this.manager.addToBalance(amount);
            }
            Withdraw(amount) {
                if (this.manager.getBalance() < amount) {
                    this.manager.moveToState(new OverdrawnState(this.manager));
                }
                this.manager.addToBalance(-1 * amount);
            }
        }
        Banking.GoodStandingState = GoodStandingState;
        class OverdrawnState {
            constructor(manager) {
                this.manager = manager;
            }
            Deposit(amount) {
                this.manager.addToBalance(amount);
                if (this.manager.getBalance() > 0) {
                    this.manager.moveToState(new GoodStandingState(this.manager));
                }
            }
            Withdraw(amount) {
                this.manager.moveToState(new OnHold(this.manager));
                throw "Nie można wypłacić pieniędzy z konta bankowego z już przekroczonym saldem.";
            }
        }
        Banking.OverdrawnState = OverdrawnState;
        class OnHold {
            constructor(manager) {
                this.manager = manager;
            }
            Deposit(amount) {
                this.manager.addToBalance(amount);
                throw "Używane konto zostało zablokowane i konieczna jest wizyta w banku w celu wyjaśnienia tej kwestii.";
            }
            Withdraw(amount) {
                throw "Używane konto zostało zablokowane i konieczna jest wizyta w banku w celu wyjaśnienia tej kwestii.";
            }
        }
        Banking.OnHold = OnHold;
    })(Banking = Westeros.Banking || (Westeros.Banking = {}));
})(Westeros || (Westeros = {}));
